/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.enums.HdxAutoUpdate;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxLibUpgradeUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxLibUpgradeUtils.class);
    private static final String SEPARATOR = " : ";
    private static final int RCL_VERSION_NO_CUSTOMER_INFOS_LENGTH = 10;
    private static final int LIB_VERSION_NOT_FIND = -1;
    private static final String LIB_VERSION_SPC_KEY = "SPC";
    private static final Pattern LIB_NAME_CONTAIN_GPI_PATTERN = Pattern.compile("(?=(GPI))", 2);

    private HdxLibUpgradeUtils() {
    }

    private static boolean checkRclVersionCustomerinfos(String version, String comparedVersion) {
        String versionCustomerinfos = HdxLibUpgradeUtils.getCustomInfoInlVersion(version);
        String comparedVersionCustomerinfos = HdxLibUpgradeUtils.getCustomInfoInlVersion(comparedVersion);
        return StringUtils.equals((CharSequence)versionCustomerinfos, (CharSequence)comparedVersionCustomerinfos);
    }

    public static String getCustomInfoInlVersion(String prodVersion) {
        if (StringUtils.isBlank((CharSequence)prodVersion) || !VersionUtils.isRclVersion(prodVersion)) {
            return "";
        }
        return prodVersion.substring(8, 11);
    }

    public static String getPureRclVersion(String version) {
        if (VersionUtils.isRclVersion(version)) {
            return version.substring(0, 8) + version.substring(11, 13);
        }
        return "";
    }

    public static int compareRclVersion(String version, String comparedVersion, int maxSupportVersionOffset) throws VersionCompareException {
        CommonLibUpgradeUtils.versionIllegal(version, comparedVersion, VersionUtils.isRclVersion(version), VersionUtils.isRclVersion(comparedVersion));
        boolean isSameCustomerinfos = HdxLibUpgradeUtils.checkRclVersionCustomerinfos(version, comparedVersion);
        if (!isSameCustomerinfos) {
            throw new VersionCompareException("customerinfos is not same: " + version + SEPARATOR + comparedVersion);
        }
        String versionNoCustomerinfos = HdxLibUpgradeUtils.getPureRclVersion(version);
        String comparedVersionNoCustomerinfos = HdxLibUpgradeUtils.getPureRclVersion(comparedVersion);
        String upperVersion = StringUtils.upperCase((String)versionNoCustomerinfos);
        String upperComparedVersion = StringUtils.upperCase((String)comparedVersionNoCustomerinfos);
        return CommonLibUpgradeUtils.commonCompareVersion(upperVersion, upperComparedVersion, maxSupportVersionOffset, 10);
    }

    public static int compareRclVersion(String version, String comparedVersion) throws VersionCompareException {
        return HdxLibUpgradeUtils.compareRclVersion(version, comparedVersion, Integer.MIN_VALUE);
    }

    public static int compareSpcVersion(String version, String comparedVersion) throws VersionCompareException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{version, comparedVersion})) {
            throw new VersionCompareException("Illegal parameter");
        }
        int spcIndex = version.indexOf(LIB_VERSION_SPC_KEY);
        if (spcIndex == -1) {
            spcIndex = version.length();
        }
        String upperVersion = version;
        String upperComparedVersion = comparedVersion;
        if (VersionUtils.isVrcVersion(version) && VersionUtils.isVrcVersion(comparedVersion)) {
            upperVersion = StringUtils.upperCase((String)version);
            upperComparedVersion = StringUtils.upperCase((String)comparedVersion);
            upperVersion = CommonLibUpgradeUtils.getRealVrcVersion(upperVersion);
            upperComparedVersion = CommonLibUpgradeUtils.getRealVrcVersion(upperComparedVersion);
        }
        for (int index = 0; index < spcIndex && index < upperComparedVersion.length(); ++index) {
            if (upperVersion.charAt(index) == upperComparedVersion.charAt(index)) continue;
            throw new VersionCompareException("in compareSpcVersion; main version not same");
        }
        return 0;
    }

    public static int compareProdVersionWithAutoUpgrade(CompareLibDto localLib, CompareLibDto onlineLib) throws VersionCompareException {
        HdxLibUpgradeUtils.libNameContainGpi(localLib, onlineLib);
        String localLibAutoUpdateFromMe = localLib.getAutoUpdateFromMe();
        String onlineLibAutoUpdateToMe = onlineLib.getAutoUpdateToMe();
        HdxLibUpgradeUtils.prodVerOneIsAllButOtherNot(localLibAutoUpdateFromMe, onlineLibAutoUpdateToMe);
        String localLibProductVersion = localLib.getProductVersion();
        String onlineLibProductVersion = onlineLib.getProductVersion();
        if (StringUtils.equalsIgnoreCase((CharSequence)localLibAutoUpdateFromMe, (CharSequence)HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel()) && StringUtils.equalsIgnoreCase((CharSequence)onlineLibAutoUpdateToMe, (CharSequence)HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel())) {
            return 0;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)localLibAutoUpdateFromMe, (CharSequence)HdxAutoUpdate.AUTO_UPDATE_1.getLevel()) && StringUtils.equalsIgnoreCase((CharSequence)onlineLibAutoUpdateToMe, (CharSequence)HdxAutoUpdate.AUTO_UPDATE_1.getLevel())) {
            return HdxLibUpgradeUtils.compareSpcVersion(localLibProductVersion, onlineLibProductVersion);
        }
        return HdxLibUpgradeUtils.distinguishProdVerUpdate(localLibAutoUpdateFromMe, onlineLibAutoUpdateToMe, localLibProductVersion, onlineLibProductVersion);
    }

    private static int distinguishProdVerUpdate(String localLibAutoUpdateFromMe, String onlineLibAutoUpdateToMe, String localLibProductVersion, String onlineLibProductVersion) throws VersionCompareException {
        HdxAutoUpdate localLibEnum = HdxAutoUpdate.getMatchedEnum(localLibAutoUpdateFromMe);
        HdxAutoUpdate onlineLibEnum = HdxAutoUpdate.getMatchedEnum(onlineLibAutoUpdateToMe);
        HdxAutoUpdate maxWeightEnum = HdxAutoUpdate.getMaxWeightEnum(localLibEnum, onlineLibEnum);
        if (VersionUtils.isVrcVersion(localLibProductVersion) && VersionUtils.isVrcVersion(onlineLibProductVersion)) {
            return CommonLibUpgradeUtils.compareVrcVersion(localLibProductVersion, onlineLibProductVersion, maxWeightEnum.getVrcOffset());
        }
        if (VersionUtils.isRclVersion(localLibProductVersion) && VersionUtils.isRclVersion(onlineLibProductVersion)) {
            return HdxLibUpgradeUtils.compareRclVersion(localLibProductVersion, onlineLibProductVersion, maxWeightEnum.getRclOffset());
        }
        throw new VersionCompareException("localLib and onlineLib prod version not matched; not all VRC or RCL");
    }

    private static void prodVerOneIsAllButOtherNot(String localLibAutoUpdateFromMe, String onlineLibAutoUpdateToMe) throws VersionCompareException {
        boolean isMatch;
        boolean bl = isMatch = StringUtils.equalsAnyIgnoreCase((CharSequence)localLibAutoUpdateFromMe, (CharSequence[])new CharSequence[]{onlineLibAutoUpdateToMe, HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel()}) && !StringUtils.equalsIgnoreCase((CharSequence)localLibAutoUpdateFromMe, (CharSequence)onlineLibAutoUpdateToMe);
        if (isMatch) {
            throw new VersionCompareException("localLib and onlineLib AutoUpdate not matched; One is 'All',one not");
        }
    }

    private static void libNameContainGpi(CompareLibDto localLib, CompareLibDto onlineLib) throws VersionCompareException {
        String localLibName = localLib.getLibName();
        String onlineLibName = onlineLib.getLibName();
        boolean isGpiInLocalLibName = LIB_NAME_CONTAIN_GPI_PATTERN.matcher(localLibName).find();
        boolean isGpiInOnlineLibName = LIB_NAME_CONTAIN_GPI_PATTERN.matcher(onlineLibName).find();
        if (!(!isGpiInLocalLibName && !isGpiInOnlineLibName || isGpiInLocalLibName && isGpiInOnlineLibName)) {
            throw new VersionCompareException("one libName contains '(GPI)',one not");
        }
    }

    public static List<CompareLibDto> differentAllVersions(String seriesName, List<CompareLibDto> seriesList) {
        List seriesListFilter = seriesList.stream().filter(upgradeDocInfoDto -> upgradeDocInfoDto.getAutoUpdateFromMe().equals(HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(seriesListFilter)) {
            return new ArrayList<CompareLibDto>();
        }
        List upgradeDocInfoDtos = seriesListFilter.stream().filter(upgradeDocInfoDto -> VersionUtils.isLibVersion(upgradeDocInfoDto.getLibVersion())).sorted((upgradeDocInfoDto1, upgradeDocInfoDto2) -> {
            try {
                return CommonLibUpgradeUtils.compareLibVersion(upgradeDocInfoDto2.getLibVersion(), upgradeDocInfoDto1.getLibVersion());
            }
            catch (VersionCompareException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "DifferentAllVersions compareLibVersion has failed, seriesName is {0}", (Throwable)e, new Object[]{seriesName});
                return 0;
            }
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(upgradeDocInfoDtos)) {
            return new ArrayList<CompareLibDto>();
        }
        return upgradeDocInfoDtos.subList(0, 1);
    }
}

