/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.util;

import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsLibUpgradeUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(IcsLibUpgradeUtils.class);

    private IcsLibUpgradeUtils() {
    }

    public static String getDotPureVersion(String productVersion) {
        if (!VersionUtils.isDotVersion(productVersion)) {
            return "";
        }
        int dotCount = 0;
        for (int i = 0; i < productVersion.length(); ++i) {
            if (productVersion.charAt(i) == '.') {
                ++dotCount;
            }
            if (dotCount == 2 && productVersion.charAt(i) == '-') {
                return productVersion.substring(0, i);
            }
            if (dotCount != 3) continue;
            return productVersion.substring(0, i);
        }
        if (dotCount == 1) {
            return productVersion + ".0";
        }
        return productVersion;
    }

    public static int compareDotVersion(String version, String comparedVersion) throws VersionCompareException {
        CommonLibUpgradeUtils.versionIllegal(version, comparedVersion, VersionUtils.isDotVersion(version), VersionUtils.isDotVersion(comparedVersion));
        String pureVersion = IcsLibUpgradeUtils.getDotPureVersion(version);
        String pureComparedVersion = IcsLibUpgradeUtils.getDotPureVersion(comparedVersion);
        String[] pureVersionSplit = pureVersion.split("\\.");
        String[] pureComparedVersionSplit = pureComparedVersion.split("\\.");
        for (int i = 0; i < 2; ++i) {
            int compareResult = Integer.compare(Integer.parseInt(pureVersionSplit[i]), Integer.parseInt(pureComparedVersionSplit[i]));
            if (compareResult == 0) continue;
            return compareResult;
        }
        return IcsLibUpgradeUtils.handlerDotZ(pureVersionSplit[2], pureComparedVersionSplit[2]);
    }

    private static int handlerDotZ(String pureVersionZ, String pureComparedVersionZ) {
        String pureVersionTemp = StringUtils.toRootUpperCase((String)pureVersionZ);
        String pureComparedVersionTemp = StringUtils.toRootUpperCase((String)pureComparedVersionZ);
        int len = Math.min(pureVersionTemp.length(), pureComparedVersionTemp.length());
        int index = 0;
        while (index < len) {
            int compareNum;
            char pureWord = pureVersionTemp.charAt(index);
            char pureComparedWord = pureComparedVersionTemp.charAt(index);
            if (Character.isDigit(pureWord) && Character.isLetter(pureComparedWord) || Character.isLetter(pureWord) && Character.isDigit(pureComparedWord)) {
                return 0;
            }
            if (Character.isLetter(pureWord)) {
                if (pureWord - pureComparedWord != 0) {
                    return 0;
                }
                ++index;
                continue;
            }
            int num = IcsLibUpgradeUtils.getSequenceInteger(index, pureVersionTemp);
            if (num != (compareNum = IcsLibUpgradeUtils.getSequenceInteger(index, pureComparedVersionTemp))) {
                return num > compareNum ? 1 : -1;
            }
            index = index + String.valueOf(num).length() + 1;
        }
        return 0;
    }

    private static int getSequenceInteger(int index, String version) {
        int pureNum = 0;
        int len = version.length();
        while (index < len && Character.isDigit(version.charAt(index))) {
            pureNum = pureNum * 10 + version.charAt(index) - 48;
            ++index;
        }
        return pureNum;
    }
}

