/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.enums.HdxAutoUpdate;
import com.huawei.support.icslite.business.upgradelibcommon.util.HdxLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SeriesLibUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SeriesLibUtils.class);

    public static Map<String, List<CompareLibDto>> serialHdxString(List<CompareLibDto> hdxLocalDtos, boolean isLocal) {
        if (CollectionUtils.isEmpty(hdxLocalDtos)) {
            CodeCCUtils.INSTANCE.warnLog(log, "localDocDos is empty");
            return Collections.emptyMap();
        }
        HashMap<String, List<CompareLibDto>> classifiedHdxContentMap = new HashMap<String, List<CompareLibDto>>();
        hdxLocalDtos.stream().filter(localDocDo -> !StringUtils.equalsAny((CharSequence)localDocDo.getHdxLibType(), (CharSequence[])new CharSequence[]{"1", "2"})).forEach(localDocDo -> {
            String key = SeriesLibUtils.getSerialLibKey(isLocal, localDocDo);
            if (StringUtils.isBlank((CharSequence)key)) {
                return;
            }
            classifiedHdxContentMap.computeIfAbsent(key, value -> new ArrayList()).add(localDocDo);
        });
        return classifiedHdxContentMap;
    }

    private static String getSerialLibKey(boolean isLocal, CompareLibDto localDocDo) {
        String keyLibId = "";
        if (isLocal) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{localDocDo.getAutoUpdateFromMe(), localDocDo.getAutoUpdateToMe()}) || StringUtils.equals((CharSequence)localDocDo.getAutoUpdateFromMe(), (CharSequence)HdxAutoUpdate.AUTO_UPDATE_0.getLevel())) {
                return "";
            }
            if (StringUtils.isBlank((CharSequence)localDocDo.getLibId())) {
                return "";
            }
            keyLibId = "HDXLIBID" + StringUtils.trim((String)localDocDo.getLibId());
        }
        String customInfoInlVersion = HdxLibUpgradeUtils.getCustomInfoInlVersion(localDocDo.getProductVersion()).trim();
        return "HDX" + StringUtils.trimToEmpty((String)localDocDo.getProductName()) + StringUtils.trimToEmpty((String)localDocDo.getLang()) + customInfoInlVersion + StringUtils.trimToEmpty((String)localDocDo.getCustomerName()) + keyLibId;
    }

    public static Map<String, List<CompareLibDto>> serialIcsString(List<CompareLibDto> icsLocalDtos, boolean isLocal) {
        if (CollectionUtils.isEmpty(icsLocalDtos)) {
            CodeCCUtils.INSTANCE.warnLog(log, "localDocDos is empty");
            return Collections.emptyMap();
        }
        return icsLocalDtos.stream().filter(upgradeDocInfoDto -> {
            if (isLocal && StringUtils.equals((CharSequence)upgradeDocInfoDto.getUpgradeType(), (CharSequence)"0")) {
                return false;
            }
            String libVersion = upgradeDocInfoDto.getLibVersion();
            return StringUtils.isBlank((CharSequence)libVersion) || VersionUtils.isLibVersion(libVersion);
        }).collect(Collectors.groupingBy(SeriesLibUtils::fetchGroupKey));
    }

    private static String fetchGroupKey(CompareLibDto icsLocalDto) {
        if (StringUtils.isBlank((CharSequence)icsLocalDto.getLibId())) {
            return icsLocalDto.getProductName() + icsLocalDto.getLibName() + icsLocalDto.getLang();
        }
        return "LIBID" + icsLocalDto.getLibId() + icsLocalDto.getLang() + icsLocalDto.getProductName();
    }
}

