/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.verifylib.dependency;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.util.libentity.constant.LibEntityConstants;
import com.huawei.support.icscbb.util.libentity.dto.LibVerifyDto;
import com.huawei.support.icscbb.verify.service.lmpl.CMSVerifyServiceImpl;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.preferences.serviceimpl.CrlUpdateServiceHandler;
import com.huawei.support.icslite.business.verifylib.dto.VerifyDto;
import com.huawei.support.icslite.business.verifylib.mapper.CMSVerifyConverter;
import java.util.Optional;

public class VerifyDependency
implements LibEntityConstants {
    private LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");

    private VerifyDependency() {
    }

    public static VerifyDependency getInstance() {
        return VerifyDependencyHolder.INSTANCE;
    }

    public Optional<VerifyDto> getOneTaskData() {
        IcsContentDo icsContentDo = this.libManageService.getIcsByVerify();
        if (icsContentDo != null) {
            return Optional.ofNullable(CMSVerifyConverter.INSTANCE.domainDto(icsContentDo));
        }
        HdxContentDo hdxContentDo = this.libManageService.getHdxByVerify();
        if (hdxContentDo != null) {
            return Optional.ofNullable(CMSVerifyConverter.INSTANCE.domainDto(hdxContentDo));
        }
        return Optional.empty();
    }

    public void setVerifyResult(String docId, String verifyResult) {
        this.libManageService.updateVerify(docId, verifyResult);
    }

    public String verify(LibVerifyDto libVerifyDto) {
        return CMSVerifyServiceImpl.getInstance().verify(libVerifyDto);
    }

    public void updateStateIoExceptionToInit() {
        this.libManageService.updateAllVerify("IOException", "Undefined");
    }

    public String getCrlAbsolutePath() {
        return CrlUpdateServiceHandler.getInstance().getCrlAbsolutePath();
    }

    private static class VerifyDependencyHolder {
        private static final VerifyDependency INSTANCE = new VerifyDependency();

        private VerifyDependencyHolder() {
        }
    }
}

