/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.verifylib.task;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.libentity.dto.LibVerifyDto;
import com.huawei.support.icslite.business.verifylib.constant.VerifyLibConstants;
import com.huawei.support.icslite.business.verifylib.dependency.VerifyDependency;
import com.huawei.support.icslite.business.verifylib.dto.VerifyDto;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class VerifyTaskThread
extends Thread
implements VerifyLibConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(VerifyTaskThread.class);
    private final Lock verifyTaskLock = new ReentrantLock();
    private final Condition verifyTaskCondition = this.verifyTaskLock.newCondition();
    private volatile boolean bLoop = true;
    private String taskDocId;
    private volatile boolean bStopOneTask;

    public VerifyTaskThread() {
        super.setName("verifyTaskThread");
        this.setUncaughtExceptionHandler((thisThread, exception) -> CodeCCUtils.INSTANCE.errorLog(LOG, thisThread.getName(), exception));
    }

    public static VerifyTaskThread getInstance() {
        return VerifyTaskThreadHolder.INSTANCE;
    }

    public void toStart() {
        this.bLoop = true;
        this.signal();
    }

    private void await() {
        this.verifyTaskLock.lock();
        try {
            this.verifyTaskCondition.await();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "await: ", (Throwable)e);
        }
        finally {
            this.verifyTaskLock.unlock();
        }
    }

    public void toStop() {
        this.bLoop = false;
        this.signal();
    }

    private void signal() {
        this.verifyTaskLock.lock();
        try {
            this.verifyTaskCondition.signal();
        }
        finally {
            this.verifyTaskLock.unlock();
        }
    }

    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "VerifyTaskThread Thread run start");
        this.await();
        while (this.bLoop) {
            try {
                this.verifyTask();
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "VerifyTaskThread Thread error", (Throwable)e);
            }
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "VerifyTaskThread Thread run end");
    }

    private void verifyTask() {
        Optional<VerifyDto> verifyDtoOpt = VerifyDependency.getInstance().getOneTaskData();
        if (!verifyDtoOpt.isPresent()) {
            VerifyDependency.getInstance().updateStateIoExceptionToInit();
            this.await();
            return;
        }
        VerifyDto verifyDto = verifyDtoOpt.get();
        this.bStopOneTask = false;
        this.taskDocId = verifyDto.getDocId();
        this.verify(verifyDto);
        VerifyDependency.getInstance().setVerifyResult(this.taskDocId, verifyDto.getVerifyResult());
        CodeCCUtils.INSTANCE.infoLog(LOG, String.format(Locale.ENGLISH, "verifyTask, docId:%s, result:%s", this.taskDocId, verifyDto.getVerifyResult()));
    }

    private void verify(VerifyDto verifyDto) {
        if (this.bStopOneTask) {
            return;
        }
        LibVerifyDto libVerifyDto = new LibVerifyDto();
        String crlPath = VerifyDependency.getInstance().getCrlAbsolutePath();
        this.setFileSuffix(verifyDto);
        this.checkEndCharacter(verifyDto);
        this.getAndSetCmsData(verifyDto);
        this.getFileEndIndex(verifyDto);
        if (!verifyDto.isbError()) {
            libVerifyDto.setCrlFilePath(crlPath);
            libVerifyDto.setFilePath(verifyDto.getPath());
            libVerifyDto.setSigDataBytes(verifyDto.getSigDataBytes());
            libVerifyDto.setLibFileEndIndex(verifyDto.getLibFileEndIndex());
            String result = VerifyDependency.getInstance().verify(libVerifyDto);
            verifyDto.setVerifyResult(result);
        }
    }

    private void setFileSuffix(VerifyDto verifyDto) {
        if (this.bStopOneTask || verifyDto.isbError()) {
            return;
        }
        String filePath = verifyDto.getPath();
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "filePath is Empty. docId: " + verifyDto.getDocId());
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
            return;
        }
        if (filePath.toLowerCase(Locale.ENGLISH).endsWith(".hdx")) {
            verifyDto.setZipSuffix("hedex");
        } else if (filePath.toLowerCase(Locale.ENGLISH).endsWith(".hwics")) {
            verifyDto.setZipSuffix("hwics");
        } else {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Unable to find information related to cms authentication.docId: " + verifyDto.getDocId());
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
        }
    }

    private void checkEndCharacter(VerifyDto verifyDto) {
        if (this.bStopOneTask || verifyDto.isbError()) {
            return;
        }
        String filePath = verifyDto.getPath();
        File file = FileUtils.getFile((String[])new String[]{filePath});
        long fileLength = file.length();
        verifyDto.setFileLength(fileLength);
        String docId = verifyDto.getDocId();
        long start = verifyDto.getFileLength() - 5L;
        byte[] endCharacterBytes = IcsFileUtils.getFileBytes((String)filePath, (long)start, (int)5);
        if (endCharacterBytes == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Unable to get endCharacterBytes. docId: " + verifyDto.getDocId());
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
            return;
        }
        String readTextSub = new String(endCharacterBytes, Charset.defaultCharset());
        if (!StringUtils.startsWithIgnoreCase((CharSequence)readTextSub, (CharSequence)verifyDto.getZipSuffix())) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "The suffix appended to the end of the file does not match the file suffix.docId: " + docId);
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
        }
    }

    private void getAndSetCmsData(VerifyDto verifyDto) {
        if (this.bStopOneTask || verifyDto.isbError()) {
            return;
        }
        this.getAndSetCmsLen(verifyDto);
        this.sigDataBytes(verifyDto);
    }

    private void getAndSetCmsLen(VerifyDto verifyDto) {
        long start;
        if (this.bStopOneTask || verifyDto.isbError()) {
            return;
        }
        String filePath = verifyDto.getPath();
        byte[] cmsLenBytes = IcsFileUtils.getFileBytes((String)filePath, (long)(start = verifyDto.getFileLength() - 21L), (int)16);
        if (cmsLenBytes == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Unable to get cms hexadecimal information. docId: " + verifyDto.getDocId());
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
            return;
        }
        String readTextSub = new String(cmsLenBytes, Charset.defaultCharset());
        long cmsLen = 0L;
        try {
            cmsLen = Long.parseLong(readTextSub, 16);
        }
        catch (NumberFormatException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "CMS length conversion exception. docId:" + verifyDto.getDocId(), (Throwable)e);
            verifyDto.setbError(true);
            return;
        }
        verifyDto.setCmsLength(cmsLen);
    }

    private void sigDataBytes(VerifyDto verifyDto) {
        if (this.bStopOneTask || verifyDto.isbError()) {
            return;
        }
        String filePath = verifyDto.getPath();
        long cmsLength = verifyDto.getCmsLength();
        long start = verifyDto.getFileLength() - cmsLength - 21L;
        if (start <= 0L) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "The recorded cmsLength exceeds the length of the file. docId: " + verifyDto.getDocId());
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
            return;
        }
        byte[] sigDataBytes = IcsFileUtils.getFileBytes((String)filePath, (long)start, (int)((int)cmsLength));
        if (sigDataBytes == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Unable to get cms sigDataBytes. docId: " + verifyDto.getDocId());
            verifyDto.setVerifyResult("None");
            verifyDto.setbError(true);
            return;
        }
        verifyDto.setSigDataBytes(sigDataBytes);
    }

    private void getFileEndIndex(VerifyDto verifyDto) {
        if (this.bStopOneTask || verifyDto.isbError()) {
            return;
        }
        long cmsLength = verifyDto.getCmsLength();
        long fileLength = verifyDto.getFileLength();
        long subLen = Math.subtractExact(fileLength, cmsLength);
        verifyDto.setLibFileEndIndex(subLen - 21L - 1L - 2L);
    }

    public void stopOneTask(String docId) {
        if (docId.equals(this.taskDocId)) {
            this.bStopOneTask = true;
        }
    }

    private static class VerifyTaskThreadHolder {
        private static final VerifyTaskThread INSTANCE = new VerifyTaskThread();

        private VerifyTaskThreadHolder() {
        }
    }
}

