/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.websocket;

import com.huawei.support.icslite.business.websocket.service.WebsocketMessageService;
import com.huawei.support.icslite.business.websocket.service.impl.BatchDlMessageImpl;
import com.huawei.support.icslite.business.websocket.service.impl.ChooseDlDirMessageImpl;
import com.huawei.support.icslite.business.websocket.service.impl.DefaultDlDirMessageImpl;
import com.huawei.support.icslite.business.websocket.service.impl.DlServerHoupMessageImpl;
import com.huawei.support.icslite.business.websocket.service.impl.DlServerMessageImpl;
import com.huawei.support.icslite.business.websocket.service.impl.RepeatTaskValidMessageImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WebsocketMessageFactory {
    private Map<String, WebsocketMessageService> wsMsgBaseMap = new ConcurrentHashMap<String, WebsocketMessageService>();

    private WebsocketMessageFactory() {
        this.init();
    }

    public static WebsocketMessageFactory getInstance() {
        return WstMsgFactoryHandlerHolder.INSTANCE;
    }

    public WebsocketMessageService getWsMsg(String msgType) {
        return this.wsMsgBaseMap.get(msgType);
    }

    private void init() {
        this.wsMsgBaseMap.put("support_dl", new BatchDlMessageImpl());
        this.wsMsgBaseMap.put("support_repeat_task", new RepeatTaskValidMessageImpl());
        this.wsMsgBaseMap.put("support_choose_dir", new ChooseDlDirMessageImpl());
        this.wsMsgBaseMap.put("support_default_dir", new DefaultDlDirMessageImpl());
        this.wsMsgBaseMap.put("support_websocket_server_version", new DlServerMessageImpl());
        this.wsMsgBaseMap.put("support_websocket_houp_server_version", new DlServerHoupMessageImpl());
    }

    private static class WstMsgFactoryHandlerHolder {
        private static final WebsocketMessageFactory INSTANCE = new WebsocketMessageFactory();

        private WstMsgFactoryHandlerHolder() {
        }
    }
}

