/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.websocket.service.impl;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.downloadmanage.service.impl.DownloadOperationServiceHandler;
import com.huawei.support.icslite.business.websocket.service.WebsocketMessageService;
import com.huawei.support.icslite.business.websocket.service.dto.WebsocketDlQueryDto;
import com.huawei.support.icslite.business.websocket.service.dto.WebsocketMessageDto;
import com.huawei.support.icslite.business.websocket.service.dto.mapper.WebsocketQueryConverter;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class BatchDlMessageImpl
implements WebsocketMessageService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(BatchDlMessageImpl.class);

    @Override
    public WebsocketMessageDto process(String message) {
        List supportDlWsQueries = JSON.parseArray((String)message, WebsocketDlQueryDto.class);
        List<DownloadSingleTaskDto> downloadSingleTaskDtos = supportDlWsQueries.stream().map(WebsocketQueryConverter.INSTANCE::domain2dto).collect(Collectors.toList());
        try {
            String downloadPageUrl = String.format(Locale.ENGLISH, "http://%s:%s/icslite/#hash=downloadmanage", ConfigServiceHandler.getInstance().get("system.open.httpIpInfo"), ConfigServiceHandler.getInstance().get("system.http.port"));
            Desktop.getDesktop().browse(new URI(downloadPageUrl));
        }
        catch (IOException | URISyntaxException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Batch download task error.", (Throwable)e);
        }
        return new WebsocketMessageDto("support_dl", Boolean.toString(DownloadOperationServiceHandler.getInstance().addTasks(downloadSingleTaskDtos)));
    }
}

