/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.websocket.utils;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.common.resources.utils.CmdCharacterUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.common.utils.WinRegistryUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class WebsocketRegistryUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(WebsocketRegistryUtils.class);
    private static final String URL_PROTOCOL_REG_ROOT = "HKEY_CURRENT_USER" + File.separator + "Software" + File.separator + "Classes" + File.separator + "HWToolICSLite";
    private static final String ICS_LITE_URL_PROTOCOL_REG_ROOT_URL_PROTOCOL = "URL Protocol";
    private static final String ICS_LITE_URL_PROTOCOL_REG_ROOT_URL_PROTOCOL_LAUNCHER = "URL:HWToolICSLite Launcher";
    private static final String ICS_LITE_URL_PROTOCOL_REG_SUBKEY_DEFAULT = URL_PROTOCOL_REG_ROOT + File.separator + "DefaultIcon";
    private static final String ICS_LITE_URL_PROTOCOL_REG_SUBKEY_SHELL_OPEN_COMMAND = URL_PROTOCOL_REG_ROOT + File.separator + "shell" + File.separator + "open" + File.separator + "command";
    private static final String STARTUP_ICON = ",1";

    public static void writeUrlProtocolRegData() {
        String registryValueContent = WinRegistryUtil.queryDefaultWinRegistryValueContent((String)ICS_LITE_URL_PROTOCOL_REG_SUBKEY_SHELL_OPEN_COMMAND, (String)"REG_SZ");
        String autoRunPath = CmdCharacterUtils.getIcsLiteStartPath((String)IcsCommonServiceHandler.getInstance().getStartupExePath()) + " " + "ICSLiteDlStart";
        WebsocketRegistryUtils.writeRegData(registryValueContent, autoRunPath);
        WinRegistryUtil.deleteBranch((String)("HKEY_CLASSES_ROOT" + File.separator + "HWICSLite"));
    }

    private static void writeRegData(String registryValueContent, String exeRunPath) {
        if (StringUtils.isBlank((CharSequence)registryValueContent)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Create ICS Lite url protocol reg.");
            WinRegistryUtil.modifyWinRegistry((String)URL_PROTOCOL_REG_ROOT, (String)ICS_LITE_URL_PROTOCOL_REG_ROOT_URL_PROTOCOL, (String)"REG_SZ", (String)"");
            WinRegistryUtil.modifyWinDefaultRegistry((String)URL_PROTOCOL_REG_ROOT, (String)"REG_SZ", (String)ICS_LITE_URL_PROTOCOL_REG_ROOT_URL_PROTOCOL_LAUNCHER);
            WinRegistryUtil.modifyWinDefaultRegistry((String)ICS_LITE_URL_PROTOCOL_REG_SUBKEY_DEFAULT, (String)"REG_SZ", (String)(IcsCommonServiceHandler.getInstance().getStartupExePath() + STARTUP_ICON));
            WinRegistryUtil.modifyWinDefaultRegistry((String)ICS_LITE_URL_PROTOCOL_REG_SUBKEY_SHELL_OPEN_COMMAND, (String)"REG_SZ", (String)exeRunPath);
        } else {
            WebsocketRegistryUtils.updateRegData(registryValueContent, exeRunPath);
        }
    }

    private static void updateRegData(String registryValueContent, String exeRunPath) {
        if (StringUtils.startsWith((CharSequence)registryValueContent.replace("\"", "\\\""), (CharSequence)exeRunPath)) {
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "Update reg. ICS Lite version is difference.");
        WinRegistryUtil.modifyWinDefaultRegistry((String)ICS_LITE_URL_PROTOCOL_REG_SUBKEY_DEFAULT, (String)"REG_SZ", (String)(IcsCommonServiceHandler.getInstance().getStartupExePath() + STARTUP_ICON));
        WinRegistryUtil.modifyWinDefaultRegistry((String)ICS_LITE_URL_PROTOCOL_REG_SUBKEY_SHELL_OPEN_COMMAND, (String)"REG_SZ", (String)exeRunPath);
    }
}

