/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.List;
import javax.crypto.JceSecurity;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.jca.GetInstance;
import sun.security.jca.JCAUtil;
import sun.security.util.Debug;

public class KeyGenerator {
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("keygenerator");
    private static final int I_NONE = 1;
    private static final int I_RANDOM = 2;
    private static final int I_PARAMS = 3;
    private static final int I_SIZE = 4;
    private Provider provider;
    private volatile KeyGeneratorSpi spi;
    private final String algorithm;
    private final Object lock = new Object();
    private Iterator<Provider.Service> serviceIterator;
    private int initType;
    private int initKeySize;
    private AlgorithmParameterSpec initParams;
    private SecureRandom initRandom;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String string) {
        this.spi = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
        if (!skipDebug && pdebug != null) {
            pdebug.println("KeyGenerator." + string + " algorithm from: " + this.provider.getName());
        }
    }

    private KeyGenerator(String string) throws NoSuchAlgorithmException {
        this.algorithm = string;
        List<Provider.Service> list = GetInstance.getServices("KeyGenerator", string);
        this.serviceIterator = list.iterator();
        this.initType = 1;
        if (this.nextSpi(null, false) == null) {
            throw new NoSuchAlgorithmException(string + " KeyGenerator not available");
        }
        if (!skipDebug && pdebug != null) {
            pdebug.println("KeyGenerator." + string + " algorithm from: " + this.provider.getName());
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        return new KeyGenerator(string);
    }

    public static final KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = JceSecurity.getInstance("KeyGenerator", KeyGeneratorSpi.class, string, string2);
        return new KeyGenerator((KeyGeneratorSpi)instance.impl, instance.provider, string);
    }

    public static final KeyGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = JceSecurity.getInstance("KeyGenerator", KeyGeneratorSpi.class, string, provider);
        return new KeyGenerator((KeyGeneratorSpi)instance.impl, instance.provider, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Provider getProvider() {
        Object object = this.lock;
        synchronized (object) {
            this.disableFailover();
            return this.provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyGeneratorSpi nextSpi(KeyGeneratorSpi keyGeneratorSpi, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (keyGeneratorSpi != null && keyGeneratorSpi != this.spi) {
                return this.spi;
            }
            if (this.serviceIterator == null) {
                return null;
            }
            while (this.serviceIterator.hasNext()) {
                Provider.Service service = this.serviceIterator.next();
                if (!JceSecurity.canUseProvider(service.getProvider())) continue;
                try {
                    Object object2 = service.newInstance(null);
                    if (!(object2 instanceof KeyGeneratorSpi)) continue;
                    KeyGeneratorSpi keyGeneratorSpi2 = (KeyGeneratorSpi)object2;
                    if (bl) {
                        if (this.initType == 4) {
                            keyGeneratorSpi2.engineInit(this.initKeySize, this.initRandom);
                        } else if (this.initType == 3) {
                            keyGeneratorSpi2.engineInit(this.initParams, this.initRandom);
                        } else if (this.initType == 2) {
                            keyGeneratorSpi2.engineInit(this.initRandom);
                        } else if (this.initType != 1) {
                            throw new AssertionError((Object)("KeyGenerator initType: " + this.initType));
                        }
                    }
                    this.provider = service.getProvider();
                    this.spi = keyGeneratorSpi2;
                    return keyGeneratorSpi2;
                }
                catch (Exception exception) {
                }
            }
            this.disableFailover();
            return null;
        }
    }

    void disableFailover() {
        this.serviceIterator = null;
        this.initType = 0;
        this.initParams = null;
        this.initRandom = null;
    }

    public final void init(SecureRandom secureRandom) {
        if (this.serviceIterator == null) {
            this.spi.engineInit(secureRandom);
            return;
        }
        RuntimeException runtimeException = null;
        KeyGeneratorSpi keyGeneratorSpi = this.spi;
        while (true) {
            try {
                keyGeneratorSpi.engineInit(secureRandom);
                this.initType = 2;
                this.initKeySize = 0;
                this.initParams = null;
                this.initRandom = secureRandom;
                return;
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
                if ((keyGeneratorSpi = this.nextSpi(keyGeneratorSpi, false)) != null) continue;
                throw runtimeException;
            }
            break;
        }
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.init(algorithmParameterSpec, JCAUtil.getSecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (this.serviceIterator == null) {
            this.spi.engineInit(algorithmParameterSpec, secureRandom);
            return;
        }
        Exception exception = null;
        KeyGeneratorSpi keyGeneratorSpi = this.spi;
        while (true) {
            try {
                keyGeneratorSpi.engineInit(algorithmParameterSpec, secureRandom);
                this.initType = 3;
                this.initKeySize = 0;
                this.initParams = algorithmParameterSpec;
                this.initRandom = secureRandom;
                return;
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyGeneratorSpi = this.nextSpi(keyGeneratorSpi, false)) != null) continue;
                if (exception instanceof InvalidAlgorithmParameterException) {
                    throw (InvalidAlgorithmParameterException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new InvalidAlgorithmParameterException("init() failed", exception);
            }
            break;
        }
    }

    public final void init(int n) {
        this.init(n, JCAUtil.getSecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        if (this.serviceIterator == null) {
            this.spi.engineInit(n, secureRandom);
            return;
        }
        RuntimeException runtimeException = null;
        KeyGeneratorSpi keyGeneratorSpi = this.spi;
        while (true) {
            try {
                keyGeneratorSpi.engineInit(n, secureRandom);
                this.initType = 4;
                this.initKeySize = n;
                this.initParams = null;
                this.initRandom = secureRandom;
                return;
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
                if ((keyGeneratorSpi = this.nextSpi(keyGeneratorSpi, false)) != null) continue;
                throw runtimeException;
            }
            break;
        }
    }

    public final SecretKey generateKey() {
        if (this.serviceIterator == null) {
            return this.spi.engineGenerateKey();
        }
        RuntimeException runtimeException = null;
        KeyGeneratorSpi keyGeneratorSpi = this.spi;
        while (true) {
            try {
                return keyGeneratorSpi.engineGenerateKey();
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
                if ((keyGeneratorSpi = this.nextSpi(keyGeneratorSpi, true)) != null) continue;
                throw runtimeException;
            }
            break;
        }
    }
}

