/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.icsspringvalidate.exception.handler.lite;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.response.ResultCode;
import com.huawei.support.icscbb.util.response.ServiceResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final Integer SSL_EXCEPTION_CODE = 40316;

    @ExceptionHandler(value={CustomSslException.class})
    public void handleBindException(HandlerMethod handlerMethod, HttpServletResponse httpServletResponse) {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "{0}: SSL Certificate Verification error.", new Object[]{handlerMethod.getMethod().getName()});
        String sslVerify = httpServletResponse.getHeader("SSL-Verify");
        if (StringUtils.equalsIgnoreCase((CharSequence)sslVerify, (CharSequence)"yes") && this.isRestRequest(handlerMethod)) {
            httpServletResponse.setStatus(SSL_EXCEPTION_CODE.intValue());
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public ModelAndView handleBindException(HandlerMethod handlerMethod, BindException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Binding parameter error.", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.BAD_REQUEST, ResultCode.BINDING_ERROR);
        }
        httpServletResponse.setStatus(HttpStatus.BAD_REQUEST.value());
        return this.pageHandler(httpServletResponse, HttpStatus.BAD_REQUEST);
    }

    private boolean isRestRequest(HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        Class beanType = handlerMethod.getBeanType();
        return method.getAnnotation(ResponseBody.class) != null || beanType.getAnnotation(ResponseBody.class) != null || beanType.getAnnotation(RestController.class) != null;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ModelAndView handleHttpMessageNotReadableException(HandlerMethod handlerMethod, HttpMessageNotReadableException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to read the request parameter.", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.BAD_REQUEST, ResultCode.READ_ERROR);
        }
        httpServletResponse.setStatus(HttpStatus.BAD_REQUEST.value());
        return this.pageHandler(httpServletResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ModelAndView handleMethodArgumentNotValidException(HandlerMethod handlerMethod, MethodArgumentNotValidException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Json validation error.", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.BAD_REQUEST, ResultCode.JSON_VALIDATION_ERROR);
        }
        httpServletResponse.setStatus(HttpStatus.BAD_REQUEST.value());
        return this.pageHandler(httpServletResponse, HttpStatus.BAD_REQUEST);
    }

    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ModelAndView handleHttpRequestMethodNotSupportedException(HandlerMethod handlerMethod, HttpRequestMethodNotSupportedException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Method Not Allowed", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.METHOD_NOT_ALLOWED, ResultCode.METHOD_ERROR);
        }
        httpServletResponse.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
        return this.pageHandler(httpServletResponse, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ModelAndView handleHttpMediaTypeNotSupportedException(HandlerMethod handlerMethod, HttpMediaTypeNotSupportedException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "content-type error", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.UNSUPPORTED_MEDIA_TYPE, ResultCode.CONTENT_ERROR);
        }
        httpServletResponse.setStatus(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value());
        return this.pageHandler(httpServletResponse, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ModelAndView handleConstraintViolationException(HandlerMethod handlerMethod, ConstraintViolationException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.BAD_REQUEST, ResultCode.BINDING_ERROR);
        }
        return this.pageHandler(httpServletResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidPropertyException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ModelAndView handleInvalidPropertyException(HandlerMethod handlerMethod, InvalidPropertyException exception, HttpServletResponse httpServletResponse) throws IOException {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Invalid property name", (Throwable)exception);
        if (this.isRestRequest(handlerMethod)) {
            return this.restHandler(httpServletResponse, HttpStatus.BAD_REQUEST, ResultCode.BINDING_ERROR);
        }
        return this.pageHandler(httpServletResponse, HttpStatus.BAD_REQUEST);
    }

    private ModelAndView pageHandler(HttpServletResponse httpServletResponse, HttpStatus httpStatus) {
        ModelAndView mav = new ModelAndView();
        httpServletResponse.setStatus(httpStatus.value());
        mav.setViewName("error/errorpage");
        return mav;
    }

    private ModelAndView restHandler(HttpServletResponse httpServletResponse, HttpStatus httpStatus, ResultCode resultCode) throws IOException {
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json; charset=utf-8");
        httpServletResponse.setStatus(httpStatus.value());
        try (PrintWriter writer = httpServletResponse.getWriter();){
            writer.write(JSON.toJSONString((Object)ServiceResponse.getServiceResponse((String)resultCode.getRsultMsg(), (int)resultCode.getReusltCode())));
            writer.flush();
        }
        return null;
    }
}

