/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.icsspringvalidate.exception.handler.web;

import java.util.HashMap;
import java.util.Map;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleConstraintViolationException(ConstraintViolationException exception) {
        return "Illegal Parameter.";
    }

    public Map<String, String> handleConstraintViolation(ConstraintViolationException exception) {
        HashMap<String, String> msg = new HashMap<String, String>();
        for (ConstraintViolation constraintViolation : exception.getConstraintViolations()) {
            PathImpl pathImpl = (PathImpl)constraintViolation.getPropertyPath();
            String paramName = pathImpl.getLeafNode().getName();
            String message = constraintViolation.getMessage();
            msg.put(paramName, message);
        }
        return msg;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleValidationException(MethodArgumentNotValidException exception) {
        return "Illegal Parameter.";
    }

    public Map<String, String> handleValidation(MethodArgumentNotValidException exception) {
        HashMap<String, String> msg = new HashMap<String, String>();
        BindingResult bindingResult = exception.getBindingResult();
        for (ObjectError error : bindingResult.getAllErrors()) {
            FieldError fieldError = (FieldError)error;
            String objectName = fieldError.getObjectName();
            String file = fieldError.getField();
            String defaultMessage = fieldError.getDefaultMessage();
            msg.put(objectName + "." + file, defaultMessage);
        }
        return msg;
    }
}

