/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.reflection.invoker.AmbiguousMethodInvoker;
import org.apache.ibatis.reflection.invoker.GetFieldInvoker;
import org.apache.ibatis.reflection.invoker.Invoker;
import org.apache.ibatis.reflection.invoker.MethodInvoker;
import org.apache.ibatis.reflection.invoker.SetFieldInvoker;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.ibatis.util.MapUtil;

public class Reflector {
    private static final MethodHandle isRecordMethodHandle = Reflector.getIsRecordMethodHandle();
    private final Class<?> type;
    private final String[] readablePropertyNames;
    private final String[] writablePropertyNames;
    private final Map<String, Invoker> setMethods = new HashMap<String, Invoker>();
    private final Map<String, Invoker> getMethods = new HashMap<String, Invoker>();
    private final Map<String, Class<?>> setTypes = new HashMap();
    private final Map<String, Class<?>> getTypes = new HashMap();
    private Constructor<?> defaultConstructor;
    private final Map<String, String> caseInsensitivePropertyMap = new HashMap<String, String>();

    public Reflector(Class<?> clazz) {
        this.type = clazz;
        this.addDefaultConstructor(clazz);
        Method[] classMethods = this.getClassMethods(clazz);
        if (Reflector.isRecord(this.type)) {
            this.addRecordGetMethods(classMethods);
        } else {
            this.addGetMethods(classMethods);
            this.addSetMethods(classMethods);
            this.addFields(clazz);
        }
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[0]);
        this.writablePropertyNames = this.setMethods.keySet().toArray(new String[0]);
        for (String propName : this.readablePropertyNames) {
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
        }
        for (String propName : this.writablePropertyNames) {
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
        }
    }

    private void addRecordGetMethods(Method[] methods) {
        Arrays.stream(methods).filter(m -> m.getParameterTypes().length == 0).forEach(m -> this.addGetMethod(m.getName(), (Method)m, false));
    }

    private void addDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Arrays.stream(constructors).filter(constructor -> constructor.getParameterTypes().length == 0).findAny().ifPresent(constructor -> {
            this.defaultConstructor = constructor;
        });
    }

    private void addGetMethods(Method[] methods) {
        HashMap<String, List<Method>> conflictingGetters = new HashMap<String, List<Method>>();
        Arrays.stream(methods).filter(m -> m.getParameterTypes().length == 0 && PropertyNamer.isGetter(m.getName())).forEach(m -> this.addMethodConflict((Map<String, List<Method>>)conflictingGetters, PropertyNamer.methodToProperty(m.getName()), (Method)m));
        this.resolveGetterConflicts(conflictingGetters);
    }

    private void resolveGetterConflicts(Map<String, List<Method>> conflictingGetters) {
        for (Map.Entry<String, List<Method>> entry : conflictingGetters.entrySet()) {
            Method winner = null;
            String propName = entry.getKey();
            boolean isAmbiguous = false;
            for (Method candidate : entry.getValue()) {
                if (winner == null) {
                    winner = candidate;
                    continue;
                }
                Class<?> winnerType = winner.getReturnType();
                Class<?> candidateType = candidate.getReturnType();
                if (candidateType.equals(winnerType)) {
                    if (!Boolean.TYPE.equals(candidateType)) {
                        isAmbiguous = true;
                        break;
                    }
                    if (!candidate.getName().startsWith("is")) continue;
                    winner = candidate;
                    continue;
                }
                if (candidateType.isAssignableFrom(winnerType)) continue;
                if (winnerType.isAssignableFrom(candidateType)) {
                    winner = candidate;
                    continue;
                }
                isAmbiguous = true;
                break;
            }
            this.addGetMethod(propName, winner, isAmbiguous);
        }
    }

    private void addGetMethod(String name, Method method, boolean isAmbiguous) {
        MethodInvoker invoker = isAmbiguous ? new AmbiguousMethodInvoker(method, MessageFormat.format("Illegal overloaded getter method with ambiguous type for property ''{0}'' in class ''{1}''. This breaks the JavaBeans specification and can cause unpredictable results.", name, method.getDeclaringClass().getName())) : new MethodInvoker(method);
        this.getMethods.put(name, invoker);
        Type returnType = TypeParameterResolver.resolveReturnType(method, this.type);
        this.getTypes.put(name, this.typeToClass(returnType));
    }

    private void addSetMethods(Method[] methods) {
        HashMap<String, List<Method>> conflictingSetters = new HashMap<String, List<Method>>();
        Arrays.stream(methods).filter(m -> m.getParameterTypes().length == 1 && PropertyNamer.isSetter(m.getName())).forEach(m -> this.addMethodConflict((Map<String, List<Method>>)conflictingSetters, PropertyNamer.methodToProperty(m.getName()), (Method)m));
        this.resolveSetterConflicts(conflictingSetters);
    }

    private void addMethodConflict(Map<String, List<Method>> conflictingMethods, String name, Method method) {
        if (this.isValidPropertyName(name)) {
            List list = MapUtil.computeIfAbsent(conflictingMethods, name, k -> new ArrayList());
            list.add(method);
        }
    }

    private void resolveSetterConflicts(Map<String, List<Method>> conflictingSetters) {
        for (Map.Entry<String, List<Method>> entry : conflictingSetters.entrySet()) {
            String propName = entry.getKey();
            List<Method> setters = entry.getValue();
            Class<?> getterType = this.getTypes.get(propName);
            boolean isGetterAmbiguous = this.getMethods.get(propName) instanceof AmbiguousMethodInvoker;
            boolean isSetterAmbiguous = false;
            Method match = null;
            for (Method setter : setters) {
                if (!isGetterAmbiguous && setter.getParameterTypes()[0].equals(getterType)) {
                    match = setter;
                    break;
                }
                if (isSetterAmbiguous) continue;
                isSetterAmbiguous = (match = this.pickBetterSetter(match, setter, propName)) == null;
            }
            if (match == null) continue;
            this.addSetMethod(propName, match);
        }
    }

    private Method pickBetterSetter(Method setter1, Method setter2, String property) {
        Class<?> paramType2;
        if (setter1 == null) {
            return setter2;
        }
        Class<?> paramType1 = setter1.getParameterTypes()[0];
        if (paramType1.isAssignableFrom(paramType2 = setter2.getParameterTypes()[0])) {
            return setter2;
        }
        if (paramType2.isAssignableFrom(paramType1)) {
            return setter1;
        }
        AmbiguousMethodInvoker invoker = new AmbiguousMethodInvoker(setter1, MessageFormat.format("Ambiguous setters defined for property ''{0}'' in class ''{1}'' with types ''{2}'' and ''{3}''.", property, setter2.getDeclaringClass().getName(), paramType1.getName(), paramType2.getName()));
        this.setMethods.put(property, invoker);
        Type[] paramTypes = TypeParameterResolver.resolveParamTypes(setter1, this.type);
        this.setTypes.put(property, this.typeToClass(paramTypes[0]));
        return null;
    }

    private void addSetMethod(String name, Method method) {
        MethodInvoker invoker = new MethodInvoker(method);
        this.setMethods.put(name, invoker);
        Type[] paramTypes = TypeParameterResolver.resolveParamTypes(method, this.type);
        this.setTypes.put(name, this.typeToClass(paramTypes[0]));
    }

    private Class<?> typeToClass(Type src) {
        Class<?> result = null;
        if (src instanceof Class) {
            result = (Class<?>)src;
        } else if (src instanceof ParameterizedType) {
            result = (Class<?>)((ParameterizedType)src).getRawType();
        } else if (src instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)src).getGenericComponentType();
            if (componentType instanceof Class) {
                result = Array.newInstance((Class)componentType, 0).getClass();
            } else {
                Class<?> componentClass = this.typeToClass(componentType);
                result = Array.newInstance(componentClass, 0).getClass();
            }
        }
        if (result == null) {
            result = Object.class;
        }
        return result;
    }

    private void addFields(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (!(this.setMethods.containsKey(field.getName()) || Modifier.isFinal(modifiers = field.getModifiers()) && Modifier.isStatic(modifiers))) {
                this.addSetField(field);
            }
            if (this.getMethods.containsKey(field.getName())) continue;
            this.addGetField(field);
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    private void addSetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.setMethods.put(field.getName(), new SetFieldInvoker(field));
            Type fieldType = TypeParameterResolver.resolveFieldType(field, this.type);
            this.setTypes.put(field.getName(), this.typeToClass(fieldType));
        }
    }

    private void addGetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.getMethods.put(field.getName(), new GetFieldInvoker(field));
            Type fieldType = TypeParameterResolver.resolveFieldType(field, this.type);
            this.getTypes.put(field.getName(), this.typeToClass(fieldType));
        }
    }

    private boolean isValidPropertyName(String name) {
        return !name.startsWith("$") && !"serialVersionUID".equals(name) && !"class".equals(name);
    }

    private Method[] getClassMethods(Class<?> clazz) {
        HashMap<String, Method> uniqueMethods = new HashMap<String, Method>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces;
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            for (Class<?> anInterface : interfaces = currentClass.getInterfaces()) {
                this.addUniqueMethods(uniqueMethods, anInterface.getMethods());
            }
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[0]);
    }

    private void addUniqueMethods(Map<String, Method> uniqueMethods, Method[] methods) {
        for (Method currentMethod : methods) {
            String signature;
            if (currentMethod.isBridge() || uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) continue;
            uniqueMethods.put(signature, currentMethod);
        }
    }

    private String getSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        Class<?> returnType = method.getReturnType();
        if (returnType != null) {
            sb.append(returnType.getName()).append('#');
        }
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(i == 0 ? (char)':' : ',').append(parameters[i].getName());
        }
        return sb.toString();
    }

    public static boolean canControlMemberAccessible() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Constructor<?> getDefaultConstructor() {
        if (this.defaultConstructor != null) {
            return this.defaultConstructor;
        }
        throw new ReflectionException("There is no default constructor for " + this.type);
    }

    public boolean hasDefaultConstructor() {
        return this.defaultConstructor != null;
    }

    public Invoker getSetInvoker(String propertyName) {
        Invoker method = this.setMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Invoker getGetInvoker(String propertyName) {
        Invoker method = this.getMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Class<?> getSetterType(String propertyName) {
        Class<?> clazz = this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public Class<?> getGetterType(String propertyName) {
        Class<?> clazz = this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public String[] getGetablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getSetablePropertyNames() {
        return this.writablePropertyNames;
    }

    public boolean hasSetter(String propertyName) {
        return this.setMethods.containsKey(propertyName);
    }

    public boolean hasGetter(String propertyName) {
        return this.getMethods.containsKey(propertyName);
    }

    public String findPropertyName(String name) {
        return this.caseInsensitivePropertyMap.get(name.toUpperCase(Locale.ENGLISH));
    }

    private static boolean isRecord(Class<?> clazz) {
        try {
            return isRecordMethodHandle != null && isRecordMethodHandle.invokeExact(clazz);
        }
        catch (Throwable e) {
            throw new ReflectionException("Failed to invoke 'Class.isRecord()'.", e);
        }
    }

    private static MethodHandle getIsRecordMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Boolean.TYPE);
        try {
            return lookup.findVirtual(Class.class, "isRecord", mt);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }
}

