/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.dao;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class HdxBaseDaoHandler
extends BasePool<Map<String, HdxContentDo>>
implements HdxLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxBaseDaoHandler.class);

    private HdxBaseDaoHandler() {
    }

    public static HdxBaseDaoHandler getInstance() {
        return HdxBaseDaoHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    public void addPool(HdxContentDo hdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "addPool");
        if (!"0".equals(hdx.getLibType())) {
            return;
        }
        String key = this.getKey(hdx);
        HashMap<String, HdxContentDo> baseList = (HashMap<String, HdxContentDo>)super.getPool(key);
        if (baseList == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "HdxBaseDao addPool");
            baseList = new HashMap<String, HdxContentDo>();
            super.addPool(key, baseList);
        }
        baseList.put(this.getSecondKey(hdx), hdx);
    }

    public void delPool(HdxContentDo hdx) {
        if (!"0".equals(hdx.getLibType())) {
            return;
        }
        super.delPool(this.getKey(hdx));
    }

    private List<HdxContentDo> getAll(String libId, String lang) {
        return new ArrayList<HdxContentDo>(this.getPool(this.getKey(libId, lang)).values());
    }

    private HdxContentDo getOne(String libId, String libV, String lang) {
        Object baseMap = this.getPool(this.getKey(libId, lang));
        if (MapUtils.isEmpty((Map)baseMap)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "baseMap isEmpty.");
            return null;
        }
        return (HdxContentDo)((Object)baseMap.get(libV));
    }

    public Map<String, HdxContentDo> getPool(String key) {
        Map baseMap = (Map)super.getPool(key);
        if (MapUtils.isEmpty((Map)baseMap)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "baseMap is null");
            return new LinkedHashMap<String, HdxContentDo>();
        }
        return baseMap;
    }

    private String getKey(String libId, String lang) {
        return libId + "_" + lang;
    }

    private String getKey(HdxContentDo hdx) {
        return hdx.getLibId() + "_" + hdx.getLang();
    }

    private String getSecondKey(HdxContentDo hdx) {
        return hdx.getLibV();
    }

    public List<HdxContentDo> getByExtend(HdxContentDo extendHdx) {
        ArrayList<HdxContentDo> baseList = new ArrayList<HdxContentDo>();
        String baseLibId = extendHdx.getBaseLibId();
        String baseLibV = extendHdx.getBaseLibV();
        String lang = extendHdx.getLang();
        String versionAvailability = extendHdx.getVersionAvailability();
        if ("0".equals(versionAvailability)) {
            baseList.addAll(this.getAll(baseLibId, lang));
        } else {
            if (this.getOne(baseLibId, baseLibV, lang) == null) {
                return baseList;
            }
            baseList.add(this.getOne(baseLibId, baseLibV, lang));
        }
        return baseList;
    }

    public HdxContentDo getByMend(HdxContentDo mendHdx) {
        String libId = mendHdx.getLibId();
        String baseLibV = mendHdx.getBaseLibV();
        String lang = mendHdx.getLang();
        return this.getOne(libId, baseLibV, lang);
    }

    private static class HdxBaseDaoHandlerHolder {
        private static final HdxBaseDaoHandler INSTANCE = new HdxBaseDaoHandler();

        private HdxBaseDaoHandlerHolder() {
        }
    }
}

