/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.dao;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxOldContentDo;
import com.huawei.support.icscbb.hdx.common.content.mapper.HdxContentMapper;
import com.huawei.support.icscbb.hdx.common.content.parse.SaxHdxLib;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HdxContentDaoHandler
implements HdxLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxContentDaoHandler.class);

    private HdxContentDaoHandler() {
    }

    public static HdxContentDaoHandler getInstance() {
        return HdxContentDaoHandlerHolder.INSTANCE;
    }

    public String createId(HdxContentDo hdx) {
        return "HDX" + hdx.getLibId() + "_" + hdx.getLibV() + "_" + hdx.getLang();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HdxContentDo create(File file) {
        HdxContentDo hdx = null;
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("profile.xml");
            if (zipEntry == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "getEntry failed.");
                HdxContentDo hdxContentDo = null;
                return hdxContentDo;
            }
            try (InputStream is = zipFile.getInputStream(zipEntry);){
                hdx = new HdxContentDo();
                hdx.setPath(file.getCanonicalPath());
                SaxHdxLib saxParser = new SaxHdxLib(hdx);
                SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
                return hdx;
            }
        }
        catch (ZipException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create new ZipFile error", (Throwable)e);
            return hdx;
        }
        catch (FileNotFoundException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exeception when create zipfile  error");
            return hdx;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create zipFile getInputStream error", (Throwable)e);
            return hdx;
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create SAXException", (Throwable)e);
        }
        return hdx;
    }

    public HdxContentDo createHdxDo(File file) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "createHdxDo: " + file.getName());
        HdxContentDo hdx = this.create(file);
        if (hdx != null) {
            hdx.setDocId(this.createId(hdx));
        }
        return hdx;
    }

    public boolean findHdx(HdxContentMapper hdxContentMapper, HdxContentDo hdx) {
        return Objects.nonNull((Object)this.get(hdxContentMapper, this.createId(hdx))) || CollectionUtils.isNotEmpty(this.getByLibIdAndLibVerAndLang(hdxContentMapper, hdx));
    }

    public boolean check(HdxContentMapper hdxContentMapper, HdxContentDo hdx, String fileName) {
        if (!this.checkAtr(hdx, fileName)) {
            return false;
        }
        boolean result = this.findHdx(hdxContentMapper, hdx);
        if (result) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The project has the same HDX properties file,which is:{0}", new Object[]{fileName});
            return false;
        }
        return true;
    }

    public boolean checkAtr(HdxContentDo hdx, String fileName) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{hdx.getLibId(), hdx.getProductName(), hdx.getProductV(), hdx.getLibName(), hdx.getIssueDate(), hdx.getLang(), hdx.getLibV(), hdx.getLibType()})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, String.format(Locale.ENGLISH, "the file:%s maybe losing these values:IssueDate,ProductName,LibId,ProductV,LibName,Lang,LibV,LibType.", fileName));
            return false;
        }
        return true;
    }

    public void createTb(HdxContentMapper hdxContentMapper) {
        try {
            hdxContentMapper.createTb();
            hdxContentMapper.createTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'HDXCONTENT' already exists or create error.", e);
        }
    }

    public void createOldTb(HdxContentMapper hdxContentMapper) {
        try {
            hdxContentMapper.createOldTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "HdxContentMapper createOldTb error.", e);
        }
    }

    public boolean add(HdxContentMapper hdxContentMapper, HdxContentDo hdx) {
        try {
            hdxContentMapper.add(hdx);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add Error", e);
            return false;
        }
        return true;
    }

    public boolean addBatch(HdxContentMapper hdxContentMapper, List<HdxContentDo> hdxContentDos) {
        try {
            hdxContentMapper.addBatch(hdxContentDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "HdxContentMapper addBatch Error", e);
            return false;
        }
        return true;
    }

    public boolean addOldBatch(HdxContentMapper hdxContentMapper, List<HdxOldContentDo> hdxContentDos) {
        try {
            hdxContentMapper.addOldBatch(hdxContentDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "HdxContentMapper addOldBatch Error", e);
            return false;
        }
        return true;
    }

    public void updateState(HdxContentMapper hdxContentMapper, HdxContentDo hdx) {
        try {
            hdxContentMapper.updateState(hdx);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateState Error", e);
        }
    }

    public HdxContentDo del(HdxContentMapper hdxContentMapper, String docId) {
        HdxContentDo hdx = this.get(hdxContentMapper, docId);
        try {
            hdxContentMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del Error", e);
        }
        return hdx;
    }

    public boolean delAll(HdxContentMapper hdxContentMapper) {
        try {
            hdxContentMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "HdxContentMapper delAll Error", e);
            return false;
        }
        return true;
    }

    public boolean delOldAll(HdxContentMapper hdxContentMapper) {
        try {
            hdxContentMapper.delOldAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "HdxContentMapper delOldAll Error", e);
            return false;
        }
        return true;
    }

    public HdxContentDo get(HdxContentMapper hdxContentMapper, String docId) {
        HdxContentDo hdxContentDo = null;
        try {
            return hdxContentMapper.get(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get Error", e);
            return hdxContentDo;
        }
    }

    public List<HdxContentDo> getByLibIdAndLibVerAndLang(HdxContentMapper hdxContentMapper, HdxContentDo hdxContentDo) {
        List<HdxContentDo> hdxContentDos = hdxContentMapper.getOld(hdxContentDo.getLibId(), hdxContentDo.getLibV(), hdxContentDo.getLang());
        if (CollectionUtils.isEmpty(hdxContentDos)) {
            return Collections.emptyList();
        }
        return hdxContentDos;
    }

    public HdxContentDo getByPath(HdxContentMapper hdxContentMapper, String filePath) {
        HdxContentDo hdxContentDo = null;
        try {
            return hdxContentMapper.getByPath(filePath);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByPath Error", e);
            return hdxContentDo;
        }
    }

    public List<HdxContentDo> getByProduct(HdxContentMapper hdxContentMapper, String productName, String productV) {
        ArrayList<HdxContentDo> hdxContentList = new ArrayList<HdxContentDo>();
        try {
            hdxContentList.addAll(hdxContentMapper.getByProduct(productName, productV));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByProduct Error", e);
        }
        return hdxContentList;
    }

    public List<HdxContentDo> getAll(HdxContentMapper hdxContentMapper, int start, int len) {
        ArrayList<HdxContentDo> hdxContentList = new ArrayList<HdxContentDo>();
        try {
            hdxContentList.addAll(hdxContentMapper.getAllHdx(start, len));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAll Error", e);
        }
        return hdxContentList;
    }

    public int hdxSize(HdxContentMapper hdxContentMapper) {
        int result = 0;
        try {
            result = hdxContentMapper.hdxSize();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdxSize Error", e);
        }
        return result;
    }

    public List<String> getAllDocId(HdxContentMapper hdxContentMapper) {
        ArrayList<String> docIdList = new ArrayList<String>();
        try {
            docIdList.addAll(hdxContentMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId Error", e);
        }
        return docIdList;
    }

    public List<HdxContentDo> getOldData(HdxContentMapper hdxContentMapper, int start, int len) {
        ArrayList<HdxContentDo> hdxContentDoList = new ArrayList<HdxContentDo>();
        try {
            hdxContentDoList.addAll(hdxContentMapper.getOldData(start, len));
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getOldData ERROR", e);
        }
        return hdxContentDoList;
    }

    public boolean delOldData(HdxContentMapper hdxContentMapper, String docId) {
        try {
            hdxContentMapper.delOldData(docId);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delOldData Error", e);
            return false;
        }
        return true;
    }

    public int hdxOldDataSize(HdxContentMapper hdxContentMapper) {
        int size = 0;
        try {
            size = hdxContentMapper.hdxOldDataSize();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "hdxOldDataSize ERROR", e);
        }
        return size;
    }

    public HdxContentDo getByVerify(HdxContentMapper hdxContentMapper, String verify) {
        HdxContentDo hdxContentDo = null;
        try {
            hdxContentDo = hdxContentMapper.getByVerify(verify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByVerify ERROR", e);
        }
        return hdxContentDo;
    }

    public void updateVerify(HdxContentMapper hdxContentMapper, String docId, String verify) {
        try {
            hdxContentMapper.updateVerify(docId, verify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateVerify ERROR", e);
        }
    }

    public void updateAllVerify(HdxContentMapper hdxContentMapper, String oldVerify, String newVerify) {
        try {
            hdxContentMapper.updateAllVerify(oldVerify, newVerify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateAllVerify ERROR", e);
        }
    }

    public List<HdxContentDo> getHdxList(HdxContentMapper hdxContentMapper, List<HdxContentDo> hdxContentDoList) {
        ArrayList<HdxContentDo> hdxContentDos = new ArrayList<HdxContentDo>();
        try {
            hdxContentDos.addAll(hdxContentMapper.getHdxList(hdxContentDoList));
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getHdxList ERROR", e);
        }
        return hdxContentDos;
    }

    private static class HdxContentDaoHandlerHolder {
        private static final HdxContentDaoHandler INSTANCE = new HdxContentDaoHandler();

        private HdxContentDaoHandlerHolder() {
        }
    }
}

