/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.dao;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HdxExtendDaoHandler
extends BasePool<List<HdxContentDo>>
implements HdxLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxExtendDaoHandler.class);

    private HdxExtendDaoHandler() {
    }

    public static HdxExtendDaoHandler getInstance() {
        return HdxExtendDaoHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    public void addPool(HdxContentDo hdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "addPool");
        if (!"2".equals(hdx.getLibType())) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "bPool is false or LibType is not 2");
            return;
        }
        String key = this.getKey(hdx);
        ArrayList<HdxContentDo> hdxExtendList = (ArrayList<HdxContentDo>)super.getPool(key);
        if (hdxExtendList == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "HdxExtendDao addPool");
            hdxExtendList = new ArrayList<HdxContentDo>();
            super.addPool(key, hdxExtendList);
        }
        hdxExtendList.add(hdx);
    }

    public void delPool(HdxContentDo hdx) {
        if (!"2".equals(hdx.getLibType())) {
            return;
        }
        String key = this.getKey(hdx);
        List hdxList = (List)super.getPool(key);
        if (hdxList != null) {
            hdxList.remove((Object)hdx);
        }
    }

    public List<HdxContentDo> getPool(String key) {
        List hdxList = (List)super.getPool(key);
        if (hdxList == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "hdxList isEmpty.");
            return new ArrayList<HdxContentDo>();
        }
        return hdxList;
    }

    public String getKey(HdxContentDo hdx) {
        return hdx.getBaseLibId() + "_" + hdx.getBaseLibV() + "_" + hdx.getLang();
    }

    public String getKey(String baseLibId, String baseLibV, String lang) {
        return baseLibId + "_" + baseLibV + "_" + lang;
    }

    public List<HdxContentDo> getListByBase(HdxContentDo hdx) {
        if ("0".equals(hdx.getLibType())) {
            ArrayList<HdxContentDo> hdxList = new ArrayList<HdxContentDo>((Collection<HdxContentDo>)this.getPool(this.getKey(hdx.getLibId(), hdx.getLibV(), hdx.getLang())));
            hdxList.addAll((Collection<HdxContentDo>)this.getPool(this.getKey(hdx.getLibId(), "", hdx.getLang())));
            return hdxList;
        }
        return new ArrayList<HdxContentDo>();
    }

    private static class HdxExtendDaoHandlerHolder {
        private static final HdxExtendDaoHandler INSTANCE = new HdxExtendDaoHandler();

        private HdxExtendDaoHandlerHolder() {
        }
    }
}

