/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.dao;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HdxMendDaoHandler
extends BasePool<List<HdxContentDo>>
implements HdxLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxMendDaoHandler.class);

    private HdxMendDaoHandler() {
    }

    public static HdxMendDaoHandler getInstance() {
        return HdxMendDaoHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    public void addPool(HdxContentDo hdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "addPool");
        if (!"1".equals(hdx.getLibType())) {
            return;
        }
        String key = this.getKey(hdx);
        ArrayList<HdxContentDo> hdxMendList = (ArrayList<HdxContentDo>)super.getPool(key);
        if (hdxMendList == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "HdxMendDao addPool");
            hdxMendList = new ArrayList<HdxContentDo>();
            super.addPool(key, hdxMendList);
        }
        hdxMendList.add(hdx);
    }

    public void delPool(HdxContentDo hdx) {
        if (!"1".equals(hdx.getLibType())) {
            return;
        }
        String key = this.getKey(hdx);
        List hdxList = (List)super.getPool(key);
        if (hdxList == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "hdxList isEmpty.");
            return;
        }
        hdxList.remove((Object)hdx);
    }

    public List<HdxContentDo> getPool(String key) {
        ArrayList hdxList = (ArrayList)super.getPool(key);
        if (hdxList == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "hdxList isEmpty.");
            hdxList = new ArrayList();
        }
        return hdxList;
    }

    public String getKey(HdxContentDo hdx) {
        return hdx.getLibId() + "_" + hdx.getBaseLibV() + "_" + hdx.getLang();
    }

    public String getKey(String libId, String baseLibV, String lang) {
        return libId + "_" + baseLibV + "_" + lang;
    }

    public List<HdxContentDo> getListByBase(HdxContentDo hdx) {
        if ("0".equals(hdx.getLibType())) {
            return new ArrayList<HdxContentDo>((Collection<HdxContentDo>)this.getPool(this.getKey(hdx.getLibId(), hdx.getLibV(), hdx.getLang())));
        }
        return new ArrayList<HdxContentDo>();
    }

    private static class HdxMendDaoHandlerHolder {
        private static final HdxMendDaoHandler INSTANCE = new HdxMendDaoHandler();

        private HdxMendDaoHandlerHolder() {
        }
    }
}

