/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.parse;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHdxLib
extends DefaultHandler
implements HdxLibraryConstants {
    private final HdxContentDo hdx;
    private String myNodeName;
    private String lastNodeName;
    private String myText = "";

    public SaxHdxLib(HdxContentDo hdx) {
        this.hdx = hdx;
    }

    @Override
    public void startElement(String uri, String name, String nodeName, Attributes atts) {
        this.myNodeName = nodeName;
        this.myText = "";
        switch (this.myNodeName) {
            case "profile": 
            case "target": {
                this.lastNodeName = this.myNodeName;
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        String text = new String(ch, offset, length);
        if (!"".equals(text.trim())) {
            this.myText = this.myText + text;
        }
        if (!"".equals(this.myText.trim())) {
            this.setProfileAtr(this.myText.trim());
        }
    }

    @Override
    public void endElement(String uri, String name, String nodeName) {
        switch (nodeName) {
            case "target": 
            case "infoType": 
            case "operateType": {
                this.lastNodeName = "profile";
                break;
            }
        }
    }

    @Override
    public void endDocument() {
        String path = this.hdx.getPath();
        this.hdx.setLoadTime(System.currentTimeMillis());
        File file = FileUtils.getFile((String[])new String[]{path});
        this.hdx.setLastModified(file.lastModified());
        if ("1".equals(this.hdx.getLibType()) && this.hdx.getBaseLibV() == null) {
            String libV = this.hdx.getLibV();
            if (libV.length() > 2) {
                this.hdx.setBaseLibV(libV.substring(0, 2));
            } else {
                this.hdx.setBaseLibV(libV);
            }
        }
    }

    private void setProfileAtr(String value) {
        switch (this.lastNodeName) {
            case "profile": {
                this.setProfileAtr1(this.myNodeName, value);
                this.setProfileAtr2(this.myNodeName, value);
                break;
            }
            case "target": {
                this.setTargetAtr(this.myText.trim());
                break;
            }
        }
    }

    private void setProfileAtr1(String nodeName, String value) {
        switch (nodeName) {
            case "libId": {
                this.hdx.setLibId(value);
                this.hdx.setBaseLibId(this.hdx.getLibId());
                break;
            }
            case "libVersion": {
                this.hdx.setLibV(value);
                break;
            }
            case "libName": {
                this.hdx.setLibName(value);
                break;
            }
            case "productType": {
                this.hdx.setProductName(value);
                break;
            }
            case "productVersion": {
                this.hdx.setProductV(value);
                break;
            }
            case "issueDate": {
                this.hdx.setIssueDate(value);
                break;
            }
        }
    }

    private void setProfileAtr2(String nodeName, String value) {
        switch (nodeName) {
            case "language": {
                this.hdx.setLang(value);
                break;
            }
            case "libType": {
                this.hdx.setLibType(value);
                break;
            }
            case "baseLibVersion": {
                this.hdx.setBaseLibV(value);
                break;
            }
            case "homePage": {
                this.hdx.setHomepage(value);
                break;
            }
            case "customerName": {
                this.hdx.setCustomerName(value);
                break;
            }
            case "autoUpdateFromMe": {
                this.hdx.setAutoUpdateFromMe(value);
                break;
            }
            case "autoUpdateToMe": {
                this.hdx.setAutoUpdateToMe(value);
                break;
            }
        }
    }

    private void setTargetAtr(String value) {
        switch (this.myNodeName) {
            case "libId": {
                this.hdx.setBaseLibId(value);
                break;
            }
            case "libVersion": {
                this.hdx.setBaseLibV(value);
                break;
            }
            case "topicId": {
                this.hdx.setBaseTopicId(value);
                break;
            }
            case "position": {
                this.hdx.setPosition(value);
                break;
            }
            case "priority": {
                this.hdx.setPriority(value);
                break;
            }
            case "versionAvailability": {
                this.hdx.setVersionAvailability(value);
                break;
            }
        }
    }
}

