/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.service.impl;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dao.HdxBaseDaoHandler;
import com.huawei.support.icscbb.hdx.common.content.dao.HdxContentDaoHandler;
import com.huawei.support.icscbb.hdx.common.content.dao.HdxExtendDaoHandler;
import com.huawei.support.icscbb.hdx.common.content.dao.HdxMendDaoHandler;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxOldContentDo;
import com.huawei.support.icscbb.hdx.common.content.mapper.HdxContentMapper;
import com.huawei.support.icscbb.hdx.common.content.service.HdxContentService;
import com.huawei.support.icscbb.hdx.common.content.service.HdxLibService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.pool.LibEntityPool;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxContentPoolServiceHandler
extends LibEntityPool<HdxContentDo>
implements HdxContentService,
HdxLibService,
HdxLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxContentPoolServiceHandler.class);
    private static final HdxContentMapper HDX_CONTENT_MAPPER = (HdxContentMapper)DbMapperUtils.getMapper(HdxContentMapper.class);

    private HdxContentPoolServiceHandler() {
    }

    public static HdxContentPoolServiceHandler getInstance() {
        return HdxContentPoolServiceHandlerHolder.INSTANCE;
    }

    public void initPool() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "initPool");
        int hdxSize = HdxContentDaoHandler.getInstance().hdxSize(HDX_CONTENT_MAPPER);
        int stepIndex = 1000;
        int hdxMinIndex = 0;
        while (hdxSize - hdxMinIndex > 0) {
            List<HdxContentDo> hdxContentList = HdxContentDaoHandler.getInstance().getAll(HDX_CONTENT_MAPPER, hdxMinIndex, 1000);
            for (HdxContentDo hdx : hdxContentList) {
                super.addPool(hdx.getDocId(), (Object)hdx);
                HdxBaseDaoHandler.getInstance().addPool(hdx);
                HdxMendDaoHandler.getInstance().addPool(hdx);
                HdxExtendDaoHandler.getInstance().addPool(hdx);
            }
            hdxMinIndex += stepIndex;
        }
    }

    protected void createPool(String key) {
        HdxContentDo hdx = HdxContentDaoHandler.getInstance().get(HDX_CONTENT_MAPPER, key);
        if (hdx != null) {
            super.addPool(key, (Object)hdx);
        }
    }

    private int poolSize(String productName, String productV) {
        int size = 0;
        ArrayList hdxContentDoList = new ArrayList(this.objectMap.values());
        for (HdxContentDo hdx : hdxContentDoList) {
            if (!hdx.isbUse() || !StringUtils.equals((CharSequence)hdx.getProductName(), (CharSequence)productName) && StringUtils.isNotBlank((CharSequence)productName) || !StringUtils.equals((CharSequence)hdx.getProductV(), (CharSequence)productV) && StringUtils.isNotBlank((CharSequence)productV)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public void createTb() {
        HdxContentDaoHandler.getInstance().createTb(HDX_CONTENT_MAPPER);
    }

    @Override
    public void createOldTb() {
        HdxContentDaoHandler.getInstance().createOldTb(HDX_CONTENT_MAPPER);
    }

    @Override
    public HdxContentDo create(File file) {
        return HdxContentDaoHandler.getInstance().createHdxDo(file);
    }

    @Override
    public boolean findHdx(HdxContentDo hdx) {
        return Objects.nonNull(super.getPool(HdxContentDaoHandler.getInstance().createId(hdx))) || HdxContentDaoHandler.getInstance().findHdx(HDX_CONTENT_MAPPER, hdx);
    }

    @Override
    public boolean check(HdxContentDo hdx, String fileName) {
        if (!this.checkAtr(hdx, fileName)) {
            return false;
        }
        boolean result = this.findHdx(hdx);
        if (result) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The project has the same HDX properties file,which is:{0}", new Object[]{fileName});
            return false;
        }
        return true;
    }

    @Override
    public boolean checkAtr(HdxContentDo hdx, String fileName) {
        return HdxContentDaoHandler.getInstance().check(HDX_CONTENT_MAPPER, hdx, fileName);
    }

    @Override
    public boolean add(HdxContentDo hdx) {
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add hdx is null.");
            return false;
        }
        if (!HdxContentDaoHandler.getInstance().add(HDX_CONTENT_MAPPER, hdx)) {
            return false;
        }
        super.addPool(hdx.getDocId(), (Object)hdx);
        HdxBaseDaoHandler.getInstance().addPool(hdx);
        HdxMendDaoHandler.getInstance().addPool(hdx);
        HdxExtendDaoHandler.getInstance().addPool(hdx);
        return true;
    }

    @Override
    public boolean addBatch(List<HdxContentDo> hdxContentDos) {
        return HdxContentDaoHandler.getInstance().addBatch(HDX_CONTENT_MAPPER, hdxContentDos);
    }

    @Override
    public boolean addOldBatch(List<HdxOldContentDo> hdxContentDos) {
        return HdxContentDaoHandler.getInstance().addOldBatch(HDX_CONTENT_MAPPER, hdxContentDos);
    }

    @Override
    public void update(HdxContentDo hdx) {
        if (hdx != null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "update: " + hdx.getDocId());
            HdxContentDaoHandler.getInstance().updateState(HDX_CONTENT_MAPPER, hdx);
        }
    }

    @Override
    public HdxContentDo getByVerify(String verify) {
        if (StringUtils.isEmpty((CharSequence)verify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "verify isEmpty.");
        }
        return HdxContentDaoHandler.getInstance().getByVerify(HDX_CONTENT_MAPPER, verify);
    }

    @Override
    public void updateAllVerify(String oldVerify, String newVerify) {
        if (StringUtils.isEmpty((CharSequence)oldVerify) || StringUtils.isEmpty((CharSequence)newVerify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "oldVerify or newVerify isEmpty.");
        }
        HdxContentDaoHandler.getInstance().updateAllVerify(HDX_CONTENT_MAPPER, oldVerify, newVerify);
    }

    @Override
    public List<HdxContentDo> getHdxList(List<HdxContentDo> hdxContentDoList) {
        if (CollectionUtils.isEmpty(hdxContentDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdxContentDoList isEmpty.");
            return new ArrayList<HdxContentDo>();
        }
        return HdxContentDaoHandler.getInstance().getHdxList(HDX_CONTENT_MAPPER, hdxContentDoList);
    }

    @Override
    public HdxContentDo del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId:" + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId isEmpty.");
            return null;
        }
        HdxContentDo hdx = HdxContentDaoHandler.getInstance().del(HDX_CONTENT_MAPPER, docId);
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdx is null.");
            return null;
        }
        this.delPool(hdx.getDocId());
        HdxBaseDaoHandler.getInstance().delPool(hdx);
        HdxMendDaoHandler.getInstance().delPool(hdx);
        HdxExtendDaoHandler.getInstance().delPool(hdx);
        return hdx;
    }

    @Override
    public boolean delAll() {
        return HdxContentDaoHandler.getInstance().delAll(HDX_CONTENT_MAPPER);
    }

    @Override
    public boolean delOldAll() {
        return HdxContentDaoHandler.getInstance().delOldAll(HDX_CONTENT_MAPPER);
    }

    @Override
    public HdxContentDo get(String docId) {
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        return (HdxContentDo)((Object)super.getPool(docId));
    }

    @Override
    public HdxContentDo getByPath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFilePath is Empty.");
            return null;
        }
        return HdxContentDaoHandler.getInstance().getByPath(HDX_CONTENT_MAPPER, filePath);
    }

    @Override
    public List<HdxContentDo> getAllOld(int start, int len) {
        return super.getAllOldPool(start, len);
    }

    @Override
    public int size() {
        return this.poolSize();
    }

    @Override
    public int size(String productType, String productV) {
        return this.poolSize(productType, productV);
    }

    @Override
    public int oldSize() {
        return super.poolOldSize();
    }

    @Override
    public Set<String> getAllDocId() {
        return new HashSet<String>(HdxContentDaoHandler.getInstance().getAllDocId(HDX_CONTENT_MAPPER));
    }

    @Override
    public HdxContentDo getBaseByMend(HdxContentDo hdx) {
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdx is null.");
            return null;
        }
        return HdxBaseDaoHandler.getInstance().getByMend(hdx);
    }

    @Override
    public HdxContentDo getBaseByMend(String docId) {
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        HdxContentDo hdx = this.get(docId);
        return this.getBaseByMend(hdx);
    }

    @Override
    public List<HdxContentDo> getBaseByExtend(HdxContentDo hdx) {
        ArrayList<HdxContentDo> baseList = new ArrayList<HdxContentDo>();
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdx is null.");
            return baseList;
        }
        baseList.addAll(HdxBaseDaoHandler.getInstance().getByExtend(hdx));
        return baseList;
    }

    @Override
    public List<HdxContentDo> getBaseByExtend(String docId) {
        ArrayList<HdxContentDo> baseList = new ArrayList<HdxContentDo>();
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return baseList;
        }
        HdxContentDo hdx = this.get(docId);
        baseList.addAll(this.getBaseByExtend(hdx));
        return baseList;
    }

    @Override
    public List<HdxContentDo> getMendList(HdxContentDo hdx) {
        ArrayList<HdxContentDo> mendList = new ArrayList<HdxContentDo>();
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdx is null.");
            return mendList;
        }
        mendList.addAll(HdxMendDaoHandler.getInstance().getListByBase(hdx));
        return mendList;
    }

    @Override
    public List<HdxContentDo> getExtendList(HdxContentDo hdx) {
        ArrayList<HdxContentDo> extendList = new ArrayList<HdxContentDo>();
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdx is empty.");
            return extendList;
        }
        extendList.addAll(HdxExtendDaoHandler.getInstance().getListByBase(hdx));
        return extendList;
    }

    @Override
    public List<HdxContentDo> getAll(String productType, String productV) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAll, productType: " + productType + " len:" + productV);
        ArrayList<HdxContentDo> pool = new ArrayList<HdxContentDo>();
        List<Object> hdxContentDoList = new ArrayList(this.objectMap.values());
        hdxContentDoList = hdxContentDoList.stream().filter(hdxContentDo -> StringUtils.startsWithIgnoreCase((CharSequence)hdxContentDo.getDocId(), (CharSequence)"HDX")).collect(Collectors.toList());
        for (HdxContentDo hdxContentDo2 : hdxContentDoList) {
            if (!hdxContentDo2.isbUse() || !StringUtils.equals((CharSequence)hdxContentDo2.getProductName(), (CharSequence)productType) && StringUtils.isNotBlank((CharSequence)productType) || !StringUtils.equals((CharSequence)hdxContentDo2.getProductV(), (CharSequence)productV) && StringUtils.isNotBlank((CharSequence)productV)) continue;
            pool.add(hdxContentDo2);
        }
        return pool;
    }

    @Override
    public boolean setUpdate(String docId, boolean bUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty");
            return false;
        }
        HdxContentDo hdxContentDo = (HdxContentDo)((Object)this.getPool(docId));
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdxContentDo is null");
            return false;
        }
        hdxContentDo.setbUpdate(bUpdate);
        return true;
    }

    @Override
    public void getAllProduct(Map<String, Set<String>> map) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllProduct");
        ArrayList hdxContentDoList = new ArrayList(this.objectMap.values());
        for (HdxContentDo hdx : hdxContentDoList) {
            if (!hdx.isbUse()) continue;
            Set<String> productVerSet = map.get(hdx.getProductName());
            if (CollectionUtils.isEmpty(productVerSet)) {
                productVerSet = new LinkedHashSet<String>();
                map.put(hdx.getProductName(), productVerSet);
            }
            productVerSet.add(hdx.getProductV());
        }
    }

    @Override
    public void updateHdxLibData() {
        int hdxSize = HdxContentDaoHandler.getInstance().hdxOldDataSize(HDX_CONTENT_MAPPER);
        if (hdxSize == 0) {
            return;
        }
        int stepIndex = 100;
        int hdxMinIndex = 0;
        int hdxMaxIndex = 100;
        while (hdxSize - hdxMinIndex > 0) {
            List<HdxContentDo> hdxOldDoList = HdxContentDaoHandler.getInstance().getOldData(HDX_CONTENT_MAPPER, hdxMinIndex, hdxMaxIndex);
            this.syncHdx(hdxOldDoList);
            hdxMinIndex += stepIndex;
        }
    }

    @Override
    public void updateVerify(String docId, String verify) {
        HdxContentDo hdxContentDo;
        if (StringUtils.isEmpty((CharSequence)docId) || StringUtils.isEmpty((CharSequence)verify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or verify isEmpty.");
        }
        if ((hdxContentDo = (HdxContentDo)((Object)this.getPool(docId))) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdxContentDo is null");
            return;
        }
        hdxContentDo.setVerify(verify);
        HdxContentDaoHandler.getInstance().updateVerify(HDX_CONTENT_MAPPER, docId, verify);
    }

    private void syncHdx(List<HdxContentDo> hdxOldDoList) {
        if (CollectionUtils.isEmpty(hdxOldDoList)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "hdxOldDoList is null");
            return;
        }
        for (HdxContentDo hdxOldDo : hdxOldDoList) {
            File file = FileUtils.getFile((String[])new String[]{hdxOldDo.getPath()});
            HdxContentDo hdxNewDo = HdxContentDaoHandler.getInstance().create(file);
            if (hdxNewDo == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "addHdx: add(f) is null.");
                continue;
            }
            hdxNewDo.setbUse(false);
            if (this.check(hdxNewDo, file.getName())) {
                hdxNewDo.setDocId(hdxOldDo.getDocId());
                this.add(hdxNewDo);
                CodeCCUtils.INSTANCE.infoLog(LOG, String.format(Locale.ENGLISH, "addHdx  success. docId:%s", hdxNewDo.getDocId()));
                HdxContentDaoHandler.getInstance().delOldData(HDX_CONTENT_MAPPER, hdxOldDo.getDocId());
                continue;
            }
            CodeCCUtils.INSTANCE.errorLog(LOG, "addHdx: add(f) is null.");
        }
    }

    public List<HdxContentDo> getByLibIdAndLibVerAndLang(HdxContentDo hdxContentDo) {
        return HdxContentDaoHandler.getInstance().getByLibIdAndLibVerAndLang(HDX_CONTENT_MAPPER, hdxContentDo);
    }

    private static class HdxContentPoolServiceHandlerHolder {
        private static final HdxContentPoolServiceHandler INSTANCE = new HdxContentPoolServiceHandler();

        private HdxContentPoolServiceHandlerHolder() {
        }
    }
}

