/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.content.service.impl;

import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dao.HdxContentDao;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxOldContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.HdxContentService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="hdxContentServiceImpl")
public class HdxContentServiceImpl
implements HdxContentService,
HdxLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxContentServiceImpl.class);
    @Resource
    private HdxContentDao hdxContentDao;

    @Override
    public void createTb() {
        this.hdxContentDao.createTb();
    }

    @Override
    public void createOldTb() {
    }

    @Override
    public HdxContentDo create(File file) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "create: " + file.getName());
        HdxContentDo hdx = this.hdxContentDao.create(file);
        if (hdx != null) {
            hdx.setDocId(this.hdxContentDao.createId(hdx));
        }
        return hdx;
    }

    @Override
    public boolean findHdx(HdxContentDo hdx) {
        return this.hdxContentDao.findHdx(hdx);
    }

    @Override
    public boolean check(HdxContentDo hdx, String fileName) {
        return this.hdxContentDao.check(hdx, fileName);
    }

    @Override
    public boolean checkAtr(HdxContentDo hdx, String fileName) {
        return this.hdxContentDao.checkAtr(hdx, fileName);
    }

    @Override
    public boolean add(HdxContentDo hdx) {
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add hdx is null.");
            return false;
        }
        return this.hdxContentDao.add(hdx);
    }

    @Override
    public boolean addBatch(List<HdxContentDo> hdxContentDos) {
        return false;
    }

    @Override
    public boolean addOldBatch(List<HdxOldContentDo> hdxContentDos) {
        return false;
    }

    @Override
    public void update(HdxContentDo hdx) {
        if (hdx != null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "add: " + hdx.getDocId());
            this.hdxContentDao.updateState(hdx);
        }
    }

    @Override
    public HdxContentDo del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delObject, docId:" + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        return this.hdxContentDao.del(docId);
    }

    @Override
    public boolean delAll() {
        return false;
    }

    @Override
    public boolean delOldAll() {
        return false;
    }

    @Override
    public HdxContentDo get(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, docId:" + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        return this.hdxContentDao.get(docId);
    }

    @Override
    public HdxContentDo getByPath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFilePath is Empty.");
            return null;
        }
        return this.hdxContentDao.getByPath(filePath);
    }

    @Override
    public List<HdxContentDo> getAllOld(int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getOldAll, start: " + start + " len:" + len);
        return this.hdxContentDao.getAll(start, len);
    }

    @Override
    public int size() {
        return this.hdxContentDao.hdxSize();
    }

    @Override
    public int oldSize() {
        return this.hdxContentDao.hdxSize();
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return new HashSet<String>(this.hdxContentDao.getAllDocId());
    }

    @Override
    public List<HdxContentDo> getAll(String productType, String productV) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAll, productType: " + productType + " len:" + productV);
        return this.hdxContentDao.getByProduct(productType, productV);
    }

    @Override
    public boolean setUpdate(String docId, boolean bUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty");
            return false;
        }
        HdxContentDo hdxContentDo = this.hdxContentDao.get(docId);
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdxContentDo is empty");
            return false;
        }
        hdxContentDo.setbUpdate(bUpdate);
        return true;
    }
}

