/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.dao;

import com.huawei.support.icscbb.hdx.common.navi.dao.HdxNaviCountHandler;
import com.huawei.support.icscbb.hdx.common.navi.dao.HdxNaviHandler;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviBaseDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviContentDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviExpandDo;
import com.huawei.support.icscbb.hdx.common.navi.parse.NavInit;
import com.huawei.support.icscbb.hdx.common.navi.parse.SaxInitNavi;
import com.huawei.support.icscbb.hdx.common.navi.parse.SaxParserHdxNavi;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HdxNaviContentDaoHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxNaviContentDaoHandler.class);
    private static final String NAVIPATH = "resources/navi.xml";

    public static InputStream getNaviXmlInputStream(String docPath) throws IOException {
        return ZipFilePool.getInputStream((String)docPath, (String)NAVIPATH);
    }

    public static InputStream getNewNaviXmlInputStream(String xmlPath) throws IOException {
        return FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{xmlPath}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getNaviXmlDocument(String docPath) {
        Document dom = null;
        try (InputStream is = HdxNaviContentDaoHandler.getNaviXmlInputStream(docPath);){
            if (is == null) {
                Document document = null;
                return document;
            }
            dom = XmlDom4jUtils.getDocument((InputStream)is);
            return dom;
        }
        catch (IOException | DocumentException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exception, when getNaviXmlDocument", e);
        }
        return dom;
    }

    public static Document init(NaviBaseDo baseLib) {
        Document dom = HdxNaviContentDaoHandler.getNaviXmlDocument(baseLib.getDocPath());
        if (dom != null) {
            dom = NavInit.init(baseLib, dom);
        }
        return dom;
    }

    public static Document initPatch(NaviBaseDo baseLib, NaviBaseDo patchLib, List<NaviExpandDo> expandLibs) {
        Document patchDom = HdxNaviContentDaoHandler.getNaviXmlDocument(patchLib.getDocPath());
        if (patchDom == null) {
            return patchDom;
        }
        NavInit.processPatchNode("", baseLib, patchLib, patchDom.getRootElement());
        if (CollectionUtils.isEmpty(expandLibs)) {
            return patchDom;
        }
        for (NaviExpandDo expand : expandLibs) {
            Document expandDom = HdxNaviContentDaoHandler.init(expand);
            NavInit.expand(expand.getTargetTopicId(), expand.getTargetPosition(), patchDom, expandDom);
        }
        NavInit.processExpandToPatch("", baseLib, patchLib, patchDom.getRootElement());
        return patchDom;
    }

    public static int initAndExpand(String savePath, NaviBaseDo baseLib, List<NaviExpandDo> expandLibs) {
        if (baseLib == null) {
            return 10100001;
        }
        return HdxNaviContentDaoHandler.saxPaserNavi(baseLib.getDocPath(), new SaxInitNavi(savePath, baseLib, expandLibs));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int saxPaserNavi(String docPath, SaxInitNavi saxParser) {
        int resultCode = 10100001;
        try (InputStream is = HdxNaviContentDaoHandler.getNaviXmlInputStream(docPath);){
            if (is == null) {
                CodeCCUtils.INSTANCE.debugLog(LOG, String.format(Locale.ENGLISH, "navi.xml is not found.", new Object[0]));
                int n = resultCode;
                return n;
            }
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
            resultCode = 10100000;
            return resultCode;
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, String.format(Locale.ENGLISH, "Error parserXml navi.xml.", new Object[0]), (Throwable)e);
            return 10100001;
        }
    }

    public static int update(String savePath, NaviBaseDo baseLib, List<NaviExpandDo> expandLibs) {
        return HdxNaviContentDaoHandler.initAndExpand(savePath, baseLib, expandLibs);
    }

    public static int updatePatch(String savePath, NaviBaseDo baseLib, NaviBaseDo patchLib, List<NaviExpandDo> expandLibs) {
        if (baseLib == null || patchLib == null) {
            return 10100001;
        }
        return HdxNaviContentDaoHandler.saxPaserNavi(patchLib.getDocPath(), new SaxInitNavi(savePath, baseLib, patchLib, expandLibs));
    }

    public static int remove(String path) {
        File naviFile = FileUtils.getFile((String[])new String[]{path});
        if (!naviFile.exists() || IcsFileUtils.delFile((String)path)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "delete navifile success. docId: {0}", new Object[]{path});
            return 10100000;
        }
        CodeCCUtils.INSTANCE.debugLog(LOG, "delete navifile failed. docId: {0}", new Object[]{path});
        return 10100001;
    }

    public static String getFirstFloor(String path) {
        return HdxNaviContentDaoHandler.getTopicsBySax(path, new SaxParserHdxNavi(SaxParserHdxNavi.Branch.FIRSTFLOOR));
    }

    private static String getTopicsBySax(String path, SaxParserHdxNavi parser) {
        if (!HdxNaviContentDaoHandler.parseNav(path, parser) || parser == null) {
            return "";
        }
        return parser.getTopicStr();
    }

    private static String getTopicBySax(String path, SaxParserHdxNavi parser) {
        if (!HdxNaviContentDaoHandler.parseNav(path, parser) || parser == null) {
            return "";
        }
        return parser.getPostion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean parseNav(String path, SaxParserHdxNavi parser) {
        boolean rst = false;
        try (InputStream is = HdxNaviContentDaoHandler.getNewNaviXmlInputStream(path);){
            if (is == null) {
                boolean bl = rst;
                return bl;
            }
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)parser);
            rst = true;
            return rst;
        }
        catch (IOException | SAXException e) {
            if (StringUtils.equals((CharSequence)"10100002", (CharSequence)e.getMessage())) {
                return true;
            }
            CodeCCUtils.INSTANCE.infoLog(LOG, "Exception, when parseNav.", (Throwable)e);
        }
        return rst;
    }

    public static String getByTopicId(String topicId, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().topicId(topicId)).build();
        String targetPostion = HdxNaviContentDaoHandler.getTopicBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.FINDBYID));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return HdxNaviContentDaoHandler.getParents(targetPostion, path);
    }

    public static String getByTopicIdIgnoreCase(String topicId, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().topicId(topicId)).build();
        String targetPostion = HdxNaviContentDaoHandler.getTopicBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.FINDBYIDIGNORECASE));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return HdxNaviContentDaoHandler.getParents(targetPostion, path);
    }

    public static String getByTopicUrl(String topicUrl, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().topicUrl(topicUrl)).build();
        String targetPostion = HdxNaviContentDaoHandler.getTopicBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.FINDBYURL));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return HdxNaviContentDaoHandler.getParents(targetPostion, path);
    }

    public static String getByPageNum(String pageNum, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().pageNum(pageNum)).build();
        String targetPostion = HdxNaviContentDaoHandler.getTopicBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.FINDBYPAGENUM));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return HdxNaviContentDaoHandler.getParents(targetPostion, path);
    }

    private static String getParents(String position, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().position(position)).build();
        return HdxNaviContentDaoHandler.getTopicsBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.GETBYPOSITION));
    }

    public static String getChilds(String position, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().position(position)).build();
        return HdxNaviContentDaoHandler.getTopicsBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.GETCHILD));
    }

    public static Map<String, String> getUpDownName(String position, String path) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().position(position)).build();
        HashMap<String, String> nodeNameMap = new HashMap<String, String>();
        SaxParserHdxNavi parser = new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.GETUPDOWNNAME);
        if (!HdxNaviContentDaoHandler.parseNav(path, parser) || parser == null) {
            return nodeNameMap;
        }
        nodeNameMap.put("preName", parser.getPreName());
        nodeNameMap.put("nextName", parser.getNextName());
        return nodeNameMap;
    }

    public static int getTotal(String path) {
        int total = 0;
        SaxParserHdxNavi parser = new SaxParserHdxNavi(SaxParserHdxNavi.Branch.GETTOTAL);
        if (!HdxNaviContentDaoHandler.parseNav(path, parser)) {
            return total;
        }
        return parser.getTotal();
    }

    public static String getTreeByTopicUrlWithLib(String path, String topicUrl, String libId, String libV) {
        Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().topicUrl(topicUrl)).libId(libId)).libv(libV)).build();
        String targetPostion = HdxNaviContentDaoHandler.getTopicBySax(path, new SaxParserHdxNavi((NaviContentDo)naviContentDo, SaxParserHdxNavi.Branch.FINDSPECIFYBYURL));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return HdxNaviContentDaoHandler.getParents(targetPostion, path);
    }

    public static List<NaviContentDo> getNaviByPosition(String naviXmlPath, String naviPositions) {
        HdxNaviHandler hdxNaviHandler = new HdxNaviHandler(naviPositions);
        if (HdxNaviContentDaoHandler.parseXml(hdxNaviHandler, naviXmlPath)) {
            return hdxNaviHandler.getNaviContentDoList();
        }
        return Collections.emptyList();
    }

    public static int getCountByPosition(String naviXmlPath, String naviPositions) {
        HdxNaviCountHandler hdxNaviCountHandler = new HdxNaviCountHandler(naviPositions);
        if (HdxNaviContentDaoHandler.parseXml(hdxNaviCountHandler, naviXmlPath)) {
            return hdxNaviCountHandler.getCount();
        }
        return 0;
    }

    private static boolean parseXml(EventListener eventListener, String naviXmlPath) {
        XmlSaxParser xmlSaxParser = new XmlSaxParser(eventListener, new ParserContext());
        try (FileInputStream fileInputStream = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{naviXmlPath}));){
            SAXParserUtils.parseXml((InputStream)fileInputStream, (DefaultHandler)xmlSaxParser);
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Navi Parse fail.", (Throwable)e);
            return false;
        }
        return true;
    }
}

