/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.dao;

import com.huawei.support.icscbb.hdx.common.navi.dto.HdxNaviStatusDo;
import com.huawei.support.icscbb.hdx.common.navi.mapper.HdxNaviStatusMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public class HdxNaviStatusDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxNaviStatusDaoHandler.class);

    public static void createNaviTopicTb(HdxNaviStatusMapper hdxNaviStatusMapper) {
        try {
            hdxNaviStatusMapper.createTb();
            hdxNaviStatusMapper.createTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Table 'HDXSTATU' already exists or create error.", e);
        }
    }

    public static void add(HdxNaviStatusMapper hdxNaviStatusMapper, HdxNaviStatusDo status) {
        try {
            hdxNaviStatusMapper.add(status);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "HDX Status add Error.", e);
        }
    }

    public static boolean addBatch(HdxNaviStatusMapper hdxNaviStatusMapper, List<HdxNaviStatusDo> statusDos) {
        try {
            hdxNaviStatusMapper.addBatch(statusDos);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "HDX Status addBatch Error.", e);
            return false;
        }
        return true;
    }

    public static void delete(HdxNaviStatusMapper hdxNaviStatusMapper, String docId) {
        try {
            hdxNaviStatusMapper.delete(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "HDX Status delete Error.", e);
        }
    }

    public static boolean deleteAll(HdxNaviStatusMapper hdxNaviStatusMapper) {
        try {
            hdxNaviStatusMapper.deleteAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "HDX Status delete Error.", e);
            return false;
        }
        return true;
    }

    public static HdxNaviStatusDo getByDocId(HdxNaviStatusMapper hdxNaviStatusMapper, String docId) {
        HdxNaviStatusDo status = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("docId", docId);
            status = hdxNaviStatusMapper.getByDocId(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getByDocId Error.", e);
        }
        return status;
    }

    public static void updateStatus(HdxNaviStatusMapper hdxNaviStatusMapper, HdxNaviStatusDo statusDo) {
        try {
            hdxNaviStatusMapper.updateStatus(statusDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "updateStatus Error.", e);
        }
    }

    public static List<HdxNaviStatusDo> getUnfinishedDoc(HdxNaviStatusMapper hdxNaviStatusMapper) {
        List<HdxNaviStatusDo> list = null;
        try {
            ArrayList<String> status = new ArrayList<String>();
            status.add("101");
            status.add("102");
            list = hdxNaviStatusMapper.getUnfinishedDoc(status);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getUnfinishedDoc Error.", e);
        }
        return Optional.ofNullable(list).orElse(new ArrayList());
    }
}

