/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.parse;

import com.huawei.support.icscbb.hdx.common.navi.dto.HdxPageInfoDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviBaseDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviExpandDo;
import com.huawei.support.icscbb.hdx.common.navi.parse.NaviParserUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class NavInit {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(NavInit.class);

    private NavInit() {
    }

    public static Document init(NaviBaseDo baseLib, Document document) {
        Document dom = document;
        if (document == null || baseLib == null) {
            return dom;
        }
        Element root = dom.getRootElement();
        NavInit.processBaseNode("", baseLib, root);
        return dom;
    }

    public static void expand(String targetTopicId, String targetPosition, Document baseDom, Document expandDom) {
        if (baseDom == null || expandDom == null) {
            return;
        }
        Element expand = expandDom.getRootElement();
        Element element = null;
        String ps = targetPosition;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetTopicId, targetPosition})) {
            element = NaviParserUtils.getElementByTopic(baseDom, targetTopicId);
        }
        if (element == null) {
            element = baseDom.getRootElement();
            ps = "2";
        }
        if (expand == null || element == null) {
            return;
        }
        switch (ps) {
            case "0": {
                NavInit.expandPackageUp(element, expand);
                break;
            }
            case "1": {
                NavInit.expandPackageDown(element, expand);
                break;
            }
            case "2": {
                NavInit.expandPackageAfter(element, expand);
                break;
            }
        }
    }

    private static void expandPackageAfter(Element targetElement, Element expand) {
        List elements = targetElement.elements();
        List<Element> expands = NavInit.delTopicsNode(expand);
        elements.addAll(expands);
    }

    private static void expandPackageDown(Element targetElement, Element expand) {
        NavInit.putExpandPackage(1, targetElement, expand);
    }

    private static void expandPackageUp(Element targetElement, Element expand) {
        NavInit.putExpandPackage(0, targetElement, expand);
    }

    private static void putExpandPackage(int defaultIndex, Element targetElement, Element expand) {
        Element node;
        Element parent = targetElement.getParent();
        List elements = parent.elements();
        int index = defaultIndex;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext() && (node = (Element)iterator.next()) != targetElement) {
            ++index;
        }
        List<Element> expands = NavInit.delTopicsNode(expand);
        elements.addAll(index, expands);
    }

    private static List<Element> delTopicsNode(Element expand) {
        List elements = expand.elements();
        for (Element element : elements) {
            element.setParent(null);
        }
        return elements;
    }

    public static String processExpandNode(String position, NaviBaseDo baseLib, Element root) {
        List elements = root.elements();
        String nowPosition = NavInit.positionPush(position);
        for (Element node : elements) {
            nowPosition = NavInit.getPosition(nowPosition);
            node.addAttribute("docId", baseLib.getDocId());
            node.addAttribute("baseLibId", baseLib.getLibId());
            node.addAttribute("baseLibVersion", baseLib.getLibV());
            node.addAttribute("position", nowPosition.substring(1));
            nowPosition = NavInit.processExpandNode(nowPosition, baseLib, node);
        }
        return NavInit.positionPop(nowPosition);
    }

    private static String processBaseNode(String position, NaviBaseDo baseLib, Element root) {
        List elements = root.elements();
        String nowPosition = NavInit.positionPush(position);
        for (Element node : elements) {
            nowPosition = NavInit.getPosition(nowPosition);
            node.addAttribute("docId", baseLib.getDocId());
            node.addAttribute("topicDocId", baseLib.getDocId());
            node.addAttribute("baseLibId", baseLib.getLibId());
            node.addAttribute("baseLibVersion", baseLib.getLibV());
            node.addAttribute("position", nowPosition.substring(1));
            nowPosition = NavInit.processBaseNode(nowPosition, baseLib, node);
        }
        return NavInit.positionPop(nowPosition);
    }

    public static String processPatchNode(String position, NaviBaseDo baseLib, NaviBaseDo patchLib, Element root) {
        List elements = root.elements();
        String nowPosition = NavInit.positionPush(position);
        for (Element node : elements) {
            nowPosition = NavInit.getPosition(nowPosition);
            node.addAttribute("docId", patchLib.getDocId());
            node.addAttribute("topicDocId", patchLib.getDocId());
            if (StringUtils.equals((CharSequence)node.attributeValue("libId"), (CharSequence)baseLib.getLibId()) && StringUtils.equals((CharSequence)node.attributeValue("libVersion"), (CharSequence)baseLib.getLibV())) {
                node.addAttribute("topicDocId", baseLib.getDocId());
            }
            node.addAttribute("baseLibId", baseLib.getLibId());
            node.addAttribute("baseLibVersion", baseLib.getLibV());
            node.addAttribute("position", nowPosition.substring(1));
            nowPosition = NavInit.processPatchNode(nowPosition, baseLib, patchLib, node);
        }
        return NavInit.positionPop(nowPosition);
    }

    public static String processExpandToPatch(String position, NaviBaseDo baseLib, NaviBaseDo patchLib, Element root) {
        List elements = root.elements();
        String nowPosition = NavInit.positionPush(position);
        for (Element node : elements) {
            nowPosition = NavInit.getPosition(nowPosition);
            node.addAttribute("docId", patchLib.getDocId());
            node.addAttribute("baseLibId", baseLib.getLibId());
            node.addAttribute("baseLibVersion", baseLib.getLibV());
            node.addAttribute("position", nowPosition.substring(1));
            nowPosition = NavInit.processExpandToPatch(nowPosition, baseLib, patchLib, node);
        }
        return NavInit.positionPop(nowPosition);
    }

    public static void addPageInfoToDom(Document dom) {
        int index = 0;
        String preName = "";
        Element root = dom.getRootElement();
        HdxPageInfoDo info = NavInit.addPageInfoToDom(index, preName, null, root);
        if (info != null) {
            index = info.getIndex();
        }
        root.addAttribute("topicTotal", String.valueOf(index));
    }

    private static HdxPageInfoDo addPageInfoToDom(int index, String preName, Element preElement, Element root) {
        Iterator iterator = root.elementIterator();
        if (!iterator.hasNext()) {
            return null;
        }
        String newPreName = preName;
        Element newPreElement = preElement;
        while (iterator.hasNext()) {
            HdxPageInfoDo info;
            Element next = (Element)iterator.next();
            next.addAttribute("pageNum", String.valueOf(index++));
            next.addAttribute("preName", newPreName);
            next.addAttribute("nextName", "");
            if (newPreElement != null) {
                newPreElement.addAttribute("nextName", next.attributeValue("txt"));
            }
            if ((info = NavInit.addPageInfoToDom(index, newPreName = next.attributeValue("txt"), newPreElement = next, next)) == null) continue;
            newPreName = info.getPreName();
            newPreElement = info.getPreElement();
            index = info.getIndex();
        }
        return HdxPageInfoDo.builder().index(index).preElement(newPreElement).preName(newPreName).build();
    }

    private static String getPosition(String position) {
        int index = position.lastIndexOf(".");
        int nowPosition = Integer.parseInt(position.substring(index + 1)) + 1;
        return position.substring(0, index) + "." + nowPosition;
    }

    private static String positionPush(String position) {
        return position + ".0";
    }

    private static String positionPop(String position) {
        int index = position.lastIndexOf(".");
        return position.substring(0, index);
    }

    public static void sortExpandLibs(List<NaviExpandDo> expands) {
        if (CollectionUtils.isEmpty(expands)) {
            return;
        }
        Collections.sort(expands, new Comparator<NaviExpandDo>(){

            @Override
            public int compare(NaviExpandDo first, NaviExpandDo second) {
                BigDecimal priorityOne = NavInit.getBigDecimal(first.getTargetPriority());
                BigDecimal priorityTwo = NavInit.getBigDecimal(second.getTargetPriority());
                return priorityOne.compareTo(priorityTwo);
            }
        });
    }

    private static BigDecimal getBigDecimal(String priorityStr) {
        BigDecimal priority;
        if (StringUtils.isBlank((CharSequence)priorityStr)) {
            return BigDecimal.ZERO;
        }
        try {
            priority = new BigDecimal(priorityStr);
        }
        catch (NumberFormatException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getBigDecimal error.", (Throwable)e);
            priority = BigDecimal.ZERO;
        }
        return priority;
    }
}

