/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.parse;

import com.huawei.support.icscbb.hdx.common.navi.dto.NaviContentDo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class NaviParserUtils {
    private static final String XPATH_EXPRESSION = "//topic[@%s='%s']";

    private NaviParserUtils() {
    }

    public static List<NaviContentDo> getChilds(Document document, String position) {
        if (document == null || StringUtils.isBlank((CharSequence)position)) {
            return new ArrayList<NaviContentDo>();
        }
        Element node = NaviParserUtils.getElementByPosition(document, position);
        if (node == null) {
            return new ArrayList<NaviContentDo>();
        }
        return NaviParserUtils.getChildContentDtos(node);
    }

    public static List<NaviContentDo> getFirstFloor(Document document) {
        Element rootNode = document.getRootElement();
        if (rootNode == null) {
            return new ArrayList<NaviContentDo>();
        }
        return NaviParserUtils.getChildContentDtos(rootNode);
    }

    public static List<NaviContentDo> getByTopicId(Document document, String topicId) {
        if (document == null || StringUtils.isBlank((CharSequence)topicId)) {
            return new ArrayList<NaviContentDo>();
        }
        Element node = NaviParserUtils.getElementByTopic(document, topicId);
        if (node == null) {
            return new ArrayList<NaviContentDo>();
        }
        return NaviParserUtils.getNavisForTargetNode(node);
    }

    public static List<NaviContentDo> getByTopicUrl(Document document, String topicUrl) {
        if (document == null || StringUtils.isBlank((CharSequence)topicUrl)) {
            return new ArrayList<NaviContentDo>();
        }
        Element node = NaviParserUtils.getElementByTopicUrl(document, topicUrl);
        if (node == null) {
            return new ArrayList<NaviContentDo>();
        }
        return NaviParserUtils.getNavisForTargetNode(node);
    }

    public static Element getPreNode(Document document, String position) {
        Element preNode = null;
        if (document == null || StringUtils.isBlank((CharSequence)position)) {
            return preNode;
        }
        Element curNode = NaviParserUtils.getElementByPosition(document, position);
        if (curNode == null) {
            return preNode;
        }
        Element parent = curNode.getParent();
        if (parent == null) {
            return preNode;
        }
        List elements = parent.elements();
        for (int i = 0; i < elements.size(); ++i) {
            if (elements.get(i) != curNode) continue;
            if (i == 0) {
                preNode = StringUtils.equals((CharSequence)"topics", (CharSequence)parent.getQName().getQualifiedName()) ? null : parent;
                break;
            }
            preNode = NaviParserUtils.getLastChild((Element)elements.get(i - 1));
            break;
        }
        return preNode;
    }

    private static Element getLastChild(Element node) {
        if (node == null) {
            return node;
        }
        List elements = node.elements();
        if (CollectionUtils.isEmpty((Collection)elements)) {
            return node;
        }
        Element element = (Element)elements.get(elements.size() - 1);
        return NaviParserUtils.getLastChild(element);
    }

    public static Element getNextNode(Document document, String position) {
        Element nextNode = null;
        if (document == null || StringUtils.isBlank((CharSequence)position)) {
            return nextNode;
        }
        Element curNode = NaviParserUtils.getElementByPosition(document, position);
        if (curNode == null) {
            return nextNode;
        }
        List childrens = curNode.elements();
        if (CollectionUtils.isNotEmpty((Collection)childrens)) {
            return (Element)childrens.get(0);
        }
        return NaviParserUtils.getNext(curNode);
    }

    private static Element getNext(Element curNode) {
        Element nextNode = null;
        Element parent = curNode.getParent();
        if (parent == null) {
            return nextNode;
        }
        List elements = parent.elements();
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != curNode) continue;
            if (i == size - 1) {
                nextNode = NaviParserUtils.getNext(parent);
                break;
            }
            nextNode = (Element)elements.get(i + 1);
            break;
        }
        return nextNode;
    }

    private static List<NaviContentDo> getNavisForTargetNode(Element node) {
        String position;
        Stack<String> nodes = new Stack<String>();
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        Element parent = node;
        while (!NaviParserUtils.isParentElementEmpty(parent) && (position = NaviParserUtils.getCurrentPosition(parent = parent.getParent())) != null) {
            nodes.push(position);
            elementMap.put(position, parent);
        }
        ArrayList<NaviContentDo> naviContentDos = new ArrayList<NaviContentDo>();
        List<NaviContentDo> navis = NaviParserUtils.getChildContentDtos(parent);
        naviContentDos.addAll(navis);
        block1: while (!nodes.empty()) {
            String targetPostion = (String)nodes.pop();
            for (int index = 0; index < navis.size(); ++index) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)targetPostion, (CharSequence)navis.get(index).getPosition())) continue;
                Element element = (Element)elementMap.get(navis.get(index).getPosition());
                navis = NaviParserUtils.getChildContentDtos(element);
                naviContentDos.addAll(navis);
                continue block1;
            }
        }
        return naviContentDos;
    }

    private static String getCurrentPosition(Element parent) {
        String position = parent.attributeValue("position");
        if (StringUtils.isBlank((CharSequence)position)) {
            if (parent.getParent() == null) {
                return null;
            }
            position = "";
        }
        return position;
    }

    private static boolean isParentElementEmpty(Element node) {
        Element parent = node.getParent();
        return parent == null || parent.getQName() == null;
    }

    public static Element getElementByTopic(Document document, String topicId) {
        return NaviParserUtils.getElementByParam(document, NaviParserUtils.getTopicXpathExpression("id", topicId));
    }

    private static Element getElementByTopicUrl(Document document, String topicUrl) {
        return NaviParserUtils.getElementByParam(document, NaviParserUtils.getTopicXpathExpression("url", topicUrl));
    }

    private static Element getElementByPosition(Document document, String position) {
        return NaviParserUtils.getElementByParam(document, NaviParserUtils.getTopicXpathExpression("position", position));
    }

    private static String getTopicXpathExpression(String parameter, String value) {
        return String.format(Locale.ENGLISH, XPATH_EXPRESSION, parameter, value.replaceAll("'", "&apos;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;"));
    }

    private static Element getElementByParam(Document document, String param) {
        Element rootNode = document.getRootElement();
        if (rootNode == null) {
            return null;
        }
        Node tempNode = rootNode.selectSingleNode(param);
        if (tempNode == null || !(tempNode instanceof Element)) {
            return null;
        }
        return (Element)tempNode;
    }

    private static List<NaviContentDo> getChildContentDtos(Element node) {
        ArrayList<NaviContentDo> navis = new ArrayList<NaviContentDo>();
        String parentPosition = node.attributeValue("position");
        List elements = node.elements();
        for (Element el : elements) {
            NaviContentDo.NaviContentDoBuilder<?, ?> builder = NaviContentDo.builder();
            builder.docId(el.attributeValue("docId"));
            builder.topicDocId(el.attributeValue("topicDocId"));
            builder.topicId(el.attributeValue("id"));
            builder.libId(el.attributeValue("libId"));
            builder.libv(el.attributeValue("libVersion"));
            builder.baseLibId(el.attributeValue("baseLibId"));
            builder.baseLibv(el.attributeValue("baseLibVersion"));
            builder.name(el.attributeValue("txt"));
            builder.topicUrl(el.attributeValue("url"));
            builder.isParent(el.content().size() > 0 ? "true" : "false");
            builder.position(el.attributeValue("position"));
            builder.parentPosition(parentPosition);
            navis.add((NaviContentDo)builder.build());
        }
        return navis;
    }
}

