/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.parse;

import com.huawei.support.icscbb.hdx.common.navi.dto.NaviAttributeDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviBaseDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviContentDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviExpandDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.XmlPropertyMappingEnum;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.wsf.core.HWEncoder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxInitNavi
extends DefaultHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SaxInitNavi.class);
    private static final String NAVIPATH = "resources/navi.xml";
    private static final String ATTRSTART = "=\"";
    private static final String ATTREND = "\" ";
    private static final String TOPICEND = "</topic>";
    private static final int MAXLENGTH = 10000;
    private final String savePath;
    private Map<String, List<NaviExpandDo>> expandMap;
    private NaviBaseDo baseDo;
    private NaviBaseDo patchDo;
    private NaviAttributeDo expandDo;
    private String currentPosition;
    private String preName = "";
    private String nextName = "";
    private NaviAttributeDo tempPreTopic;
    private Stack<NaviAttributeDo> topicInfoStack = new Stack();
    private StringBuilder xmlSb;
    private int num = 0;
    private boolean isBase = true;

    public SaxInitNavi(String tempSavePath, NaviBaseDo baseLib, List<NaviExpandDo> expandLibs) {
        this.savePath = tempSavePath;
        this.baseDo = Optional.ofNullable(baseLib).orElse(new NaviBaseDo());
        this.xmlSb = new StringBuilder();
        this.currentPosition = ".0";
        this.processingExpands(expandLibs);
        this.createXml();
    }

    public SaxInitNavi(String tempSavePath, NaviBaseDo baseLib, NaviBaseDo patchLib, List<NaviExpandDo> expandLibs) {
        this.savePath = tempSavePath;
        this.baseDo = Optional.ofNullable(baseLib).orElse(new NaviBaseDo());
        this.xmlSb = new StringBuilder();
        this.patchDo = patchLib;
        this.currentPosition = ".0";
        this.processingExpands(expandLibs);
        this.createXml();
    }

    public SaxInitNavi(String tempSavePath, NaviContentDo baseInfo, NaviAttributeDo expandInfo) {
        this.savePath = tempSavePath;
        this.baseDo = new NaviBaseDo();
        this.baseDo.setDocId(baseInfo.getDocId());
        this.baseDo.setLibId(baseInfo.getLibId());
        this.baseDo.setLibV(baseInfo.getLibv());
        this.expandDo = new NaviAttributeDo();
        this.expandDo.setDocId(baseInfo.getTopicDocId());
        this.preName = expandInfo.getPreName();
        this.nextName = expandInfo.getNextName();
        this.xmlSb = expandInfo.getXmlContent();
        this.currentPosition = this.getFirstPosition(baseInfo.getPosition());
        this.isBase = false;
        this.expandMap = new LinkedHashMap<String, List<NaviExpandDo>>();
        this.num = StringUtils.isBlank((CharSequence)baseInfo.getPageNum()) ? this.num : new BigDecimal(baseInfo.getPageNum()).intValue();
    }

    public static String getAttributeValue(Attributes attributes, String attrName) {
        String value = attributes.getValue(attrName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private void createXml() {
        if (!this.isBase) {
            return;
        }
        this.writerContent(this.savePath, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><topics ", false);
    }

    private void processingExpands(List<NaviExpandDo> expandLibs) {
        this.expandMap = new LinkedHashMap<String, List<NaviExpandDo>>();
        if (CollectionUtils.isEmpty(expandLibs)) {
            return;
        }
        expandLibs.forEach(expand -> {
            String targetTopicId = expand.getTargetTopicId();
            List<NaviExpandDo> naviExpandDos = this.expandMap.get(targetTopicId);
            if (CollectionUtils.isEmpty(naviExpandDos)) {
                naviExpandDos = new LinkedList<NaviExpandDo>();
            }
            naviExpandDos.add((NaviExpandDo)expand);
            this.expandMap.put(targetTopicId, naviExpandDos);
        });
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        switch (qname) {
            case "topics": {
                if (!this.isBase) break;
                this.xmlSb.append("quickComparison").append(ATTRSTART).append(this.encodeForXmlAttr((String)StringUtils.defaultIfEmpty((CharSequence)SaxInitNavi.getAttributeValue(attributes, "quickComparison"), (CharSequence)""))).append(ATTREND).append(">");
                break;
            }
            case "topic": {
                NaviAttributeDo topicElement = this.createTopicElement(attributes, this.getPosition(), this.getParentPosition());
                this.topicInfoStack.push(topicElement);
                this.addTopicToSb(topicElement);
                this.positionPush();
                break;
            }
            default: {
                CodeCCUtils.INSTANCE.debugLog(LOGGER, "startElement unKnow qName:{0} ", new Object[]{qname});
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (StringUtils.equals((CharSequence)"topic", (CharSequence)qname)) {
            NaviAttributeDo currentTopic = this.topicInfoStack.pop();
            String curTopicId = currentTopic.getTopicId();
            this.addExpandsAndGetLastTopic(this.getPositionUp(this.currentPosition).substring(1), this.getExpandsByTargetId(curTopicId, "2"));
            this.xmlSb.append(TOPICEND);
            this.positionPop();
            Optional<NaviAttributeDo> lastTopic = this.addExpandsAndGetLastTopic(this.getPositionUp(this.currentPosition).substring(1), this.getExpandsByTargetId(curTopicId, "1"));
            if (lastTopic.isPresent()) {
                this.adjustCurrentPostion(lastTopic.get().getPosition());
            }
            this.expandMap.remove(curTopicId);
            if (this.xmlSb.length() >= 10000) {
                this.writerContent(this.savePath, this.xmlSb.toString(), true);
                this.xmlSb.setLength(0);
            }
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "endElement unKnow qName:{0} ", new Object[]{qname});
        }
    }

    @Override
    public void endDocument() {
        if (!this.isBase) {
            return;
        }
        this.addSurplusExpands();
        this.xmlSb.append("<topicTotal ").append("topicTotal").append(ATTRSTART).append(this.num).append(ATTREND).append("/>").append("</topics>");
        this.writerContent(this.savePath, this.xmlSb.toString(), true);
    }

    private void addSurplusExpands() {
        LinkedList<NaviExpandDo> expandList = new LinkedList<NaviExpandDo>();
        this.expandMap.forEach((key, value) -> expandList.addAll((Collection<NaviExpandDo>)value));
        this.expandMap.clear();
        this.addExpandsAndGetLastTopic(this.getPosition(), expandList);
    }

    private NaviAttributeDo createTopicElement(Attributes attributes, String position, String parentPosition) {
        String topicId = SaxInitNavi.getAttributeValue(attributes, "id");
        String name = SaxInitNavi.getAttributeValue(attributes, "txt");
        this.setNextName(name);
        Optional<NaviAttributeDo> lastTopic = this.addExpandsAndGetLastTopic(position, this.getExpandsByTargetId(topicId, "0"));
        NaviAttributeDo.NaviAttributeDoBuilder<?, ?> builder = NaviAttributeDo.builder();
        builder.position(position);
        if (lastTopic.isPresent()) {
            this.adjustCurrentPostion(lastTopic.get().getPosition());
            builder.position(this.getPosition());
        }
        NaviBaseDo tempBaseDo = this.patchDo != null ? this.patchDo : this.baseDo;
        builder.docId(tempBaseDo.getDocId());
        builder.baseLibId(this.baseDo.getLibId());
        builder.baseLibv(this.baseDo.getLibV());
        builder.isParent("false");
        builder.parentPosition(parentPosition);
        builder.pageNum(String.valueOf(this.num++));
        builder.name(name);
        builder.topicId(topicId);
        this.builderTopicDocId(attributes, builder, tempBaseDo);
        builder.libId(SaxInitNavi.getAttributeValue(attributes, "libId"));
        builder.libv(SaxInitNavi.getAttributeValue(attributes, "libVersion"));
        builder.topicUrl(SaxInitNavi.getAttributeValue(attributes, "url"));
        builder.target(SaxInitNavi.getAttributeValue(attributes, "target"));
        builder.isLargePage(SaxInitNavi.getAttributeValue(attributes, "isLargePage"));
        builder.preName(this.preName);
        this.tempPreTopic = builder.build();
        this.preName = this.tempPreTopic.getName();
        return builder.build();
    }

    private void builderTopicDocId(Attributes attributes, NaviAttributeDo.NaviAttributeDoBuilder<?, ?> builder, NaviBaseDo tempBaseDo) {
        if (StringUtils.equals((CharSequence)SaxInitNavi.getAttributeValue(attributes, "libId"), (CharSequence)this.baseDo.getLibId()) && StringUtils.equals((CharSequence)SaxInitNavi.getAttributeValue(attributes, "libVersion"), (CharSequence)this.baseDo.getLibV())) {
            builder.topicDocId(this.baseDo.getDocId());
        } else {
            builder.topicDocId(this.expandDo == null ? tempBaseDo.getDocId() : this.expandDo.getDocId());
        }
    }

    private Optional<NaviAttributeDo> addExpandsAndGetLastTopic(String position, List<NaviExpandDo> expands) {
        if (CollectionUtils.isEmpty(expands)) {
            return Optional.empty();
        }
        NaviAttributeDo lastTopic = null;
        String tempPosition = position;
        String tempCurPos = this.currentPosition;
        NaviBaseDo tempBaseDo = this.patchDo != null ? this.patchDo : this.baseDo;
        for (NaviExpandDo expand : expands) {
            String docPath = expand.getDocPath();
            try {
                InputStream is = ZipFilePool.getInputStream((String)docPath, (String)NAVIPATH);
                Throwable throwable = null;
                try {
                    if (is == null) {
                        CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "%s is not found.", expand.getDocId()));
                        continue;
                    }
                    Object naviContentDo = ((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)((NaviContentDo.NaviContentDoBuilder)NaviContentDo.builder().docId(tempBaseDo.getDocId())).topicDocId(expand.getDocId())).libId(this.baseDo.getLibId())).libv(this.baseDo.getLibV())).position(tempPosition)).pageNum(String.valueOf(this.num))).build();
                    NaviContentDo naviAttributeDo = ((NaviAttributeDo.NaviAttributeDoBuilder)((NaviAttributeDo.NaviAttributeDoBuilder)NaviAttributeDo.builder().preName(this.preName)).xmlContent(this.xmlSb)).build();
                    SaxInitNavi saxParser = new SaxInitNavi(this.savePath, (NaviContentDo)naviContentDo, (NaviAttributeDo)naviAttributeDo);
                    SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
                    lastTopic = saxParser.getLastTopic();
                    if (lastTopic == null) continue;
                    this.num = StringUtils.isBlank((CharSequence)lastTopic.getPageNum()) ? this.num : new BigDecimal(lastTopic.getPageNum()).intValue();
                    ++this.num;
                    this.tempPreTopic = lastTopic;
                    this.preName = this.tempPreTopic.getName();
                    tempCurPos = this.getTempCurPos(tempCurPos, this.tempPreTopic.getPosition());
                    tempPosition = this.getPositionUp(tempCurPos).substring(1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | SAXException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, String.format(Locale.ENGLISH, "Error parserXml %s.", expand.getDocId()), (Throwable)e);
            }
        }
        return Optional.ofNullable(lastTopic);
    }

    private List<NaviExpandDo> getExpandsByTargetId(String topicId, String position) {
        List<NaviExpandDo> expands = this.expandMap.get(topicId);
        LinkedList<NaviExpandDo> topPositionExpands = new LinkedList<NaviExpandDo>();
        if (CollectionUtils.isNotEmpty(expands)) {
            expands.forEach(expand -> {
                if (StringUtils.equals((CharSequence)position, (CharSequence)expand.getTargetPosition())) {
                    topPositionExpands.add((NaviExpandDo)expand);
                }
            });
        }
        return topPositionExpands;
    }

    private String getPosition() {
        this.currentPosition = this.getPositionUp(this.currentPosition);
        return this.currentPosition.substring(1);
    }

    private String getPositionUp(String curPos) {
        int index = curPos.lastIndexOf(".");
        if (index >= 0) {
            int position = Integer.parseInt(curPos.substring(index + 1)) + 1;
            return curPos.substring(0, index) + "." + position;
        }
        return "";
    }

    private void positionPush() {
        this.currentPosition = this.currentPosition + ".0";
    }

    private void positionPop() {
        int index = this.currentPosition.lastIndexOf(".");
        if (index >= 0) {
            this.currentPosition = this.currentPosition.substring(0, index);
        }
    }

    private String getParentPosition() {
        int index = this.currentPosition.lastIndexOf(".");
        if (index <= 0) {
            return "";
        }
        return this.currentPosition.substring(1, index);
    }

    private String getFirstPosition(String paramPosition) {
        if (StringUtils.isBlank((CharSequence)paramPosition)) {
            return ".0";
        }
        int index = paramPosition.lastIndexOf(".");
        if (index < 0) {
            return "." + (Integer.parseInt(paramPosition) - 1);
        }
        int position = Integer.parseInt(paramPosition.substring(index + 1)) - 1;
        return "." + paramPosition.substring(0, index) + "." + position;
    }

    private void adjustCurrentPostion(String topicPosition) {
        this.currentPosition = this.getTempCurPos(this.currentPosition, topicPosition);
    }

    private String getTempCurPos(String curPos, String topicPosition) {
        String position1;
        String[] splitB;
        String[] splitA = curPos.split("\\.");
        if (splitA.length > (splitB = (position1 = "." + topicPosition).split("\\.")).length) {
            return curPos;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < splitA.length; ++i) {
            if (StringUtils.isBlank((CharSequence)splitB[i])) continue;
            stringBuilder.append(".");
            stringBuilder.append(splitB[i]);
        }
        return stringBuilder.toString();
    }

    private void setNextName(String name) {
        this.nextName = name;
        if (this.tempPreTopic != null) {
            this.preName = this.tempPreTopic.getName();
            this.tempPreTopic.setNextName(this.nextName);
        }
    }

    private void addTopicToSb(NaviAttributeDo tempTopic) {
        StringBuilder tempSb = new StringBuilder();
        tempSb.setLength(0);
        tempSb.append("<topic ");
        this.handlerTopicAttrAppend(tempTopic, tempSb);
        tempSb.append(">");
        this.xmlSb.append((CharSequence)tempSb);
    }

    private void handlerTopicAttrAppend(NaviAttributeDo tempTopic, StringBuilder tempSb) {
        for (XmlPropertyMappingEnum createOrQueryNewXmlMapper : XmlPropertyMappingEnum.values()) {
            tempSb.append(createOrQueryNewXmlMapper.getAttrKeyWhenCreate()).append(ATTRSTART).append(this.encodeForXmlAttr(createOrQueryNewXmlMapper.getAttributeValue(tempTopic))).append(ATTREND);
        }
    }

    private String encodeForXmlAttr(String attr) {
        String str = attr;
        if (StringUtils.isBlank((CharSequence)str)) {
            str = "";
        }
        return HWEncoder.encodeForXMLAttribute((String)str);
    }

    private void writerContent(String path, String content, boolean append) {
        boolean isMkdirs;
        File file = FileUtils.getFile((String[])new String[]{path});
        if (file == null) {
            return;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(isMkdirs = parentFile.mkdirs())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil writeFileContent fail.");
            return;
        }
        try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)file, (boolean)append), StandardCharsets.UTF_8));){
            fileWriter.write(content);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil writeFileContent error.", (Throwable)e);
        }
    }

    public NaviAttributeDo getLastTopic() {
        return this.tempPreTopic;
    }
}

