/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.parse;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviContentDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.XmlPropertyMappingEnum;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParserHdxNavi
extends DefaultHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SaxParserHdxNavi.class);
    private Stack<String> parents = new Stack();
    private Set<String> parentsSet = new HashSet<String>();
    private Branch type;
    private boolean isParent;
    private String targetPositon;
    private String targetTopicId;
    private String targetTopicUrl;
    private String targetLibId;
    private String targetLibV;
    private String targetPageNum;
    private String preName;
    private String nextName;
    private String topicTotal;
    private boolean isNextNode = false;
    private String quickComparison = "";
    private Deque<String> nameDeque = new ArrayDeque<String>();
    private StringBuffer topicsSb = new StringBuffer();
    private StringBuffer topicSb = new StringBuffer();

    public SaxParserHdxNavi(Branch branch) {
        this.initialize(branch);
    }

    public SaxParserHdxNavi(NaviContentDo topic, Branch branch) {
        this.initialize(branch);
        this.targetPositon = topic.getPosition();
        this.targetTopicId = topic.getTopicId();
        this.targetTopicUrl = topic.getTopicUrl();
        this.targetLibId = topic.getLibId();
        this.targetLibV = topic.getLibv();
        this.targetPageNum = topic.getPageNum();
        this.positionHandle();
    }

    private void positionHandle() {
        if (StringUtils.isBlank((CharSequence)this.targetPositon)) {
            return;
        }
        String[] str = this.targetPositon.split("\\.");
        StringBuffer positionSplice = new StringBuffer(str[0]);
        this.parentsSet.add(positionSplice.toString());
        for (int i = 1; i < str.length; ++i) {
            positionSplice.append("." + str[i]);
            this.parentsSet.add(positionSplice.toString());
        }
    }

    private void initialize(Branch branch) {
        this.type = branch;
        this.isParent = false;
        this.topicsSb.setLength(0);
        this.topicsSb.append("[");
        this.preName = "";
        this.nextName = "";
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (Branch.GETTOTAL == this.type && StringUtils.equals((CharSequence)"topicTotal", (CharSequence)qname)) {
            this.setTopicTotal(attributes);
        } else if (StringUtils.equals((CharSequence)"topics", (CharSequence)qname)) {
            this.quickComparison = attributes.getValue("quickComparison");
        } else if (StringUtils.equals((CharSequence)"topic", (CharSequence)qname)) {
            this.addTopic(attributes.getValue("txt"));
            this.isParent = true;
            switch (this.type) {
                case FIRSTFLOOR: {
                    this.setFirstFloorTopics(attributes);
                    break;
                }
                case GETBYPOSITION: {
                    this.setTopicsByPosition(attributes);
                    break;
                }
                case GETCHILD: {
                    this.setChilds(attributes);
                    break;
                }
                case FINDBYURL: {
                    this.findByUrl(attributes);
                    break;
                }
                case FINDBYID: {
                    this.findById(attributes);
                    break;
                }
                case FINDSPECIFYBYURL: {
                    this.findSpecifyByUrl(attributes);
                    break;
                }
                case FINDBYIDIGNORECASE: {
                    this.findByIdIgnoreCase(attributes);
                    break;
                }
                case FINDBYPAGENUM: {
                    this.findByPageNum(attributes);
                    break;
                }
                case GETUPDOWNNAME: {
                    this.getUpDownName(attributes);
                    break;
                }
            }
            this.parents.push(attributes.getValue("position"));
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "startElement unKnow qName:{1} ", new Object[]{qname});
        }
    }

    private void setTopicTotal(Attributes attributes) throws SAXException {
        this.topicTotal = attributes.getValue("topicTotal");
        throw new SAXException("10100002");
    }

    private void getUpDownName(Attributes attributes) {
        if (StringUtils.isBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetPositon, (CharSequence)attributes.getValue("position"))) {
            this.nameDeque.add(attributes.getValue("txt"));
            if (this.isNextNode) {
                this.nextName = this.nameDeque.peekLast();
                this.isNextNode = false;
            }
            return;
        }
        this.preName = this.nameDeque.peekLast();
        this.isNextNode = true;
    }

    private void findByPageNum(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetPageNum, (CharSequence)attributes.getValue("pageNum"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void findByUrl(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetTopicUrl, (CharSequence)attributes.getValue("url"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void findById(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetTopicId, (CharSequence)attributes.getValue("id"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void findSpecifyByUrl(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetTopicUrl, (CharSequence)attributes.getValue("url")) || !StringUtils.equals((CharSequence)this.targetLibId, (CharSequence)attributes.getValue("libId")) || !StringUtils.equals((CharSequence)this.targetLibV, (CharSequence)attributes.getValue("libVersion"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void findByIdIgnoreCase(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equalsIgnoreCase((CharSequence)this.targetTopicId, (CharSequence)attributes.getValue("id"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void setTopicsByPosition(Attributes attributes) {
        if (!this.parents.empty() && !this.parentsSet.contains(this.parents.peek())) {
            return;
        }
        this.creatTopic(attributes);
    }

    private void setChilds(Attributes attributes) {
        if (this.parents.empty() || !StringUtils.equals((CharSequence)this.parents.peek(), (CharSequence)this.targetPositon)) {
            return;
        }
        this.creatTopic(attributes);
    }

    private void setFirstFloorTopics(Attributes attributes) {
        String position = attributes.getValue("position");
        if (position.indexOf(".") >= 0) {
            return;
        }
        this.creatTopic(attributes);
    }

    private void creatTopic(Attributes attributes) {
        this.topicSb.append("{");
        for (XmlPropertyMappingEnum queryNewXmlMapper : XmlPropertyMappingEnum.values()) {
            String attrKeyWhenQuery = queryNewXmlMapper.getAttrKeyWhenQuery();
            if (StringUtils.equalsAny((CharSequence)attrKeyWhenQuery, (CharSequence[])new CharSequence[]{"target", "baseLibv"})) continue;
            this.appendTopicAttr(attrKeyWhenQuery, attributes.getValue(queryNewXmlMapper.getAttrKeyWhenCreate()));
        }
        this.appendTopicAttr("baseLibv", attributes.getValue("libVersion"));
        this.appendTopicAttr("parentPosition", this.parents.empty() ? null : this.parents.peek());
        this.appendTopicAttr("quickComparison", this.quickComparison);
    }

    private void appendTopicAttr(String attrKey, String attrValue) {
        this.topicSb.append(String.format(Locale.ENGLISH, "\"%s\":\"%s\",", attrKey, this.string2Json(attrValue)));
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (StringUtils.equals((CharSequence)qname, (CharSequence)"topic")) {
            this.parents.pop();
            this.isParent = false;
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "endElement unKnow qName:{1} ", new Object[]{qname});
        }
    }

    @Override
    public void endDocument() {
        this.addTopic("");
        this.topicsSb.replace(this.topicsSb.length() - 1, this.topicsSb.length(), "]");
        this.quickComparison = "";
    }

    private void addTopic(String topicNextName) {
        if (this.topicSb.length() <= 0) {
            return;
        }
        this.topicSb.append(String.format(Locale.ENGLISH, "\"nextName\":\"%s\",", this.string2Json(topicNextName)));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"isParent\":\"%s\"", this.isParent));
        this.topicSb.append("},");
        this.topicsSb.append(this.topicSb);
        this.topicSb.setLength(0);
    }

    public String getPostion() {
        return this.targetPositon;
    }

    public String getTopicStr() {
        if (this.topicsSb.length() <= 1) {
            return JSON.toJSONString(new ArrayList());
        }
        return this.topicsSb.toString();
    }

    public int getTotal() {
        int totalInt = 0;
        if (StringUtils.isNotBlank((CharSequence)this.topicTotal)) {
            totalInt = new BigDecimal(this.topicTotal).intValue();
        }
        return totalInt;
    }

    public String getPreName() {
        return Optional.ofNullable(this.preName).orElse("");
    }

    public String getNextName() {
        return Optional.ofNullable(this.nextName).orElse("");
    }

    private String string2Json(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                case '/': {
                    sb.append("\\/");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static enum Branch {
        FIRSTFLOOR,
        GETBYPOSITION,
        GETCHILD,
        FINDBYURL,
        FINDSPECIFYBYURL,
        FINDBYID,
        FINDBYIDIGNORECASE,
        FINDBYPAGENUM,
        GETUPDOWNNAME,
        GETTOTAL;

    }
}

