/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hdx.common.navi.service.impl;

import com.huawei.support.icscbb.hdx.common.navi.dao.HdxNaviContentDaoHandler;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviBaseDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviContentDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviExpandDo;
import com.huawei.support.icscbb.hdx.common.navi.parse.NavInit;
import com.huawei.support.icscbb.hdx.common.navi.service.NaviContentService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class NaviContentServiceHandler
implements NaviContentService {
    private NaviContentServiceHandler() {
    }

    public static NaviContentServiceHandler getInstance() {
        return NaviContentServiceHandlerHolder.INSTANCE;
    }

    @Override
    public int init(String savePath, NaviBaseDo baseLib, List<NaviExpandDo> expandLibs) {
        String docId = Optional.ofNullable(baseLib).orElseGet(() -> new NaviBaseDo()).getDocId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, savePath})) {
            return 10100001;
        }
        NavInit.sortExpandLibs(expandLibs);
        return HdxNaviContentDaoHandler.update(savePath, baseLib, expandLibs);
    }

    @Override
    public int initExpand(String savePath, NaviBaseDo expandLib) {
        return this.init(savePath, expandLib, new ArrayList<NaviExpandDo>());
    }

    @Override
    public int initPatch(String savePath, NaviBaseDo baseLib, NaviBaseDo patchLib, List<NaviExpandDo> expandLibs) {
        String docId = Optional.ofNullable(baseLib).orElseGet(NaviBaseDo::new).getDocId();
        String patchDocId = Optional.ofNullable(patchLib).orElseGet(NaviBaseDo::new).getDocId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{savePath, docId, patchDocId})) {
            return 10100001;
        }
        NavInit.sortExpandLibs(expandLibs);
        return HdxNaviContentDaoHandler.updatePatch(savePath, baseLib, patchLib, expandLibs);
    }

    @Override
    public int remove(String path) {
        return HdxNaviContentDaoHandler.remove(path);
    }

    @Override
    public String get(String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{path})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getFirstFloor(path);
    }

    @Override
    public String getByTopicId(String topicId, String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{topicId, path})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getByTopicId(topicId, path);
    }

    @Override
    public String getByTopicIdIgnoreCase(String topicId, String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{topicId, path})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getByTopicIdIgnoreCase(topicId, path);
    }

    @Override
    public String getByTopicUrl(String topicUrl, String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{topicUrl, path})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getByTopicUrl(topicUrl, path);
    }

    @Override
    public String getTreeByTopicUrlWithLib(String path, String topicUrl, String libId, String libV) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{path, topicUrl, libId, libV})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getTreeByTopicUrlWithLib(path, topicUrl, libId, libV);
    }

    @Override
    public String getByPageNum(String pageNum, String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pageNum, path})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getByPageNum(pageNum, path);
    }

    @Override
    public int getTotal(String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{path})) {
            return 0;
        }
        return HdxNaviContentDaoHandler.getTotal(path);
    }

    @Override
    public String getSublist(String position, String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{position, path})) {
            return "";
        }
        return HdxNaviContentDaoHandler.getChilds(position, path);
    }

    @Override
    public Map<String, String> getUpDownName(String position, String path) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{position, path})) {
            return new HashMap<String, String>();
        }
        return HdxNaviContentDaoHandler.getUpDownName(position, path);
    }

    @Override
    public String getNavis(String topicId, String topicUrl, String path) {
        if (StringUtils.isNotBlank((CharSequence)topicId)) {
            return this.getByTopicId(topicId, path);
        }
        if (StringUtils.isNotBlank((CharSequence)topicUrl)) {
            return this.getByTopicUrl(topicUrl, path);
        }
        return this.get(path);
    }

    @Override
    public List<NaviContentDo> getNaviByPosition(String naviXmlPath, String naviPositions) {
        return HdxNaviContentDaoHandler.getNaviByPosition(naviXmlPath, naviPositions);
    }

    @Override
    public int getCountByPosition(String naviXmlPath, String naviPositions) {
        return HdxNaviContentDaoHandler.getCountByPosition(naviXmlPath, naviPositions);
    }

    private static class NaviContentServiceHandlerHolder {
        private static final NaviContentServiceHandler INSTANCE = new NaviContentServiceHandler();

        private NaviContentServiceHandlerHolder() {
        }
    }
}

