/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.util.MapUtils;
import java.util.Map;

public class ConverterKeyBuild {
    private static final Map<Class<?>, Class<?>> BOXING_MAP = MapUtils.newHashMap();

    public static ConverterKey buildKey(Class<?> clazz) {
        return ConverterKeyBuild.buildKey(clazz, null);
    }

    public static ConverterKey buildKey(Class<?> clazz, CellDataTypeEnum cellDataTypeEnum) {
        Class<?> boxingClass = BOXING_MAP.get(clazz);
        if (boxingClass != null) {
            return new ConverterKey(boxingClass, cellDataTypeEnum);
        }
        return new ConverterKey(clazz, cellDataTypeEnum);
    }

    static {
        BOXING_MAP.put(Integer.TYPE, Integer.class);
        BOXING_MAP.put(Byte.TYPE, Byte.class);
        BOXING_MAP.put(Long.TYPE, Long.class);
        BOXING_MAP.put(Double.TYPE, Double.class);
        BOXING_MAP.put(Float.TYPE, Float.class);
        BOXING_MAP.put(Character.TYPE, Character.class);
        BOXING_MAP.put(Short.TYPE, Short.class);
        BOXING_MAP.put(Boolean.TYPE, Boolean.class);
    }

    public static class ConverterKey {
        private Class<?> clazz;
        private CellDataTypeEnum cellDataTypeEnum;

        public Class<?> getClazz() {
            return this.clazz;
        }

        public CellDataTypeEnum getCellDataTypeEnum() {
            return this.cellDataTypeEnum;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setCellDataTypeEnum(CellDataTypeEnum cellDataTypeEnum) {
            this.cellDataTypeEnum = cellDataTypeEnum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConverterKey)) {
                return false;
            }
            ConverterKey other = (ConverterKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            CellDataTypeEnum this$cellDataTypeEnum = this.getCellDataTypeEnum();
            CellDataTypeEnum other$cellDataTypeEnum = other.getCellDataTypeEnum();
            return !(this$cellDataTypeEnum == null ? other$cellDataTypeEnum != null : !((Object)((Object)this$cellDataTypeEnum)).equals((Object)other$cellDataTypeEnum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConverterKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            CellDataTypeEnum $cellDataTypeEnum = this.getCellDataTypeEnum();
            result = result * 59 + ($cellDataTypeEnum == null ? 43 : ((Object)((Object)$cellDataTypeEnum)).hashCode());
            return result;
        }

        public ConverterKey(Class<?> clazz, CellDataTypeEnum cellDataTypeEnum) {
            this.clazz = clazz;
            this.cellDataTypeEnum = cellDataTypeEnum;
        }
    }
}

