/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.offlinedownload.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.offlinedownload.dto.OfflineDownloadUrlDo;
import com.huawei.support.icslite.offlinedownload.mapper.OfflineDownloadMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public enum OfflineDownloadDaoHandler {
    INSTANCE;

    private static final CommonLogger LOG;
    private OfflineDownloadMapper offlineDownloadMapper = (OfflineDownloadMapper)DbMapperUtils.getMapper(OfflineDownloadMapper.class);
    private static final int MAX_DERBY_LIST_SIZE = 200;

    public void createDownloadTb() {
        try {
            this.offlineDownloadMapper.createTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'OFFLINEDOWNLOAD' already exists or create error.", e);
        }
    }

    public int saveDownloadUrls(List<OfflineDownloadUrlDo> supportDownloadUrlDos) {
        int successNum = 0;
        try {
            int size = supportDownloadUrlDos.size();
            int index = 0;
            while (size > 200) {
                successNum += this.offlineDownloadMapper.saveDownloadUrls(supportDownloadUrlDos.subList(200 * index, 200 * (index + 1)));
                size -= 200;
                ++index;
            }
            successNum += this.offlineDownloadMapper.saveDownloadUrls(supportDownloadUrlDos.subList(index * 200, supportDownloadUrlDos.size()));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "saveDownloadUrls ERROR", e);
        }
        return successNum;
    }

    public List<OfflineDownloadUrlDo> getWillDownloadUrls() {
        ArrayList<OfflineDownloadUrlDo> willDownloadUrls = new ArrayList();
        try {
            willDownloadUrls = this.offlineDownloadMapper.getWillDownloadUrls();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getWillDownloadUrls ERROR", e);
        }
        return willDownloadUrls;
    }

    public int deleteDownloadTasks(List<String> taskIds) {
        int successNum = 0;
        try {
            successNum = this.offlineDownloadMapper.deleteDownloadTasks(taskIds);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "deleteDownloadTasks ERROR", e);
        }
        return successNum;
    }

    public int deleteAll() {
        int successNum = 0;
        try {
            successNum = this.offlineDownloadMapper.deleteAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "deleteAll ERROR", e);
        }
        return successNum;
    }

    public int getDownloadUrlsNum() {
        int downLoadUrlsNum = 0;
        try {
            downLoadUrlsNum = this.offlineDownloadMapper.getDownloadUrlsNum();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getDownloadUrlsNum ERROR", e);
        }
        return downLoadUrlsNum;
    }

    static {
        LOG = CommonLoggerFactory.getLogger(OfflineDownloadDaoHandler.class);
    }
}

