/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.service.lmpl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.LibVerifyDto;
import com.huawei.support.icscbb.verify.constant.CMSVerifyConstants;
import com.huawei.support.icscbb.verify.service.CMSVerifyService;
import com.huawei.support.icscbb.verify.util.CMSVerify;
import com.huawei.support.icscbb.verify.util.SignatureType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;

public class CMSVerifyServiceImpl
implements CMSVerifyService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CMSVerifyServiceImpl.class);

    private CMSVerifyServiceImpl() {
    }

    public static CMSVerifyServiceImpl getInstance() {
        return CMSVerifyServiceHandlerHolder.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String verify(LibVerifyDto libVerifyDto) {
        File file = FileUtils.getFile((String[])new String[]{libVerifyDto.getFilePath()});
        if (file == null) return "None";
        if (!file.isFile()) {
            return "None";
        }
        CMSVerify cmsVerify = new CMSVerify();
        cmsVerify.addCrlFile(libVerifyDto.getCrlFilePath());
        cmsVerify.addCrtData(this.getCrtBytes());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            cmsVerify.setSrcInputStream(fileInputStream, 0L, libVerifyDto.getLibFileEndIndex());
            cmsVerify.setSigData(libVerifyDto.getSigDataBytes());
            cmsVerify.addExpectedPurposeId("1.3.6.1.4.1.2011.201.1.3.4");
            String string = cmsVerify.verify() ? "Success" : "Failed";
            return string;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to read the file.", (Throwable)e);
            return "IOException";
        }
        catch (GeneralSecurityException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The CRL file or root certificate is incorrect.", (Throwable)e);
            return "Failed";
        }
        catch (AnnotatedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to read the CRL file.", (Throwable)e);
            return "Failed";
        }
        catch (CMSException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The source file or signature file is incorrect.", (Throwable)e);
            return "Failed";
        }
        catch (OperatorCreationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "OperatorCreationException.", (Throwable)e);
            return "Failed";
        }
        catch (TSPException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "TSPException.", (Throwable)e);
        }
        return "Failed";
    }

    private byte[] getCrtBytes() {
        StringBuffer builder = new StringBuffer();
        builder.append("-----BEGIN CERTIFICATE-----" + System.lineSeparator());
        builder.append(CMSVerifyConstants.CERT_PEM_CONTENT + System.lineSeparator());
        builder.append("-----END CERTIFICATE-----");
        String content = builder.toString();
        return content.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean verify(String signatureFilePath, String softwareFilePath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signatureFilePath, softwareFilePath})) {
            return false;
        }
        try {
            CMSVerify cmsVerify = new CMSVerify();
            cmsVerify.addCrtData(this.getCrtBytes());
            cmsVerify.setSigFile(signatureFilePath);
            cmsVerify.setSrcFile(softwareFilePath);
            cmsVerify.setSignatureType(SignatureType.RELEASE_SIGNATURE);
            return cmsVerify.verify();
        }
        catch (GeneralSecurityException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The CRL file or root certificate is incorrect.", (Throwable)e);
        }
        catch (AnnotatedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to read the CRL file.", (Throwable)e);
        }
        catch (CMSException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The source file or signature file is incorrect.", (Throwable)e);
        }
        catch (OperatorCreationException | TSPException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "TSPException | OperatorCreationException", e);
        }
        return false;
    }

    private static class CMSVerifyServiceHandlerHolder {
        private static final CMSVerifyServiceImpl INSTANCE = new CMSVerifyServiceImpl();

        private CMSVerifyServiceHandlerHolder() {
        }
    }
}

