/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.service.lmpl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.constant.PGPVerifyConstants;
import com.huawei.support.icscbb.verify.service.PGPVerifyService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;

public class PGPVerifyServiceImpl
implements PGPVerifyService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(PGPVerifyServiceImpl.class);
    private Map<Long, PGPPublicKey> PGP_PUBLIC_KEY_MAP = new HashMap<Long, PGPPublicKey>();

    private PGPVerifyServiceImpl() {
    }

    public static PGPVerifyServiceImpl getInstance() {
        return PGPVerifyServiceHandlerHolder.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean verify(String signatureFilePath, String softwareFilePath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signatureFilePath, softwareFilePath})) {
            return false;
        }
        try (FileInputStream softwareFile = new FileInputStream(softwareFilePath);){
            int readIndex;
            PGPSignatureList signatureList = this.obtainSignatureData(signatureFilePath);
            if (signatureList == null || signatureList.size() <= 0) {
                boolean bl = false;
                return bl;
            }
            PGPSignature signature = signatureList.get(0);
            PGPPublicKey publicKey = this.PGP_PUBLIC_KEY_MAP.get(signature.getKeyID());
            if (publicKey == null) {
                boolean bl = false;
                return bl;
            }
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), publicKey);
            byte[] buffer = new byte[32768];
            while ((readIndex = softwareFile.read(buffer)) != -1) {
                signature.update(buffer, 0, readIndex);
            }
            boolean bl = signature.verify();
            return bl;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "PGPVerifyService failed to read the file.", (Throwable)e);
            return false;
        }
        catch (PGPException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "PGPVerifyService the source file or signature file is incorrect.", (Throwable)e);
        }
        return false;
    }

    private void initPublicKey(byte[] key) throws IOException, PGPException {
        if (key == null || key.length == 0) {
            return;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(key);){
            PGPPublicKeyRingCollection pgpPubRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Iterator iterator = pgpPubRingCollection.getKeyRings();
            while (iterator.hasNext()) {
                PGPPublicKeyRing pgpPublicKeys = (PGPPublicKeyRing)iterator.next();
                if (pgpPublicKeys == null) continue;
                PGPPublicKey pgpPublicKey = pgpPublicKeys.getPublicKey();
                if (pgpPublicKeys == null) continue;
                this.PGP_PUBLIC_KEY_MAP.put(pgpPublicKey.getKeyID(), pgpPublicKey);
            }
        }
    }

    private PGPSignatureList obtainSignatureData(String signatureFilePath) throws IOException, PGPException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.initPublicKey(this.getKeyBytes(PGPVerifyConstants.PGP_KEYS_CONTENT.toString()));
        this.initPublicKey(this.getKeyBytes(PGPVerifyConstants.PGP_KEYS_ECC_CONTENT.toString()));
        PGPSignatureList signatureList = null;
        try (FileInputStream signatureFileIn = new FileInputStream(signatureFilePath);
             InputStream signatureIn = PGPUtil.getDecoderStream((InputStream)signatureFileIn);){
            PGPObjectFactory pgpFactory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)signatureIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Object keyList = pgpFactory.nextObject();
            if (keyList == null) {
                PGPSignatureList pGPSignatureList = signatureList;
                return pGPSignatureList;
            }
            Object tempSignatureList = keyList;
            if (keyList instanceof PGPCompressedData) {
                PGPCompressedData pgpCompressedData = (PGPCompressedData)keyList;
                pgpFactory = new PGPObjectFactory(pgpCompressedData.getDataStream(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                tempSignatureList = pgpFactory.nextObject();
            }
            if (tempSignatureList instanceof PGPSignatureList) {
                signatureList = (PGPSignatureList)tempSignatureList;
            }
        }
        return signatureList;
    }

    private byte[] getKeyBytes(String content) {
        StringBuilder builder = new StringBuilder();
        builder.append("-----BEGIN PGP PUBLIC KEY BLOCK-----" + System.lineSeparator());
        builder.append(content + System.lineSeparator());
        builder.append("-----END PGP PUBLIC KEY BLOCK-----");
        String key = builder.toString();
        return key.getBytes(StandardCharsets.UTF_8);
    }

    private static class PGPVerifyServiceHandlerHolder {
        private static final PGPVerifyServiceImpl INSTANCE = new PGPVerifyServiceImpl();

        private PGPVerifyServiceHandlerHolder() {
        }
    }
}

