/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.verify.util.HashAlgorithm;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public enum Algorithm {
    RSA_SHA1("RSA", HashAlgorithm.SHA1, "SHA1WITHRSA"),
    RSA_SHA256("RSA", HashAlgorithm.SHA256, "SHA256WITHRSA"),
    RSA_SHA384("RSA", HashAlgorithm.SHA384, "SHA384WITHRSA"),
    RSA_SHA512("RSA", HashAlgorithm.SHA512, "SHA512WITHRSA"),
    ECDSA_SHA1("ECDSA", HashAlgorithm.SHA1, "SHA1WITHECDSA"),
    ECDSA_SHA256("ECDSA", HashAlgorithm.SHA256, "SHA256WITHECDSA"),
    ECDSA_SHA384("ECDSA", HashAlgorithm.SHA384, "SHA384WITHECDSA"),
    ECDSA_SHA512("ECDSA", HashAlgorithm.SHA512, "SHA512WITHECDSA"),
    RSAPSS_SHA1("RSAPSS", HashAlgorithm.SHA1, "SHA1WITHRSAANDMGF1"),
    RSAPSS_SHA256("RSAPSS", HashAlgorithm.SHA256, "SHA256WITHRSAANDMGF1"),
    RSAPSS_SHA384("RSAPSS", HashAlgorithm.SHA384, "SHA384WITHRSAANDMGF1"),
    RSAPSS_SHA512("RSAPSS", HashAlgorithm.SHA512, "SHA512WITHRSAANDMGF1"),
    SM2_SHA1("SM2", HashAlgorithm.SHA1, "SHA1WITHSM2"),
    SM2_SM3("SM2", HashAlgorithm.SM3, "SM3WITHSM2");

    private final AlgorithmIdentifier algId;
    private final HashAlgorithm hashAlgo;
    private final boolean rsapss;
    private final String jceName;

    private Algorithm(String type, HashAlgorithm hashAlgo, String jceName) {
        this.hashAlgo = hashAlgo;
        this.jceName = jceName;
        this.rsapss = "RSAPSS".equalsIgnoreCase(type);
        if ("RSA".equals(type)) {
            ASN1ObjectIdentifier oid = this.getRsaObject(hashAlgo);
            this.algId = new AlgorithmIdentifier(oid, (ASN1Encodable)DERNull.INSTANCE);
        } else if ("ECDSA".equals(type)) {
            ASN1ObjectIdentifier oid = this.getEcdsaObject(hashAlgo);
            this.algId = new AlgorithmIdentifier(oid);
        } else if ("SM2".equals(type)) {
            ASN1ObjectIdentifier oid = this.getSm2Object(hashAlgo);
            this.algId = new AlgorithmIdentifier(oid);
        } else if ("RSAPSS".equals(type)) {
            int saltSize = hashAlgo.getHashSize();
            AlgorithmIdentifier digAlgId = hashAlgo.getAlgId();
            RSASSAPSSparams params = new RSASSAPSSparams(digAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)digAlgId), new ASN1Integer((long)saltSize), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
            this.algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)params);
        } else {
            throw new IllegalArgumentException("cannot reach here");
        }
    }

    private ASN1ObjectIdentifier getRsaObject(HashAlgorithm hashAlgo) {
        if (hashAlgo == HashAlgorithm.SHA1) {
            return PKCSObjectIdentifiers.sha1WithRSAEncryption;
        }
        if (hashAlgo == HashAlgorithm.SHA256) {
            return PKCSObjectIdentifiers.sha256WithRSAEncryption;
        }
        if (hashAlgo == HashAlgorithm.SHA384) {
            return PKCSObjectIdentifiers.sha384WithRSAEncryption;
        }
        if (hashAlgo == HashAlgorithm.SHA512) {
            return PKCSObjectIdentifiers.sha512WithRSAEncryption;
        }
        throw new IllegalArgumentException("shoult not reach here");
    }

    private ASN1ObjectIdentifier getEcdsaObject(HashAlgorithm hashAlgo) {
        if (hashAlgo == HashAlgorithm.SHA1) {
            return X9ObjectIdentifiers.ecdsa_with_SHA1;
        }
        if (hashAlgo == HashAlgorithm.SHA256) {
            return X9ObjectIdentifiers.ecdsa_with_SHA256;
        }
        if (hashAlgo == HashAlgorithm.SHA384) {
            return X9ObjectIdentifiers.ecdsa_with_SHA384;
        }
        if (hashAlgo == HashAlgorithm.SHA512) {
            return X9ObjectIdentifiers.ecdsa_with_SHA512;
        }
        throw new IllegalArgumentException("shoult not reach here");
    }

    private ASN1ObjectIdentifier getSm2Object(HashAlgorithm hashAlgo) {
        if (hashAlgo == HashAlgorithm.SHA1) {
            return GMObjectIdentifiers.sm2sign_with_sha1;
        }
        if (hashAlgo == HashAlgorithm.SM3) {
            return GMObjectIdentifiers.sm2sign_with_sm3;
        }
        throw new IllegalArgumentException("hash " + (Object)((Object)hashAlgo) + " not allowed for SM2");
    }

    public static Optional<Algorithm> ofAlgId(AlgorithmIdentifier algId) {
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)oid)) {
            RSASSAPSSparams params = RSASSAPSSparams.getInstance((Object)algId.getParameters());
            ASN1ObjectIdentifier hashOid = params.getHashAlgorithm().getAlgorithm();
            for (Algorithm algorithm : Algorithm.values()) {
                if (!algorithm.isRsapss() || !algorithm.getHashAlgo().getOid().equals((ASN1Primitive)hashOid)) continue;
                return Optional.of(algorithm);
            }
        }
        for (Algorithm algorithm : Algorithm.values()) {
            if (algorithm.isRsapss() || !algorithm.getAlgId().getAlgorithm().equals((ASN1Primitive)oid)) continue;
            return Optional.of(algorithm);
        }
        return Optional.empty();
    }

    public HashAlgorithm getHashAlgo() {
        return this.hashAlgo;
    }

    public AlgorithmIdentifier getAlgId() {
        return this.algId;
    }

    public String getJceName() {
        return this.jceName;
    }

    public boolean isRsapss() {
        return this.rsapss;
    }
}

