/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.verify.util.CMSVerifyTsUtil;
import com.huawei.support.icscbb.verify.util.CMSVerifyUtil;
import com.huawei.support.icscbb.verify.util.CertCtx;
import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmsValidationException;
import com.huawei.support.icscbb.verify.util.CmscbbErr;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import com.huawei.support.icscbb.verify.util.CrlWrapper;
import com.huawei.support.icscbb.verify.util.InternalCmscbbConf;
import com.huawei.support.icscbb.verify.util.PkiValidator;
import com.huawei.support.icscbb.verify.util.SignatureType;
import com.huawei.support.icscbb.verify.util.ValidationResult;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CMSVerify {
    private static final String VERSION = "Signature Verify CBB Library 22.0.1";
    private final CertCtx certCtx = new CertCtx();
    private boolean checkTsaSignatureCrl = true;
    private InternalCmscbbConf conf;

    public CMSVerify() {
        this((String)null, null, null, null);
    }

    public CMSVerify(String sigFile, String srcFile, String[] crtFiles, String[] crlFiles) {
        this.certCtx.setSigFile(sigFile);
        this.certCtx.setSrcFile(srcFile);
        this.setCertAndCrlFiles(crtFiles, crlFiles);
    }

    public CMSVerify(byte[] sigData, String srcFile, String[] crtFiles, String[] crlFiles) {
        this.certCtx.setSigData(sigData);
        this.certCtx.setSrcFile(srcFile);
        this.setCertAndCrlFiles(crtFiles, crlFiles);
    }

    public CMSVerify(String sigFile, InputStream srcInputStream, long startIndex, long endIndex, String[] crtFiles, String[] crlFiles) {
        this.certCtx.setSigFile(sigFile);
        this.certCtx.setSrcInputStream(srcInputStream, startIndex, endIndex);
        this.setCertAndCrlFiles(crtFiles, crlFiles);
    }

    public CMSVerify(byte[] sigData, InputStream srcInputStream, long startIndex, long endIndex, String[] crtFiles, String[] crlFiles) {
        this.certCtx.setSigData(sigData);
        this.certCtx.setSrcInputStream(srcInputStream, startIndex, endIndex);
        this.setCertAndCrlFiles(crtFiles, crlFiles);
    }

    public static String getVersion() {
        return VERSION;
    }

    private void setCertAndCrlFiles(String[] crtFiles, String[] crlFiles) {
        if (crtFiles != null) {
            for (String str : crtFiles) {
                this.certCtx.getCrtFiles().add(str);
            }
        }
        if (crlFiles != null) {
            for (String str : crlFiles) {
                this.certCtx.getCrlFiles().add(str);
            }
        }
    }

    public SignatureType getSignatureType() {
        return this.certCtx.getSignatureType();
    }

    public void setSignatureType(SignatureType signatureType) {
        this.certCtx.setSignatureType(signatureType);
    }

    public void addExpectedPurposeId(String oid) {
        this.certCtx.addExpectedPurposeId(oid);
    }

    public void setCheckTsaEndEntryByCrl(boolean checkTsaEntryByCrl) {
        this.checkTsaSignatureCrl = checkTsaEntryByCrl;
    }

    public void reSet() {
        this.certCtx.reset();
        this.conf.cleanUp();
        this.checkTsaSignatureCrl = true;
    }

    public String[] getCrlFile() {
        List<String> list = this.certCtx.getCrlFiles();
        return list.toArray(new String[list.size()]);
    }

    public String[] getCrtFile() {
        List<String> list = this.certCtx.getCrtFiles();
        return list.toArray(new String[list.size()]);
    }

    public String getSrcFile() {
        return this.certCtx.getSrcFile();
    }

    public void setSrcFile(String srcFile) {
        this.certCtx.setSrcFile(srcFile);
    }

    public void setSrcInputStream(InputStream srcInputStream) throws IOException {
        this.certCtx.setSrcInputStream(srcInputStream, 0L, srcInputStream.available() - 1);
    }

    public void setSrcInputStream(InputStream srcInputStream, long startIndex, long endIndex) {
        this.certCtx.setSrcInputStream(srcInputStream, startIndex, endIndex);
    }

    public void addCrlFile(String crlFile) {
        this.certCtx.getCrlFiles().add(crlFile);
    }

    public void addCrtData(byte[] data) {
        this.certCtx.getCrtDatas().add((byte[])data.clone());
    }

    public void addCrtFile(String crtFile) {
        this.certCtx.getCrtFiles().add(crtFile);
    }

    public void addCrlData(byte[] data) {
        this.certCtx.getCrlDatas().add((byte[])data.clone());
    }

    public void setSigFile(String sigFile) {
        this.certCtx.setSigFile(sigFile);
    }

    public byte[] getSigData() throws AnnotatedException {
        return this.certCtx.getSigData();
    }

    public void setSigData(byte[] sigData) {
        this.certCtx.setSigData(sigData);
    }

    public boolean verify() throws GeneralSecurityException, AnnotatedException, CMSException, OperatorCreationException, TSPException {
        X509CertificateHolder signCertHold;
        SignerInformation signer;
        try {
            this.conf = new InternalCmscbbConf(this.certCtx);
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException(e.getMessage());
        }
        CMSSignedData signed = new CMSSignedData(this.certCtx.getSrcData(), this.certCtx.getSigData());
        try {
            signer = this.checkSingedData(signed);
            signCertHold = this.extractCertsAndCrl(signed, signer.getSID());
            PkiValidator pkiVerifier = new PkiValidator(this.conf);
            List<CrlWrapper> crlWrappers = this.conf.getCrlWrappers();
            ValidationResult res = new ValidationResult();
            res.setErrorCode(CmscbbErr.OK);
            this.getDate(signer, pkiVerifier, res, crlWrappers);
            CertWrapper targetCert = new CertWrapper(signCertHold);
            CmscbbErr err = this.checkCertUsage(false, targetCert);
            if (err != CmscbbErr.OK) {
                throw new CMSException(err.toString());
            }
            pkiVerifier.checkTrustOfSignerCert(res, false, targetCert, crlWrappers);
            this.checkRes(res);
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException((Object)((Object)e.getErrorCode()) + e.getErrorMessage());
        }
        SignerInformationVerifier verifier = CommonUtil.genVerifier(signCertHold);
        return signer.verify(verifier);
    }

    private X509CertificateHolder extractCertsAndCrl(CMSSignedData signedData, SignerId sID) throws AnnotatedException, GeneralSecurityException, CmsValidationException {
        Store crlHolders = signedData.getCRLs();
        if (!(crlHolders instanceof CollectionStore)) {
            throw new AnnotatedException("Type conversion error!");
        }
        CollectionStore crls = (CollectionStore)crlHolders;
        for (X509CRLHolder crl : crls) {
            this.conf.addCrlToMap(crl);
        }
        Store store = signedData.getCertificates();
        if (!(store instanceof CollectionStore)) {
            throw new AnnotatedException("Type conversion error!");
        }
        CollectionStore certs = (CollectionStore)store;
        X509CertificateHolder signedCert = null;
        for (X509CertificateHolder certHolder : certs) {
            X509Certificate cert = CommonUtil.coverte(certHolder);
            if (CommonUtil.isSelfIssued(cert)) continue;
            this.conf.addCertToList(certHolder);
            if (!sID.match((Object)certHolder)) continue;
            signedCert = certHolder;
        }
        if (signedCert != null) {
            return signedCert;
        }
        return this.conf.getSignCert(sID).getCert();
    }

    private SignerInformation checkSingedData(CMSSignedData signed) throws AnnotatedException {
        Iterator it = signed.getSignerInfos().iterator();
        if (!it.hasNext()) {
            throw new AnnotatedException("CMS or Timestamp signature does not have signer information.");
        }
        SignerInformation signer = (SignerInformation)it.next();
        CMSVerifyUtil.checkHashAlgo(signer.getDigestAlgorithmID(), signed.getDigestAlgorithmIDs());
        if (it.hasNext()) {
            throw new AnnotatedException(CmscbbErr.PKI_CMS_INVALID_NUM_SIGNER_INFO.toString());
        }
        CMSVerifyUtil.checkSignedDataOid(signed.toASN1Structure().getContentType().getId(), signer.getEncryptionAlgOID());
        return signer;
    }

    private void getDate(SignerInformation signer, PkiValidator pkiVerifier, ValidationResult res, List<CrlWrapper> crls) throws TSPException, CMSException, AnnotatedException, OperatorCreationException, GeneralSecurityException {
        ASN1Set uat;
        AttributeTable uats = signer.getUnsignedAttributes();
        if (uats != null && (uat = uats.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken).getAttrValues()) != null) {
            ASN1Encodable asn1 = uat.getObjectAt(0);
            this.getSignDate(asn1, signer, pkiVerifier, res, crls);
        }
    }

    private void getSignDate(ASN1Encodable asn1, SignerInformation signer, PkiValidator pkiVerifier, ValidationResult res, List<CrlWrapper> crls) throws CMSException, TSPException, AnnotatedException, GeneralSecurityException, OperatorCreationException {
        TimeStampToken tspToken;
        if (asn1 == null) {
            throw new AnnotatedException("ASN1Encodable is null.");
        }
        try {
            CMSSignedData tspCms = new CMSSignedData(asn1.toASN1Primitive().getEncoded());
            if (tspCms.getSignerInfos().size() == 0) {
                throw new TSPValidationException(CmscbbErr.PKI_TST_NO_SIGNER_INFO.toString());
            }
            if (tspCms.getSignerInfos().size() > 1) {
                throw new TSPValidationException(CmscbbErr.PKI_TST_INVALID_NUM_SIGNER_INFO.toString());
            }
            tspToken = new TimeStampToken(new CMSSignedData(asn1.toASN1Primitive().getEncoded()));
        }
        catch (IOException e) {
            throw new AnnotatedException(null, (Throwable)e);
        }
        CMSProcessableByteArray tspData = new CMSProcessableByteArray(signer.getSignature());
        this.checkTimeStamp((CMSTypedData)tspData, tspToken, pkiVerifier, res, crls);
    }

    private void checkTimeStamp(CMSTypedData content, TimeStampToken tspToken, PkiValidator pkiVerifier, ValidationResult res, List<CrlWrapper> crls) throws AnnotatedException, OperatorCreationException, TSPException, GeneralSecurityException, CMSException {
        this.checkSingedData(tspToken.toCMSSignedData());
        TimeStampTokenInfo tspInfo = tspToken.getTimeStampInfo();
        CommonUtil.checkAlgAlgorithm(tspInfo.getHashAlgorithm().getAlgorithm().getId());
        X509CertificateHolder signCertHold = null;
        try {
            signCertHold = this.extractCertsAndCrl(tspToken.toCMSSignedData(), tspToken.getSID());
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException(e.getErrorCode().toString());
        }
        Date date = tspInfo.getGenTime();
        pkiVerifier.setVerificationTime(date);
        if (this.checkTsaSignatureCrl) {
            try {
                CertWrapper targetCert = new CertWrapper(signCertHold);
                CmscbbErr err = this.checkCertUsage(true, targetCert);
                if (err != CmscbbErr.OK) {
                    throw new CMSException(err.toString());
                }
                pkiVerifier.checkTrustOfSignerCert(res, true, targetCert, crls);
                this.checkRes(res);
            }
            catch (CmsValidationException e) {
                throw new AnnotatedException(e.getErrorMessage());
            }
        } else {
            X509Certificate tsaEndCert = CommonUtil.coverte(signCertHold);
            if (!signCertHold.isValidOn(date)) {
                throw new CertPathBuilderException(CmscbbErr.PKI_CERT_DATETIME_EXPIRED.toString());
            }
            CMSVerifyTsUtil.checkTimestampCertChainWithoutEndCrl(tspToken.toCMSSignedData(), date, tsaEndCert, this.conf.getAllCert(), this.conf.getCrlMap());
        }
        SignerInformationVerifier verifier = CommonUtil.genVerifier(signCertHold);
        tspToken.validate(verifier);
        CMSVerifyTsUtil.verifyTSPMatchCMS(verifier, content, tspToken);
    }

    private CmscbbErr checkCertUsage(boolean timestamp, CertWrapper targetCert) {
        Extension exKeyUsage = targetCert.getCert().getExtension(Extension.extendedKeyUsage);
        if (exKeyUsage == null) {
            return CmscbbErr.PKI_CERT_EXTENDKEYUSAGE;
        }
        ExtendedKeyUsage ex = ExtendedKeyUsage.getInstance((Object)exKeyUsage.getParsedValue());
        Set<Object> expectPur = timestamp ? new HashSet<KeyPurposeId>(Arrays.asList(KeyPurposeId.id_kp_timeStamping)) : this.conf.getExpectedKeyUsages();
        for (KeyPurposeId keyPurposeId : expectPur) {
            if (ex.hasKeyPurposeId(keyPurposeId)) continue;
            return CmscbbErr.PKI_CERT_UNMATCHED_PURPOSE;
        }
        if (!targetCert.hasUsages(128)) {
            return CmscbbErr.PKI_CERT_KEYUSAGE;
        }
        return CmscbbErr.OK;
    }

    private void checkRes(ValidationResult res) throws CertPathBuilderException {
        if (res.getErrorCode() != CmscbbErr.OK) {
            throw new CertPathBuilderException("Failed to build the certificate chain, error:" + res.toString());
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BouncyCastleProvider provider = new BouncyCastleProvider();
        provider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA256WITHECDSA", "EC");
        provider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA384WITHECDSA", "EC");
        provider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA512WITHECDSA", "EC");
        Security.removeProvider("BC");
        Security.addProvider((Provider)provider);
    }
}

