/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.util.CMSProvider;
import com.huawei.support.icscbb.verify.util.CMSVerifyBuilder;
import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmscbbErr;
import com.huawei.support.icscbb.verify.util.DigestAlgorithmCalculator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.util.CollectionStore;

public final class CommonUtil {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CommonUtil.class);
    private static final String EXTENSION_CRLNUMBER_OID = "2.5.29.20";
    private static final DigestAlgorithmIdentifierFinder DIGESTALG_IDENTIFIER_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private static final Set<String> ALG_NAMES = new HashSet<String>();

    private CommonUtil() {
    }

    public static void checkCAUsage(X509Certificate issuerCert) throws AnnotatedException {
        if (issuerCert.getKeyUsage() == null) {
            throw new AnnotatedException("Key usage is null, certficcate subject:" + issuerCert.getSubjectX500Principal().getName() + ".");
        }
        if (!issuerCert.getKeyUsage()[5]) {
            throw new AnnotatedException("Certficate have not certficate sign usage, certficcate subject:" + issuerCert.getSubjectX500Principal().getName() + ".");
        }
        if (!issuerCert.getKeyUsage()[6]) {
            throw new AnnotatedException("Certficate have not crl sign usage, certficcate subject:" + issuerCert.getSubjectX500Principal().getName() + ".");
        }
    }

    public static void checkAlgAlgorithm(String algOID) throws AnnotatedException {
        if (!ALG_NAMES.contains(algOID)) {
            throw new AnnotatedException(CmscbbErr.PKI_CERT_SIG_ALGO.toString());
        }
    }

    public static X509Certificate coverte(X509CertificateHolder certificateHolder) throws GeneralSecurityException {
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
    }

    public static X509CRL coverte(X509CRLHolder crlHolder) throws GeneralSecurityException {
        return new JcaX509CRLConverter().setProvider("BC").getCRL(crlHolder);
    }

    public static boolean isSelfIssued(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    public static SignerInformationVerifier genVerifier(X509CertificateHolder holder) throws OperatorCreationException {
        return new CMSProvider((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), new DigestAlgorithmCalculator()).build(holder);
    }

    public static CmscbbErr checkRevokeReason(CRLReason reason) {
        if (reason != CRLReason.AFFILIATION_CHANGED && reason != CRLReason.SUPERSEDED && reason != CRLReason.CESSATION_OF_OPERATION) {
            return CmscbbErr.PKI_CERT_REVOKED;
        }
        return CmscbbErr.OK;
    }

    public static X509Certificate getSignCert(CollectionStore<X509CertificateHolder> certs, X500Principal x500Principal, List<CertWrapper> certList) throws GeneralSecurityException, AnnotatedException {
        X509Certificate x509Cert;
        for (X509CertificateHolder x509CertHolder : certs) {
            x509Cert = CommonUtil.coverte(x509CertHolder);
            if (x509Cert == null || !x509Cert.getSubjectX500Principal().equals(x500Principal)) continue;
            return x509Cert;
        }
        for (CertWrapper certWrapper : certList) {
            x509Cert = CommonUtil.coverte(certWrapper.getCert());
            if (!x509Cert.getSubjectX500Principal().equals(x500Principal)) continue;
            return x509Cert;
        }
        throw new AnnotatedException("Failed to get sign cert.");
    }

    public static boolean fileIsEmpty(String filePath) {
        File file = new File(filePath);
        return file.exists() && file.length() == 0L;
    }

    public static int crlCompare(X509CRL crlNew, X509CRL crlOld) throws CRLException {
        boolean isErr;
        BigInteger crlNewValue = CommonUtil.getCrlNumber(crlNew);
        BigInteger crlOldValue = CommonUtil.getCrlNumber(crlOld);
        if (crlNewValue == null || crlOldValue == null) {
            throw new CRLException("crl has't crlnumber extension.");
        }
        int compareTo = crlNewValue.compareTo(crlOldValue);
        boolean beforeRes = crlNew.getThisUpdate().before(crlOld.getThisUpdate());
        boolean afterRes = crlNew.getThisUpdate().after(crlOld.getThisUpdate());
        boolean firstConditon = compareTo >= 0 && beforeRes;
        boolean secondConditon = compareTo <= 0 && afterRes;
        boolean thirdConditon = compareTo != 0 && beforeRes == afterRes;
        boolean bl = isErr = firstConditon || secondConditon || thirdConditon;
        if (isErr) {
            throw new CRLException("crl has't Invalid CRLNumber.");
        }
        return compareTo;
    }

    private static BigInteger getCrlNumber(X509CRL crl) {
        byte[] crlNumberExtension = crl.getExtensionValue(new ASN1ObjectIdentifier(EXTENSION_CRLNUMBER_OID).getId());
        return ASN1Integer.getInstance((Object)ASN1OctetString.getInstance((Object)crlNumberExtension).getOctets()).getValue();
    }

    public static void updateFile(String file, List<byte[]> updateData) throws AnnotatedException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            for (byte[] data : updateData) {
                fos.write(data);
            }
        }
        catch (FileNotFoundException e) {
            throw new AnnotatedException("The file to be updated is not found.");
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "An exception occurred when updating the file.", (Throwable)e);
            throw new AnnotatedException("An exception occurred when updating the file.");
        }
    }

    public static <T> void requireNonNull(T param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException(paramName + " must not be null");
        }
    }

    public static ContentVerifierProvider getContentVerifierProvider(SubjectPublicKeyInfo keyInfo) throws InvalidKeyException {
        CMSVerifyBuilder builder = new CMSVerifyBuilder(DIGESTALG_IDENTIFIER_FINDER);
        try {
            AsymmetricKeyParameter keyParam = PublicKeyFactory.createKey((SubjectPublicKeyInfo)keyInfo);
            return builder.build(keyParam);
        }
        catch (IOException | OperatorCreationException ex) {
            throw new InvalidKeyException("could not build ContentVerifierProvider: " + ex.getMessage(), ex);
        }
    }

    static {
        ALG_NAMES.add(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
        ALG_NAMES.add(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId());
        ALG_NAMES.add(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId());
        ALG_NAMES.add(NISTObjectIdentifiers.id_sha256.getId());
        ALG_NAMES.add(NISTObjectIdentifiers.id_sha384.getId());
        ALG_NAMES.add(NISTObjectIdentifiers.id_sha512.getId());
        ALG_NAMES.add(PKCSObjectIdentifiers.id_RSASSA_PSS.getId());
        ALG_NAMES.add(X9ObjectIdentifiers.ecdsa_with_SHA384.getId());
        ALG_NAMES.add(X9ObjectIdentifiers.ecdsa_with_SHA256.getId());
        ALG_NAMES.add(X9ObjectIdentifiers.ecdsa_with_SHA512.getId());
    }
}

