/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.verify.util.CertPath;
import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmsValidationException;
import com.huawei.support.icscbb.verify.util.CmscbbErr;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CRLReason;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.cert.X509CRLHolder;

public class CrlWrapper
implements Comparable<CrlWrapper> {
    private final CrlIssuer crlIssuer;
    private final X509CRLHolder crl;
    private final boolean isIndirect;
    private final Date thisUpdate;
    private final Date nextUpdate;
    private final BigInteger crlNumber;
    private final Map<X500Name, Set<BigInteger>> revokedMap = new HashMap<X500Name, Set<BigInteger>>();
    private Boolean verified;
    private CertPath issuerCertPath;

    public CrlWrapper(X509CRLHolder crl) throws CmsValidationException {
        CommonUtil.requireNonNull(crl, "crl");
        this.crl = crl;
        this.thisUpdate = crl.getThisUpdate();
        this.nextUpdate = crl.getNextUpdate();
        Extension extn = this.getNonNullExtension(crl, Extension.authorityKeyIdentifier);
        byte[] aki = AuthorityKeyIdentifier.getInstance((Object)extn.getParsedValue()).getKeyIdentifier();
        if (this.thisUpdate == null || this.nextUpdate == null || aki == null) {
            throw new CmsValidationException(CmscbbErr.PKI_CRL_DECODE);
        }
        this.crlIssuer = new CrlIssuer(crl.getIssuer(), aki);
        extn = this.getNonNullExtension(crl, Extension.cRLNumber);
        this.crlNumber = ASN1Integer.getInstance((Object)extn.getParsedValue()).getPositiveValue();
        this.isIndirect = this.isIndirectCrl(crl);
        TBSCertList tbs = crl.toASN1Structure().getTBSCertList();
        if (this.isIndirect) {
            this.filledRevokedMap(tbs);
        } else {
            HashSet<BigInteger> set = new HashSet<BigInteger>();
            this.revokedMap.put(this.crlIssuer.getIssuer(), set);
            for (TBSCertList.CRLEntry crlEntry : tbs.getRevokedCertificates()) {
                set.add(crlEntry.getUserCertificate().getPositiveValue());
            }
        }
    }

    private Extension getNonNullExtension(X509CRLHolder crl, ASN1ObjectIdentifier oid) throws CmsValidationException {
        Extension extn = crl.getExtension(oid);
        if (extn == null) {
            throw new CmsValidationException(CmscbbErr.PKI_CRL_MISSING_EXTN);
        }
        return extn;
    }

    private boolean isIndirectCrl(X509CRLHolder crl) {
        Extensions extensions = crl.getExtensions();
        if (extensions == null) {
            return false;
        }
        Extension ext = extensions.getExtension(Extension.issuingDistributionPoint);
        return ext != null && IssuingDistributionPoint.getInstance((Object)ext.getParsedValue()).isIndirectCRL();
    }

    private void filledRevokedMap(TBSCertList tbs) {
        this.revokedMap.put(this.crlIssuer.getIssuer(), new HashSet());
        X500Name ca = this.crlIssuer.getIssuer();
        boolean ignoreTillNextCa = false;
        for (TBSCertList.CRLEntry revokedCert : tbs.getRevokedCertificates()) {
            Extension ext = revokedCert.getExtensions().getExtension(Extension.certificateIssuer);
            Map<X500Name, Boolean> ignoreTillNextCaMap = this.getIgnoreTillNextCaMap(ext, ca, ignoreTillNextCa);
            for (Map.Entry<X500Name, Boolean> entry : ignoreTillNextCaMap.entrySet()) {
                ca = entry.getKey();
                ignoreTillNextCa = entry.getValue();
            }
            if (ignoreTillNextCa) continue;
            Set<Object> set = null;
            if (this.revokedMap.containsKey(ca)) {
                set = this.revokedMap.get(ca);
            } else {
                set = new HashSet();
                this.revokedMap.put(ca, set);
            }
            set.add(revokedCert.getUserCertificate().getPositiveValue());
        }
    }

    private Map<X500Name, Boolean> getIgnoreTillNextCaMap(Extension ext, X500Name ca, boolean ignoreTillNextCa) {
        HashMap<X500Name, Boolean> res = new HashMap<X500Name, Boolean>(1);
        if (ext == null) {
            res.put(ca, ignoreTillNextCa);
            return res;
        }
        GeneralNames gns = GeneralNames.getInstance((Object)ext.getParsedValue());
        for (GeneralName gn : gns.getNames()) {
            if (gn.getTagNo() != 4) {
                res.put(ca, true);
                continue;
            }
            res.put(X500Name.getInstance((Object)gn.getName()), false);
        }
        return res;
    }

    public X509CRLHolder getCrl() {
        return this.crl;
    }

    public Date getThisUpdate() {
        return (Date)this.thisUpdate.clone();
    }

    public Date getNextUpdate() {
        return (Date)this.nextUpdate.clone();
    }

    public CrlIssuer getCrlIssuer() {
        return this.crlIssuer;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public CertPath getIssuerCertPath() {
        return this.issuerCertPath;
    }

    public void setIssuerCertPath(CertPath issuerCertPath) {
        this.issuerCertPath = issuerCertPath;
    }

    public boolean isCandidateForCert(CertWrapper cert) {
        return this.revokedMap.containsKey(cert.getIssuer());
    }

    public boolean isRevoked(CertWrapper cert, Date verificationTime, boolean timestamp) throws GeneralSecurityException {
        CRLReason reason;
        if (!this.revokedMap.get(cert.getIssuer()).contains(cert.getSerialNumber())) {
            return false;
        }
        X509CRLEntry crlEntry = this.getCrlEntry(CommonUtil.coverte(cert.getCert())).get();
        if (crlEntry == null) {
            return true;
        }
        if (this.needToCheckRevokeReason(timestamp, cert.isCA()) && CommonUtil.checkRevokeReason(reason = crlEntry.getRevocationReason()) != CmscbbErr.OK) {
            return true;
        }
        return crlEntry.getRevocationDate().before(verificationTime);
    }

    private boolean needToCheckRevokeReason(boolean timestamp, boolean isCA) {
        return timestamp || isCA;
    }

    private Optional<X509CRLEntry> getCrlEntry(X509Certificate cert) throws GeneralSecurityException {
        X509CRL x509CRL = CommonUtil.coverte(this.crl);
        for (X509CRLEntry x509CRLEntry : x509CRL.getRevokedCertificates()) {
            if (!x509CRLEntry.getSerialNumber().equals(cert.getSerialNumber())) continue;
            return Optional.of(x509CRLEntry);
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(CrlWrapper other) {
        int compare = other.thisUpdate.compareTo(this.thisUpdate);
        if (compare == 0 && this.crlNumber != null && other.crlNumber != null) {
            compare = other.crlNumber.compareTo(this.crlNumber);
        }
        return compare;
    }

    public boolean isRelatedCert(CertPath certpath) {
        if (this.issuerCertPath == null) {
            return false;
        }
        CertWrapper cert = certpath.getTarget();
        X500Name certIssuer = cert.getIssuer();
        Set<BigInteger> set = this.revokedMap.get(certIssuer);
        if (set == null) {
            return false;
        }
        CertWrapper issuerOfTarget = certpath.getIssuerOfTarget();
        boolean canProvide = this.issuerCertPath.getTarget().equals(issuerOfTarget);
        if (!canProvide) {
            canProvide = this.issuerCertPath.getIssuerOfTarget().equals(issuerOfTarget);
        }
        return canProvide;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrlWrapper that = (CrlWrapper)o;
        boolean firstResult = this.isIndirect == that.isIndirect && Objects.equals(this.crlIssuer, that.crlIssuer) && Objects.equals(this.crl, that.crl);
        boolean secondResult = Objects.equals(this.thisUpdate, that.thisUpdate) && Objects.equals(this.nextUpdate, that.nextUpdate) && Objects.equals(this.crlNumber, that.crlNumber);
        boolean thirdResult = Objects.equals(this.revokedMap, that.revokedMap) && Objects.equals(this.verified, that.verified) && Objects.equals(this.issuerCertPath, that.issuerCertPath);
        return firstResult && secondResult && thirdResult;
    }

    public int hashCode() {
        return Objects.hash(this.crlIssuer, this.crl, this.isIndirect, this.thisUpdate, this.nextUpdate, this.crlNumber, this.revokedMap, this.verified, this.issuerCertPath);
    }

    public static class CrlIssuer {
        private final X500Name issuer;
        private final byte[] aki;

        private CrlIssuer(X500Name issuer, byte[] aki) {
            this.issuer = issuer;
            this.aki = aki;
        }

        public X500Name getIssuer() {
            return this.issuer;
        }

        public byte[] getAki() {
            return (byte[])this.aki.clone();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CrlIssuer)) {
                return false;
            }
            CrlIssuer crlIssuerObj = (CrlIssuer)obj;
            return this.issuer.equals((Object)crlIssuerObj.getIssuer()) && Arrays.equals(this.aki, crlIssuerObj.getAki());
        }

        public int hashCode() {
            return this.issuer.hashCode() + 7 * Arrays.hashCode(this.aki);
        }
    }
}

