/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class DigestAlgorithmCalculator
implements DigestCalculatorProvider {
    private final Map<ASN1ObjectIdentifier, Digest> digestAlgorithmMap = new HashMap<ASN1ObjectIdentifier, Digest>();

    public DigestAlgorithmCalculator() {
        this.digestAlgorithmMap.put(OIWObjectIdentifiers.idSHA1, (Digest)new SHA1Digest());
        this.digestAlgorithmMap.put(NISTObjectIdentifiers.id_sha256, (Digest)new SHA256Digest());
        this.digestAlgorithmMap.put(NISTObjectIdentifiers.id_sha384, (Digest)new SHA384Digest());
        this.digestAlgorithmMap.put(NISTObjectIdentifiers.id_sha512, (Digest)new SHA512Digest());
        this.digestAlgorithmMap.put(GMObjectIdentifiers.sm3, (Digest)new SM3Digest());
    }

    public DigestCalculator get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
        Digest digestAlgo = this.digestAlgorithmMap.get(algorithm.getAlgorithm());
        if (digestAlgo == null) {
            throw new OperatorCreationException("cannot recognize digest algorithm.");
        }
        return new CmsDigestCalculator(algorithm, digestAlgo);
    }

    private static class CmsDigestCalculator
    implements DigestCalculator {
        private AlgorithmIdentifier algorithmId;
        private Digest digestAlgo;

        public CmsDigestCalculator(AlgorithmIdentifier algorithm, Digest digestAlgorithm) {
            this.algorithmId = algorithm;
            this.digestAlgo = digestAlgorithm;
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmId;
        }

        public OutputStream getOutputStream() {
            return new ContentStream(this.digestAlgo);
        }

        public byte[] getDigest() {
            byte[] digestValue = new byte[this.digestAlgo.getDigestSize()];
            this.digestAlgo.doFinal(digestValue, 0);
            return digestValue;
        }
    }

    private static class ContentStream
    extends OutputStream {
        private Digest digestAlgo;

        public ContentStream(Digest digestAlgorithm) {
            this.digestAlgo = digestAlgorithm;
        }

        @Override
        public void write(int contentStream) {
            this.digestAlgo.update((byte)contentStream);
        }
    }
}

