/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.AnnotatedException;

public final class FileToX509 {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(FileToX509.class);
    private static final String CLOSE_BYTE_FAILED_STRING = "Close byte array failed.";
    private static final String CERT_STANDARD = "X.509";
    private static final long FILE_LIMIT = 2000000L;
    private static String currentProvider = "BC";
    private static CertificateFactory crtFactory = null;

    private FileToX509() {
    }

    private static synchronized CertificateFactory getCrtFactory() throws CertificateException, NoSuchProviderException {
        if (crtFactory == null) {
            crtFactory = CertificateFactory.getInstance(CERT_STANDARD, currentProvider);
        }
        return crtFactory;
    }

    private static void checkFileSize(String fileName) throws AnnotatedException {
        File file = new File(fileName);
        if (file.exists() && file.length() > 2000000L) {
            throw new AnnotatedException("The file size exceeds the upper limit.");
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readPEM(String filename) throws AnnotatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] readPEM(byte[] data) throws AnnotatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] readSigFile(String sigFile) throws AnnotatedException {
        byte[] sigBuf = FileToX509.readPEM(sigFile);
        if (sigBuf.length == 0) {
            sigBuf = FileToX509.readbuf(sigFile);
        }
        return sigBuf;
    }

    public static byte[] readSigData(byte[] sigData) throws AnnotatedException {
        byte[] sigbuf = FileToX509.readPEM(sigData);
        if (sigbuf.length == 0) {
            sigbuf = sigData;
        }
        return sigbuf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readbuf(String filename) throws AnnotatedException {
        File file = new File(filename);
        FileToX509.checkFileSize(filename);
        try (InputStream ins = Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]);){
            long size = file.length();
            byte[] buf = new byte[(int)size];
            int readSize = ins.read(buf);
            if ((long)readSize != size) {
                throw new AnnotatedException("Read file error.");
            }
            byte[] byArray = buf;
            return byArray;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, CLOSE_BYTE_FAILED_STRING, (Throwable)e);
            throw new AnnotatedException("Read file error.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509CertificateHolder readCertHolder(String filename) throws CertificateException, AnnotatedException {
        File file = new File(filename);
        FileToX509.checkFileSize(filename);
        try (InputStream ins = Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]);){
            X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(FileToX509.generateCrt(ins).getEncoded());
            return x509CertificateHolder;
        }
        catch (IOException | NoSuchProviderException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, CLOSE_BYTE_FAILED_STRING, (Throwable)e);
            throw new AnnotatedException("read cert file failed.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate readCertBuf(byte[] data) throws GeneralSecurityException, AnnotatedException {
        if (data == null) throw new AnnotatedException("Certificate data is empty.");
        try (ByteArrayInputStream ins = new ByteArrayInputStream(data);){
            X509Certificate x509Certificate = FileToX509.generateCrt(ins);
            return x509Certificate;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, CLOSE_BYTE_FAILED_STRING, (Throwable)e);
        }
        throw new AnnotatedException("Certificate data is empty.");
    }

    public static <T> void extractCRLsAndCerts(T hwCrl, List<X509CRLHolder> crlHolders, List<X509CertificateHolder> certHolders) throws GeneralSecurityException, AnnotatedException {
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        FileToX509.extractByCRLFileOrBytes(hwCrl, crlList, certList);
        try {
            for (X509CRL crl : crlList) {
                crlHolders.add(new X509CRLHolder(crl.getEncoded()));
            }
            for (X509Certificate cert : certList) {
                certHolders.add(new X509CertificateHolder(cert.getEncoded()));
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, CLOSE_BYTE_FAILED_STRING, (Throwable)e);
            throw new AnnotatedException("X509*** to X509***Holder failed.");
        }
    }

    private static <T> void extractByCRLFileOrBytes(T hwCrl, List<X509CRL> crlList, List<X509Certificate> certList) throws GeneralSecurityException, AnnotatedException {
        if (hwCrl instanceof String) {
            String crlFileName = (String)hwCrl;
            FileToX509.readCRLs(crlFileName, crlList, certList);
        } else if (hwCrl instanceof byte[]) {
            byte[] crlBytes = (byte[])hwCrl;
            FileToX509.readCRLBuf(crlBytes, crlList, certList);
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The type of Param hwCrl is unsupported.");
            throw new AnnotatedException("The type of Param hwCrl is unsupported.");
        }
    }

    public static void readCRLs(String crlFile, List<X509CRL> crlList, List<X509Certificate> certList) throws GeneralSecurityException, AnnotatedException {
        FileToX509.readCRLBuf(FileToX509.readbuf(crlFile), crlList, certList);
    }

    public static void readCRLBuf(byte[] data, List<X509CRL> crlList, List<X509Certificate> certList) throws GeneralSecurityException, AnnotatedException {
        if (data == null) {
            return;
        }
        int size = data.length;
        try (ByteArrayInputStream ins = new ByteArrayInputStream(data);){
            int remain = ((InputStream)ins).available();
            while (remain != 0) {
                remain = FileToX509.readCRL(ins, size, crlList, certList);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, CLOSE_BYTE_FAILED_STRING, (Throwable)e);
        }
    }

    private static int readCRL(InputStream ins, int size, List<X509CRL> crlList, List<X509Certificate> certList) throws CertificateException, AnnotatedException, IOException, NoSuchProviderException {
        int remain;
        try {
            ins.mark(size);
            X509CRL crl = FileToX509.generateCRL(ins);
            crlList.add(crl);
            remain = ins.available();
        }
        catch (CRLException e) {
            ins.reset();
            X509Certificate cert = FileToX509.generateCrt(ins);
            if (!CommonUtil.isSelfIssued(cert)) {
                certList.add(cert);
            } else {
                CodeCCUtils.INSTANCE.errorLog(LOG, "CRL has a selfissued certificate. It don't participate in CRL verification.");
            }
            remain = ins.available();
        }
        return remain;
    }

    private static X509Certificate generateCrt(InputStream ins) throws CertificateException, NoSuchProviderException, AnnotatedException {
        Certificate crlCert = FileToX509.getCrtFactory().generateCertificate(ins);
        if (!(crlCert instanceof X509Certificate)) {
            throw new AnnotatedException("get X509Certificate failed!");
        }
        return (X509Certificate)crlCert;
    }

    private static X509CRL generateCRL(InputStream ins) throws NoSuchProviderException, AnnotatedException, CRLException, CertificateException {
        CRL crl = FileToX509.getCrtFactory().generateCRL(ins);
        if (!(crl instanceof X509CRL)) {
            throw new AnnotatedException("get X509CRL failed!");
        }
        return (X509CRL)crl;
    }

    public static String getCurrentProvider() {
        return currentProvider;
    }

    public static void setCurrentProvider(String currentProvider) {
        FileToX509.currentProvider = currentProvider;
    }
}

