/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SM3Digest;

public enum HashAlgorithm {
    SHA1("SHA-1", 20, OIWObjectIdentifiers.idSHA1, true),
    SHA256("SHA-256", 32, NISTObjectIdentifiers.id_sha256, false),
    SHA384("SHA-384", 48, NISTObjectIdentifiers.id_sha384, false),
    SHA512("SHA-512", 64, NISTObjectIdentifiers.id_sha512, false),
    SM3("SM3", 32, GMObjectIdentifiers.sm3, false);

    private final int hashSize;
    private final String hashName;
    private final ASN1ObjectIdentifier oid;
    private final AlgorithmIdentifier algId;

    private HashAlgorithm(String hashName, int hashSize, ASN1ObjectIdentifier oid, boolean withNullParams) {
        this.hashSize = hashSize;
        this.hashName = hashName;
        this.oid = oid;
        this.algId = withNullParams ? new AlgorithmIdentifier(oid, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(oid);
    }

    public static HashAlgorithm of(ASN1ObjectIdentifier value) {
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            if (!algorithm.oid.equals((ASN1Primitive)value)) continue;
            return algorithm;
        }
        throw new IllegalArgumentException("unknown ASN1ObjectIdentifier value");
    }

    public int getHashSize() {
        return this.hashSize;
    }

    public String getHashName() {
        return this.hashName;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    public AlgorithmIdentifier getAlgId() {
        return this.algId;
    }

    public byte[] hash(byte[] content) {
        Digest digest = this.createDigest();
        digest.update(content, 0, content.length);
        byte[] res = new byte[digest.getDigestSize()];
        digest.doFinal(res, 0);
        return res;
    }

    public byte[] hash(InputStream contentStream) throws IOException {
        int readed;
        Digest digest = this.createDigest();
        byte[] buffer = new byte[4096];
        while ((readed = contentStream.read(buffer)) != -1) {
            if (readed <= 0) continue;
            digest.update(buffer, 0, readed);
        }
        byte[] messageDigest = new byte[digest.getDigestSize()];
        digest.doFinal(messageDigest, 0);
        return messageDigest;
    }

    public Digest createDigest() {
        switch (this) {
            case SHA1: {
                return new SHA1Digest();
            }
            case SM3: {
                return new SM3Digest();
            }
            case SHA256: {
                return new SHA256Digest();
            }
            case SHA384: {
                return new SHA384Digest();
            }
            case SHA512: {
                return new SHA512Digest();
            }
        }
        throw new IllegalStateException("should not reach here");
    }
}

