/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.util.AlgorithmValidator;
import com.huawei.support.icscbb.verify.util.CertCtx;
import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmsValidationException;
import com.huawei.support.icscbb.verify.util.CmscbbErr;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import com.huawei.support.icscbb.verify.util.CrlWrapper;
import com.huawei.support.icscbb.verify.util.FileToX509;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.jce.provider.AnnotatedException;

public class InternalCmscbbConf {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(InternalCmscbbConf.class);
    private final List<CertWrapper> trustAnchors = new LinkedList<CertWrapper>();
    private final Map<X500Principal, CrlWrapper> crlMap = new HashMap<X500Principal, CrlWrapper>();
    private final List<CertWrapper> certList = new ArrayList<CertWrapper>();
    private Set<KeyPurposeId> expectedKeyUsages = new HashSet<KeyPurposeId>();
    private boolean hasDuplicateCrlIssuer = false;
    private AlgorithmValidator algorithmValidator = new AlgorithmValidator();

    public InternalCmscbbConf(String hwCrlFileName) throws CmsValidationException, GeneralSecurityException, AnnotatedException {
        this.addCertAndCrlFromCrlFile(hwCrlFileName);
        this.resetCrlVerified();
    }

    public InternalCmscbbConf(CertCtx certCtx) throws AnnotatedException, CmsValidationException, GeneralSecurityException, CMSException {
        this.addRootCrt(certCtx);
        this.addExpectedKeyUsages(certCtx);
        for (String crlFile : certCtx.getCrlFiles()) {
            this.addCertAndCrlFromCrlFile(crlFile);
        }
        for (byte[] crlBytes : certCtx.getCrlDatas()) {
            this.addCertAndCrlFromCrlFile(crlBytes);
        }
        this.resetCrlVerified();
    }

    private void addRootCrt(CertCtx certCtx) throws GeneralSecurityException, AnnotatedException {
        for (String crtFile : certCtx.getCrtFiles()) {
            this.addTrustAnchor(FileToX509.readCertHolder(crtFile));
        }
        for (byte[] crtBytes : certCtx.getCrtDatas()) {
            X509Certificate cert = FileToX509.readCertBuf(crtBytes);
            try {
                this.addTrustAnchor(new X509CertificateHolder(cert.getEncoded()));
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Parse X509Certificate's encoded failed.", (Throwable)e);
                throw new AnnotatedException("Parse X509Certificate's encoded failed.");
            }
        }
    }

    private void addExpectedKeyUsages(CertCtx certCtx) throws CMSException {
        for (String oid : certCtx.getSignatureOId()) {
            if (oid == null) {
                throw new CMSException("oid cannot be null");
            }
            try {
                this.expectedKeyUsages.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(oid)));
            }
            catch (IllegalArgumentException e) {
                throw new CMSException(e.getMessage());
            }
        }
    }

    public List<CertWrapper> getTrustAnchors() {
        return this.trustAnchors;
    }

    public Map<X500Principal, CrlWrapper> getCrlMap() {
        return this.crlMap;
    }

    public List<CertWrapper> getCertList() {
        return this.certList;
    }

    public List<CertWrapper> getAllCert() {
        ArrayList<CertWrapper> allCert = new ArrayList<CertWrapper>();
        allCert.addAll(this.certList);
        allCert.addAll(this.trustAnchors);
        return allCert;
    }

    public CertWrapper getSignCert(SignerId sID) throws AnnotatedException {
        for (CertWrapper cert : this.certList) {
            if (!sID.match((Object)cert.getCert())) continue;
            return cert;
        }
        for (CertWrapper cert : this.trustAnchors) {
            if (!sID.match((Object)cert.getCert())) continue;
            return cert;
        }
        throw new AnnotatedException(CmscbbErr.PKI_CERT_NOT_FIND.toString());
    }

    public final <T> void addCertAndCrlFromCrlFile(T hwCrl) throws CmsValidationException, GeneralSecurityException, AnnotatedException {
        ArrayList<X509CertificateHolder> certHolders = new ArrayList<X509CertificateHolder>();
        ArrayList<X509CRLHolder> crlHolders = new ArrayList<X509CRLHolder>();
        FileToX509.extractCRLsAndCerts(hwCrl, crlHolders, certHolders);
        for (X509CertificateHolder certHolder : certHolders) {
            this.addCertToList(certHolder);
        }
        for (X509CRLHolder crlHolder : crlHolders) {
            this.addCrlToMap(crlHolder);
        }
    }

    public void addCrlToMap(X509CRLHolder crlHolder) throws GeneralSecurityException, CmsValidationException {
        X509CRL crl = CommonUtil.coverte(crlHolder);
        X500Principal principal = crl.getIssuerX500Principal();
        if (this.crlMap.containsKey(principal)) {
            this.hasDuplicateCrlIssuer = true;
            X509CRL oldCrl = CommonUtil.coverte(this.crlMap.get(principal).getCrl());
            if (CommonUtil.crlCompare(crl, oldCrl) >= 0) {
                this.crlMap.replace(principal, new CrlWrapper(crlHolder));
            }
        } else {
            this.crlMap.put(principal, new CrlWrapper(crlHolder));
        }
    }

    public void addCertToList(X509CertificateHolder certHolder) throws AnnotatedException {
        try {
            CertWrapper cert = new CertWrapper(certHolder);
            if (!cert.isSelfSigned()) {
                this.certList.add(cert);
            }
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException((Object)((Object)e.getErrorCode()) + ":" + e.getErrorMessage());
        }
    }

    public final void resetCrlVerified() {
        for (CrlWrapper wrapper : this.crlMap.values()) {
            wrapper.setVerified(null);
        }
    }

    public void cleanUp() {
        this.certList.clear();
        this.crlMap.clear();
        this.trustAnchors.clear();
        this.hasDuplicateCrlIssuer = false;
        this.expectedKeyUsages.clear();
    }

    public void addTrustAnchor(X509CertificateHolder trustAnchor) throws AnnotatedException {
        try {
            CertWrapper trust = new CertWrapper(trustAnchor);
            if (trust.isSelfSigned()) {
                this.trustAnchors.add(trust);
            }
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException(e.getErrorMessage());
        }
    }

    public Set<KeyPurposeId> getExpectedKeyUsages() {
        return this.expectedKeyUsages;
    }

    public AlgorithmValidator getAlgorithmValidator() {
        return this.algorithmValidator;
    }

    public void setAlgorithmValidator(AlgorithmValidator algorithmValidator) {
        this.algorithmValidator = algorithmValidator;
    }

    public List<CertWrapper> getCertWrappers() {
        return this.certList;
    }

    public List<X509Certificate> getX509Certs() throws GeneralSecurityException, AnnotatedException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (CertWrapper cert : this.certList) {
            certs.add(CommonUtil.coverte(cert.getCert()));
        }
        for (CertWrapper cert : this.trustAnchors) {
            certs.add(CommonUtil.coverte(cert.getCert()));
        }
        return certs;
    }

    public List<CrlWrapper> getCrlWrappers() {
        return new ArrayList<CrlWrapper>(this.crlMap.values());
    }

    public List<X509CRL> getX509CRLs() throws GeneralSecurityException {
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        for (CrlWrapper crlWrapper : this.crlMap.values()) {
            crls.add(CommonUtil.coverte(crlWrapper.getCrl()));
        }
        return crls;
    }

    public List<CertWrapper> getTrustAnchors(Date verificationTime) {
        ArrayList<CertWrapper> trust = new ArrayList<CertWrapper>();
        for (CertWrapper wrapper : this.trustAnchors) {
            if (!wrapper.isValidOn(verificationTime)) continue;
            trust.add(wrapper);
        }
        return trust;
    }

    public boolean isContainsTrustAnchor(CertWrapper cert) {
        return this.trustAnchors.contains(cert);
    }

    public boolean isHasDuplicateCrlIssuer() {
        return this.hasDuplicateCrlIssuer;
    }
}

