/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.encryption.service.impl;

import com.huawei.support.icscbb.adapter.encryption.dpapi.Dpapi4j;
import com.huawei.support.icscbb.adapter.encryption.dpapi.DpapiCryptMode;
import com.huawei.support.icscbb.adapter.encryption.dpapi.DpapiException;
import com.huawei.support.icscbb.adapter.encryption.help.DpapiMacGeneratorHelper;
import com.huawei.support.icscbb.adapter.encryption.service.DataSecurity;
import com.huawei.support.icscbb.adapter.encryption.util.EncryptionUtils;
import com.huawei.support.icscbb.adapter.encryption.util.HmacSha256Utils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class DpapiDataSecurityHandler
implements DataSecurity {
    private static Dpapi4j dpapi;
    private static final SecurityLogUtils SECURITY_LOGGER;

    private DpapiDataSecurityHandler() {
        DpapiDataSecurityHandler.init();
    }

    private static void init() {
        try {
            dpapi = Dpapi4j.newInstance(DpapiCryptMode.CRYPTPROTECT_UI_FORBIDDEN);
        }
        catch (DpapiException e) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.init Exception", (Throwable)e);
        }
        catch (UnsatisfiedLinkError error) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.init error", (Throwable)error);
        }
    }

    public static final DpapiDataSecurityHandler getInstance() {
        return DpapiDataSecurityHandlerHolder.INSTANCE;
    }

    @Override
    public boolean isNormalEnv() {
        return true;
    }

    @Override
    public byte[] encrypt(int domainId, String plainText) {
        byte[] encrypt = new byte[]{};
        if (StringUtils.isBlank((CharSequence)plainText)) {
            return encrypt;
        }
        if (!Dpapi4j.isOsSupported(dpapi)) {
            return encrypt;
        }
        byte[] plainTextBytes = plainText.getBytes(StandardCharsets.UTF_8);
        try {
            encrypt = dpapi.protectData(plainTextBytes);
        }
        catch (DpapiException e) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.encrypt Exception", (Throwable)e);
        }
        try {
            EncryptionUtils.clearString(plainText);
            EncryptionUtils.clearBytes(plainTextBytes);
        }
        catch (PrivilegedActionException e) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.encrypt Exception", (Throwable)e);
        }
        return encrypt;
    }

    @Override
    public String decrpy(int domainId, byte[] encrypt) {
        if (!Dpapi4j.isOsSupported(dpapi)) {
            return "";
        }
        byte[] decrypt = new byte[]{};
        try {
            decrypt = dpapi.unprotectData(encrypt);
        }
        catch (DpapiException e) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.decrpy Exception", (Throwable)e);
        }
        EncryptionUtils.clearBytes(encrypt);
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] reEncrypt(int domainId, byte[] encrypt) {
        return encrypt;
    }

    @Override
    public byte[] hmac(int domainId, byte[] plainText) {
        String macGenerator = this.getMacGenerator();
        byte[] mac = HmacSha256Utils.generateMac(plainText, macGenerator);
        EncryptionUtils.clearBytes(plainText);
        return mac;
    }

    private String getMacGenerator() {
        try {
            return DpapiMacGeneratorHelper.getInstance().getMacGenerator();
        }
        catch (DpapiException e) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.getMacGenerator exception.", (Throwable)e);
            return "";
        }
    }

    @Override
    public boolean isHmacVerify(int domainId, byte[] plainText, byte[] hmacData) {
        String hmacDataStr = Base64.encodeBase64String((byte[])hmacData);
        byte[] mac = HmacSha256Utils.generateMac(plainText, this.getMacGenerator());
        boolean result = StringUtils.equals((CharSequence)hmacDataStr, (CharSequence)Base64.encodeBase64String((byte[])mac));
        try {
            EncryptionUtils.clearString(hmacDataStr);
            EncryptionUtils.clearBytes(plainText);
            EncryptionUtils.clearBytes(hmacData);
        }
        catch (PrivilegedActionException e) {
            SECURITY_LOGGER.securityLog("icscbb-adapter", "DpapiDataSecurityHandler.isHmacVerify Exception", (Throwable)e);
        }
        return result;
    }

    @Override
    public String getKeyStatusCode(int domainId) {
        return "0";
    }

    static {
        SECURITY_LOGGER = SecurityLogUtils.INSTANCE;
    }

    private static class DpapiDataSecurityHandlerHolder {
        private static final DpapiDataSecurityHandler INSTANCE = new DpapiDataSecurityHandler();

        private DpapiDataSecurityHandlerHolder() {
        }
    }
}

