/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.i18n.service.impl;

import com.huawei.support.basicconfigservice.I18nCacheService;
import com.huawei.support.icscbb.adapter.i18n.service.I18nService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.stereotype.Service;

@Service
public class I18ServiceImpl
implements I18nService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(I18ServiceImpl.class);
    @Autowired
    private MessageSource messageSource;

    @Override
    public String quoteI18nEntryByKeyAndLang(String querykey, String lang) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{querykey, lang})) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "queryKey or lang cannot be blank.");
            return querykey;
        }
        Locale locale = !lang.equals("zh") && !lang.equals("zh_CN") ? Locale.US : Locale.CHINA;
        String i18nValue = "";
        if (querykey.startsWith("ics.support")) {
            i18nValue = I18nCacheService.getI18nValue((String)querykey, (String)lang);
        } else {
            try {
                i18nValue = this.messageSource.getMessage(querykey, null, locale);
            }
            catch (NoSuchMessageException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "no " + querykey + " in message file", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)i18nValue)) {
            return StringEscapeUtils.escapeHtml4((String)i18nValue);
        }
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "illegal key: " + querykey + " or lang:" + lang);
        return querykey;
    }

    @Override
    public String relpaceLangKey(String htmlstr, String lang) {
        Document document = Jsoup.parse((String)htmlstr);
        Elements elementsWithLangFlag = document.getElementsByClass("langFlag");
        for (Object next : elementsWithLangFlag) {
            String message;
            String attributeValue;
            if (!(next instanceof Element)) continue;
            Element element = (Element)next;
            if (element.hasAttr("placeholder")) {
                attributeValue = element.attr("placeholder");
                message = this.quoteI18nEntryByKeyAndLang(attributeValue, lang);
                element.attr("placeholder", StringEscapeUtils.unescapeHtml4((String)message));
                continue;
            }
            attributeValue = element.text();
            message = this.quoteI18nEntryByKeyAndLang(attributeValue, lang);
            element.text(StringEscapeUtils.unescapeHtml4((String)message));
        }
        return document.getElementsByTag("body").html();
    }
}

