/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.storage.resource;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class PathResourceInitHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(PathResourceInitHandler.class);
    private static final int SUB_TOMCAT_POS = 5;
    private static final int SUB_TRAY_POS = 1;
    private static final int EOF = -1;
    private static final int SUB_APP_POS = 2;
    private static final String ICS_LITE_TRAY_JAR = "icsLiteTray.jar";
    private static final String ICS_LITE_UPGRADER_JAR = "icsLiteUpgrade.jar";
    private String appRootDir;
    private String webAppPath;

    private PathResourceInitHandler() {
        this.initAppRootDirAndWebApp();
    }

    private void initAppRootDirAndWebApp() {
        String projectBinPath = this.getProjectBinPath();
        if (StringUtils.isBlank((CharSequence)projectBinPath)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The ics common is not exists.");
            return;
        }
        String baseDir = StringUtils.endsWithAny((CharSequence)projectBinPath, (CharSequence[])new CharSequence[]{ICS_LITE_TRAY_JAR, ICS_LITE_UPGRADER_JAR}) ? this.getPath(projectBinPath, 1) : this.getPath(projectBinPath, 5);
        this.webAppPath = this.getPath(projectBinPath, 2) + File.separator;
        this.appRootDir = baseDir;
    }

    public static PathResourceInitHandler getInstance() {
        return PathResourceInitHandlerHolder.INSTANCE;
    }

    public String getProjectBinPath() {
        URL url = PathResourceInitHandler.class.getProtectionDomain().getCodeSource().getLocation();
        String filePath = "";
        try {
            filePath = URLDecoder.decode(StringUtils.replace((String)url.getPath(), (String)"+", (String)"%2B"), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Path unsupportedEncodingException.", (Throwable)e);
        }
        File file = FileUtils.getFile((String[])new String[]{filePath});
        if (file == null) {
            return "";
        }
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Path canonical.", (Throwable)e);
        }
        return filePath;
    }

    public String getPath(String str, int num) {
        String result = str;
        for (int index = 0; index <= num; ++index) {
            int lastFirst = result.lastIndexOf(File.separator);
            if (lastFirst == -1) {
                return null;
            }
            result = result.substring(0, lastFirst);
        }
        return result;
    }

    public String getAppRootDir() {
        return this.appRootDir;
    }

    public String getWebAppPath() {
        return this.webAppPath;
    }

    private static class PathResourceInitHandlerHolder {
        private static final PathResourceInitHandler INSTANCE = new PathResourceInitHandler();

        private PathResourceInitHandlerHolder() {
        }
    }
}

