/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.builder;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.Run;
import com.aspose.words.Shape;
import com.huawei.support.icscbb.convert.dto.ParagraphDto;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.awt.Color;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class ParagraphBuilder {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ParagraphBuilder.class);
    private DocumentBuilder documentBuilder;
    private Document document;

    public ParagraphBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
        this.document = documentBuilder.getDocument();
    }

    public void insertBlankParagraph(double height) {
        Paragraph paragraph = this.documentBuilder.insertParagraph();
        paragraph.getParagraphFormat().setLineSpacing(0.0);
        paragraph.getParagraphFormat().setSpaceBefore(height);
    }

    public void insertLeftAlignedTitle(String title) {
        ParagraphDto paragraphDto = new ParagraphDto().setText(title).setLeftIndent(5.0).setSpaceBefore(15.0).setSpaceAfter(10.0).setLineSpacing(12.0).setFontSize(12.0).setBold(true);
        this.insertTextParagraph(paragraphDto);
    }

    public void insertCenterTitle(String title) {
        Paragraph paragraph = this.documentBuilder.insertParagraph();
        this.documentBuilder.getParagraphFormat().clearFormatting();
        this.documentBuilder.getParagraphFormat().setAlignment(1);
        ParagraphDto paragraphDto = new ParagraphDto().setText(title).setSpaceBefore(10.0).setLineSpacing(15.0).setFontSize(20.0).setBold(true);
        this.appendTextChild(paragraphDto, paragraph);
    }

    public void insertContent(String content) {
        ParagraphDto paragraphDto = new ParagraphDto().setText(content).setLeftIndent(5.0).setSpaceBefore(5.0).setLineSpacing(15.0).setFontSize(10.0);
        this.insertTextParagraph(paragraphDto);
    }

    public void insertTextParagraph(ParagraphDto paragraphDto) {
        Paragraph paragraph = this.documentBuilder.insertParagraph();
        this.documentBuilder.getParagraphFormat().clearFormatting();
        this.appendTextChild(paragraphDto, paragraph);
    }

    public void writeCompany(String company) {
        this.documentBuilder.getCurrentSection().getPageSetup().setDifferentFirstPageHeaderFooter(true);
        this.documentBuilder.moveToHeaderFooter(5);
        this.documentBuilder.getParagraphFormat().setAlignment(0);
        Run run = new Run((DocumentBase)this.document, (String)StringUtils.defaultIfBlank((CharSequence)company, (CharSequence)""));
        run.getFont().setSize(12.0);
        run.getFont().setBold(true);
        Paragraph paragraph = this.documentBuilder.insertParagraph();
        paragraph.getParagraphFormat().setLeftIndent(30.0);
        paragraph.getParagraphFormat().setSpaceBefore(10.0);
        paragraph.getParagraphFormat().setSpaceAfter(20.0);
        paragraph.appendChild((Node)run);
        this.documentBuilder.moveToDocumentEnd();
    }

    public void insertImage(InputStream imageIs, double left, double top, double width, double height) {
        try {
            Shape image = this.documentBuilder.insertImage(imageIs, 0, left, 0, top, width, height, 3);
            image.setBehindText(true);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Insert image gets exception.", (Throwable)e);
        }
    }

    public void insertImageParagraph(ParagraphDto paragraphDto, InputStream imageIs, double imageWidth) {
        Paragraph paragraph = this.documentBuilder.insertParagraph();
        this.documentBuilder.getParagraphFormat().clearFormatting();
        try {
            this.documentBuilder.insertImage(imageIs).setWidth(imageWidth);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Insert image gets exception.", (Throwable)e);
        }
        this.appendTextChild(paragraphDto, paragraph);
    }

    public void insertHyperLink(String displayText, String url) {
        this.documentBuilder.getFont().setColor(Color.BLUE);
        this.documentBuilder.getFont().setSize(10.0);
        this.documentBuilder.insertHyperlink(StringUtils.defaultString((String)displayText), StringUtils.defaultString((String)url), false);
    }

    private void appendTextChild(ParagraphDto paragraphDto, Paragraph paragraph) {
        paragraph.getParagraphFormat().setLeftIndent(paragraphDto.getLeftIndent());
        paragraph.getParagraphFormat().setRightIndent(paragraphDto.getRightIndent());
        paragraph.getParagraphFormat().setSpaceBefore(paragraphDto.getSpaceBefore());
        paragraph.getParagraphFormat().setSpaceAfter(paragraphDto.getSpaceAfter());
        paragraph.getParagraphFormat().setLineSpacing(paragraphDto.getLineSpacing());
        Run run = new Run((DocumentBase)this.document, StringUtils.defaultString((String)paragraphDto.getText()));
        run.getFont().setSize(paragraphDto.getFontSize());
        run.getFont().setBold(paragraphDto.isBold());
        paragraph.appendChild((Node)run);
    }
}

