/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.converter;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.FontSettings;
import com.aspose.words.License;
import com.aspose.words.Run;
import com.aspose.words.SaveOptions;
import com.huawei.support.icscbb.convert.config.ConvertConfigHandler;
import com.huawei.support.icscbb.convert.config.ConvertResourceHandler;
import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.dto.HtmlHandleBaseDto;
import com.huawei.support.icscbb.convert.dto.HtmlSaveOptionsDto;
import com.huawei.support.icscbb.convert.entity.ConvertConfigDo;
import com.huawei.support.icscbb.convert.helper.ConvertPathHelper;
import com.huawei.support.icscbb.convert.helper.HtmlConvertMainHelper;
import com.huawei.support.icscbb.convert.helper.StatementHelper;
import com.huawei.support.icscbb.convert.thread.HtmlConvertThread;
import com.huawei.support.icscbb.convert.util.AsposeInitUtils;
import com.huawei.support.icscbb.convert.util.ProgressPropertyUtils;
import com.huawei.support.icscbb.convert.util.StyleUtils;
import com.huawei.support.icscbb.convert.util.WordDocumentUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class HtmlConverter {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HtmlConverter.class);
    private static final Map<String, Integer> HTML_SAVE_FORMAT_MAP = new HashMap<String, Integer>();

    private HtmlConverter() {
    }

    private static void initializeAsposeLicense() {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(AsposeInitUtils.getLicenseContent("<Signature>zaMGjbWR8z0CQloJr73vf0EfnZXH7bDbtnCZy2UabXxc69pAkf5TD1Ml3WZIfgAWva/TPCACvxjsmavsqEfEayYq65AlQOwmKw5S4jcbD4GzFamphXuitJPn3oNl6Blv7uZl0xZDfxsF3pRllZlLJrhGdrx5dvBBNh11pexYcaw=</Signature>").getBytes(StandardCharsets.UTF_8));){
            new License().setLicense((InputStream)inputStream);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Load Aspose License error.", (Throwable)e);
        }
    }

    private static void initSaveFormatMap() {
        HTML_SAVE_FORMAT_MAP.put("doc", 10);
        HTML_SAVE_FORMAT_MAP.put("docx", 20);
        HTML_SAVE_FORMAT_MAP.put("pdf", 40);
        HTML_SAVE_FORMAT_MAP.put("html", 50);
    }

    public static void htmlConvert(HtmlConvertDto convertDto) {
        HtmlConverter.htmlConvert(convertDto, new ConvertConfigDo());
    }

    public static void htmlConvert(HtmlConvertDto convertDto, ConvertConfigDo convertConfigDo) {
        String fileSuffix;
        if (convertDto == null || CollectionUtils.isEmpty(convertDto.getDocumentDtoList()) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{convertDto.getZipFilePath(), convertDto.getSaveFileName(), convertDto.getTempDirectory(), convertDto.getLang()})) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Html convert fail, the params is not enough.");
            return;
        }
        if (!ConvertPathHelper.isInitTempDir(convertDto.getTempDirectory())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Html convert failed, the temp directory and file create failed.");
            return;
        }
        if (IcsFileUtils.isExist((String)convertDto.getFontsDirectory())) {
            FontSettings.getDefaultInstance().setFontsFolder(convertDto.getFontsDirectory(), false);
        }
        if (HTML_SAVE_FORMAT_MAP.containsKey(fileSuffix = FilenameUtils.getExtension((String)convertDto.getSaveFileName()))) {
            HtmlConverter.executeHtmlConvert(convertDto, convertConfigDo, HTML_SAVE_FORMAT_MAP.get(fileSuffix));
        }
    }

    private static void executeHtmlConvert(HtmlConvertDto convertDto, ConvertConfigDo convertConfigDo, int saveFormatType) {
        try {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert task start.");
            Document doc = new Document();
            WordDocumentUtils.setHeadingStyle(doc);
            DocumentBuilder builder = new DocumentBuilder(doc);
            WordDocumentUtils.setCompleteStyle(convertDto.getFileName(), doc, builder, !StringUtils.endsWith((CharSequence)convertDto.getSaveFileName().toLowerCase(Locale.ROOT), (CharSequence)".html"));
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert set complete style for main document.");
            HtmlSaveOptionsDto saveOptionsDto = HtmlConvertMainHelper.getSaveOptions(convertDto, builder, saveFormatType);
            List<Document> subDocumentList = HtmlConverter.executeAllTasks(convertDto, convertConfigDo, saveFormatType, saveOptionsDto);
            HtmlConverter.createDocument(doc, convertDto, saveOptionsDto.getSaveOptions(), saveFormatType, subDocumentList);
            HtmlConverter.setConvertTaskSuccessFlag(ConvertPathHelper.getProgressFileName(convertDto.getTempDirectory()));
        }
        catch (Exception e) {
            HtmlConverter.setConvertTaskFailFlag(ConvertPathHelper.getProgressFileName(convertDto.getTempDirectory()));
        }
    }

    private static Document saveFileWithCoverAndStatement(Document mainDoc, HtmlConvertDto convertDto, SaveOptions saveOptions, int saveFormatType) throws Exception {
        Document finalDoc;
        Optional<Document> optionalDoc = StatementHelper.generateCoverAndStatement(convertDto);
        if (optionalDoc.isPresent()) {
            finalDoc = optionalDoc.get();
            finalDoc.appendDocument(mainDoc, 2);
        } else {
            finalDoc = mainDoc;
        }
        HtmlConverter.updateSaveDocument(convertDto, saveOptions, saveFormatType, finalDoc);
        return finalDoc;
    }

    private static void setConvertTaskSuccessFlag(String progressFileName) {
        ProgressPropertyUtils.updateConvertProgressProperty(progressFileName, "successFlag", "1");
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert task save file success.");
    }

    private static void setConvertTaskFailFlag(String progressFileName) {
        ProgressPropertyUtils.updateConvertProgressProperty(progressFileName, "successFlag", "0");
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Html convert task save file fail.");
    }

    private static List<Document> executeAllTasks(HtmlConvertDto convertDto, ConvertConfigDo convertConfigDo, int saveFormatType, HtmlSaveOptionsDto saveOptionsDto) throws Exception {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert start execute all son tasks.");
        int htmlNumber = convertDto.getDocumentDtoList().size();
        ConvertResourceHandler resourceHandler = HtmlConverter.getResourceHandler(convertConfigDo, htmlNumber);
        CountDownLatch countDownLatch = resourceHandler.getCountDownLatch();
        ThreadPoolExecutor threadPool = resourceHandler.getThreadPool();
        ArrayList<Document> subDocumentList = new ArrayList<Document>();
        int taskNum = resourceHandler.getTaskNum();
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert construct son document,the task num is {0}.", new Object[]{taskNum});
        for (int i = 0; i < taskNum; ++i) {
            Document sonDocument = new Document();
            DocumentBuilder sonDocumentBuilder = new DocumentBuilder(sonDocument);
            WordDocumentUtils.setHeadingStyle(sonDocument);
            int startIndex = i * 1000000;
            int endIndex = Math.min((i + 1) * 1000000, htmlNumber);
            HtmlConvertDto htmlConvertDto = HtmlConverter.constructSplitConvertDto(convertDto, startIndex, endIndex);
            HtmlHandleBaseDto htmlHandleBaseDto = HtmlConverter.constructHandleDto(htmlConvertDto, convertConfigDo, sonDocument, sonDocumentBuilder);
            HtmlConvertThread htmlConvertThread = HtmlConvertMainHelper.getConvertThread(countDownLatch, saveFormatType, htmlHandleBaseDto, saveOptionsDto);
            threadPool.execute(htmlConvertThread);
            subDocumentList.add(sonDocument);
        }
        boolean awaitResult = countDownLatch.await(180L, TimeUnit.MINUTES);
        if (!awaitResult) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert task await timeout.");
        }
        threadPool.shutdownNow();
        return subDocumentList;
    }

    private static HtmlHandleBaseDto constructHandleDto(HtmlConvertDto htmlConvertDto, ConvertConfigDo convertConfigDo, Document sonDocument, DocumentBuilder sonDocumentBuilder) {
        String progressFileName = ConvertPathHelper.getProgressFileName(htmlConvertDto.getTempDirectory());
        int cpuSleepTime = ConvertConfigHandler.getCpuSleepTime(convertConfigDo);
        int cpuMaxThreshold = ConvertConfigHandler.getCpuMaxThreshold(convertConfigDo);
        return new HtmlHandleBaseDto().setHtmlConvertDto(htmlConvertDto).setProgressFileName(progressFileName).setDocument(sonDocument).setBuilder(sonDocumentBuilder).setCpuSleepTime(cpuSleepTime).setCpuMaxThreshold(cpuMaxThreshold);
    }

    private static HtmlConvertDto constructSplitConvertDto(HtmlConvertDto convertDto, int startIndex, int endIndex) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert construct son convertDto,the startIndex is {0},the endIndex is {1}.", new Object[]{startIndex, endIndex});
        HtmlConvertDto subConvertDto = new HtmlConvertDto();
        BeanUtils.copyProperties((Object)convertDto, (Object)subConvertDto);
        subConvertDto.setDocumentDtoList(convertDto.getDocumentDtoList().subList(startIndex, endIndex));
        return subConvertDto;
    }

    private static ConvertResourceHandler getResourceHandler(ConvertConfigDo convertConfigDo, int htmlNumber) {
        int threadNum = ConvertConfigHandler.getThreadNum(convertConfigDo == null ? new ConvertConfigDo() : convertConfigDo);
        int taskNum = htmlNumber % 1000000 == 0 ? htmlNumber / 1000000 : htmlNumber / 1000000 + 1;
        return new ConvertResourceHandler(taskNum, threadNum);
    }

    private static void createDocument(Document mainDoc, HtmlConvertDto convertDto, SaveOptions saveOptions, int saveFormatType, List<Document> subDocumentList) throws Exception {
        if (saveFormatType == 40) {
            HtmlConverter.appendSubDocList(subDocumentList, mainDoc);
            HtmlConverter.saveFileWithCoverAndStatement(mainDoc, convertDto, saveOptions, saveFormatType);
            return;
        }
        HtmlConverter.saveDocumentInBatches(mainDoc, convertDto, saveOptions, saveFormatType, subDocumentList);
    }

    private static void appendSubDocList(List<Document> subDocumentList, Document mainDoc) throws Exception {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert build son document list.");
        Document allDocument = new Document();
        DocumentBuilder allDocumentBuilder = new DocumentBuilder(allDocument);
        subDocumentList.forEach(document -> allDocumentBuilder.insertDocument(document, 1));
        mainDoc.appendDocument(allDocument, 1);
    }

    private static void saveDocumentInBatches(Document mainDoc, HtmlConvertDto convertDto, SaveOptions saveOptions, int saveFormatType, List<Document> subDocumentList) throws Exception {
        mainDoc.appendDocument(subDocumentList.get(0), 1);
        Document dstDocument = HtmlConverter.saveFileWithCoverAndStatement(mainDoc, convertDto, saveOptions, saveFormatType);
        if (!FileUtils.getFile((String[])new String[]{convertDto.getSaveFileName()}).exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Html convert create document with cover and statement fail.");
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert create document in batches.");
        for (int i = 1; i < subDocumentList.size(); ++i) {
            dstDocument.appendDocument(subDocumentList.get(i), 1);
            HtmlConverter.updateSaveDocument(convertDto, saveOptions, saveFormatType, dstDocument);
        }
    }

    private static void updateSaveDocument(HtmlConvertDto convertDto, SaveOptions saveOptions, int saveFormatType, Document finalDoc) throws Exception {
        StyleUtils.setTocStyle(finalDoc, StringUtils.endsWith((CharSequence)convertDto.getSaveFileName(), (CharSequence)".html"));
        finalDoc.getCompatibilityOptions().optimizeFor(7);
        if (saveFormatType == 20 || saveFormatType == 10 || saveFormatType == 50) {
            for (Run run : finalDoc.getChildNodes(21, true)) {
                run.getFont().setName(convertDto.getFontName());
            }
        }
        if (saveFormatType != 50) {
            WordDocumentUtils.setRepeatedTableHead(finalDoc);
        }
        WordDocumentUtils.resizeImgForCells(finalDoc);
        WordDocumentUtils.resetBottomLineForCells(finalDoc);
        finalDoc.updateFields();
        finalDoc.updatePageLayout();
        finalDoc.save(convertDto.getSaveFileName(), saveOptions);
    }

    static {
        HtmlConverter.initializeAsposeLicense();
        HtmlConverter.initSaveFormatMap();
    }
}

