/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.converter.office;

import com.huawei.support.icscbb.convert.converter.office.ConverterFactory;
import com.huawei.support.icscbb.convert.converter.office.OfficeConverter;
import com.huawei.support.icscbb.convert.dto.OfficeConvertDto;
import java.util.Optional;

public class ConverterContext {
    private ConverterContext() {
    }

    public static ConverterContext getInstance() {
        return ConverterContextHolder.INSTANCE;
    }

    public void executeConvert(OfficeConvertDto officeConvertDto) {
        Optional<OfficeConverter> converterOptional = ConverterFactory.getInstance().getConverter(officeConvertDto.getDocType());
        if (!converterOptional.isPresent()) {
            return;
        }
        converterOptional.get().convertToHtml(officeConvertDto);
    }

    private static class ConverterContextHolder {
        private static final ConverterContext INSTANCE = new ConverterContext();

        private ConverterContextHolder() {
        }
    }
}

