/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.converter.office;

import com.huawei.support.icscbb.convert.converter.office.ExcelConverter;
import com.huawei.support.icscbb.convert.converter.office.OfficeConverter;
import com.huawei.support.icscbb.convert.converter.office.PptConverter;
import com.huawei.support.icscbb.convert.converter.office.WordConverter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ConverterFactory {
    private static final Map<String, OfficeConverter> CONVERTER_MAP = new HashMap<String, OfficeConverter>();

    private ConverterFactory() {
    }

    public static ConverterFactory getInstance() {
        return ConverterFactoryHolder.INSTANCE;
    }

    public Optional<OfficeConverter> getConverter(String docType) {
        if (StringUtils.isBlank((CharSequence)docType)) {
            return Optional.empty();
        }
        return Optional.ofNullable(CONVERTER_MAP.get(docType.toLowerCase(Locale.ENGLISH)));
    }

    static {
        WordConverter wordConverter = new WordConverter();
        ExcelConverter excelConverter = new ExcelConverter();
        PptConverter pptConverter = new PptConverter();
        CONVERTER_MAP.put("doc", wordConverter);
        CONVERTER_MAP.put("docx", wordConverter);
        CONVERTER_MAP.put("docm", wordConverter);
        CONVERTER_MAP.put("xls", excelConverter);
        CONVERTER_MAP.put("xlsx", excelConverter);
        CONVERTER_MAP.put("xlsm", excelConverter);
        CONVERTER_MAP.put("xlsb", excelConverter);
        CONVERTER_MAP.put("ppt", pptConverter);
        CONVERTER_MAP.put("pptx", pptConverter);
        CONVERTER_MAP.put("pptm", pptConverter);
    }

    private static class ConverterFactoryHolder {
        private static final ConverterFactory INSTANCE = new ConverterFactory();

        private ConverterFactoryHolder() {
        }
    }
}

