/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.converter.office;

import com.aspose.cells.FontConfigs;
import com.aspose.cells.License;
import com.aspose.cells.Workbook;
import com.huawei.support.icscbb.convert.converter.office.OfficeConverter;
import com.huawei.support.icscbb.convert.dto.OfficeConvertDto;
import com.huawei.support.icscbb.convert.util.AsposeInitUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class ExcelConverter
implements OfficeConverter {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(ExcelConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertToHtml(OfficeConvertDto officeConvertDto) {
        String destPath = officeConvertDto.getDestPath();
        CodeCCUtils.INSTANCE.infoLog(LOG, "ExcelConverter convertToHtml convert to {0} start.", new Object[]{destPath});
        if (IcsFileUtils.isExist((String)officeConvertDto.getFontsDir())) {
            FontConfigs.setFontFolder((String)officeConvertDto.getFontsDir(), (boolean)false);
        }
        Workbook excel = null;
        try (InputStream sourceInputStream = ZipFilePool.getInputStream((String)officeConvertDto.getLibPath(), (String)officeConvertDto.getFilePath());){
            excel = new Workbook(sourceInputStream);
            excel.save(destPath, 12);
        }
        catch (Exception e) {
            IcsFileUtils.delFile((String)destPath);
            CodeCCUtils.INSTANCE.errorLog(LOG, "ExcelConverter convertToHtml is error.", (Throwable)e);
        }
        finally {
            if (excel != null) {
                excel.dispose();
            }
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "ExcelConverter convertToHtml convert to {0} end.", new Object[]{destPath});
    }

    static {
        new License().setLicense((InputStream)new ByteArrayInputStream(AsposeInitUtils.getLicenseContent("<Signature>zaMGjbWR8z0CQloJr73vf0EfnZXH7bDbtnCZy2UabXxc69pAkf5TD1Ml3WZIfgAWva/TPCACvxjsmavsqEfEayYq65AlQOwmKw5S4jcbD4GzFamphXuitJPn3oNl6Blv7uZl0xZDfxsF3pRllZlLJrhGdrx5dvBBNh11pexYcaw=</Signature>").getBytes(StandardCharsets.UTF_8)));
    }
}

