/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.converter.office;

import com.aspose.slides.FontsLoader;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideCollection;
import com.aspose.slides.License;
import com.aspose.slides.LoadOptions;
import com.aspose.slides.OleObjectFrame;
import com.aspose.slides.Presentation;
import com.huawei.support.icscbb.convert.converter.office.OfficeConverter;
import com.huawei.support.icscbb.convert.dto.OfficeConvertDto;
import com.huawei.support.icscbb.convert.util.AsposeInitUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PptConverter
implements OfficeConverter {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(PptConverter.class);
    private static final String DEFAULT_FONT_ASIAN = "SimSun";
    private static final int MAX_PAGE_NUM = 300;
    private static LoadOptions loadOptions;

    private static void deleteErrTitleOleObj(Presentation ppt) {
        ISlideCollection slides = ppt.getSlides();
        int slidesSize = slides.size();
        for (int i = 0; i < slidesSize; ++i) {
            ISlide iSlide = slides.get_Item(i);
            IShapeCollection iShapeCollection = iSlide.getShapes();
            for (IShape prepareDelShape : PptConverter.getPrepareDelShapes(iShapeCollection)) {
                iShapeCollection.remove(prepareDelShape);
            }
        }
    }

    private static List<IShape> getPrepareDelShapes(IShapeCollection iShapeCollection) {
        ArrayList<IShape> prepareDelShapes = new ArrayList<IShape>();
        for (IShape shape : iShapeCollection) {
            OleObjectFrame ole;
            if (!(shape instanceof OleObjectFrame) || !StringUtils.isNotBlank((CharSequence)(ole = (OleObjectFrame)shape).getSubstitutePictureTitle())) continue;
            prepareDelShapes.add((IShape)ole);
        }
        return prepareDelShapes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertToHtml(OfficeConvertDto officeConvertDto) {
        String destPath = officeConvertDto.getDestPath();
        CodeCCUtils.INSTANCE.infoLog(LOG, "PptConverter convertToHtml convert to {0} start.", new Object[]{destPath});
        if (IcsFileUtils.isExist((String)officeConvertDto.getFontsDir())) {
            FontsLoader.loadExternalFonts((String[])new String[]{officeConvertDto.getFontsDir()});
        }
        Presentation ppt = null;
        try (InputStream sourceInputStream = ZipFilePool.getInputStream((String)officeConvertDto.getLibPath(), (String)officeConvertDto.getFilePath());){
            ppt = new Presentation(sourceInputStream, loadOptions);
            int pageCount = ppt.getSlides().size();
            if (pageCount > 300) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "The convert pageCount exceed limit, pageCount: {0}, maxPageCount: {1}", new Object[]{pageCount, 300});
                return;
            }
            PptConverter.deleteErrTitleOleObj(ppt);
            ppt.save(destPath, 13);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "PptConverter convertToHtml is error.", (Throwable)e);
        }
        finally {
            if (ppt != null) {
                ppt.dispose();
            }
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "PptConverter convertToHtml convert to {0} end.", new Object[]{destPath});
    }

    static {
        new License().setLicense((InputStream)new ByteArrayInputStream(AsposeInitUtils.getLicenseContent("<Signature>zaMGjbWR8z0CQloJr73vf0EfnZXH7bDbtnCZy2UabXxc69pAkf5TD1Ml3WZIfgAWva/TPCACvxjsmavsqEfEayYq65AlQOwmKw5S4jcbD4GzFamphXuitJPn3oNl6Blv7uZl0xZDfxsF3pRllZlLJrhGdrx5dvBBNh11pexYcaw=</Signature>").getBytes(StandardCharsets.UTF_8)));
        loadOptions = new LoadOptions();
        loadOptions.getBlobManagementOptions().setPresentationLockingBehavior(1);
        loadOptions.getBlobManagementOptions().setTemporaryFilesAllowed(true);
        loadOptions.setDefaultAsianFont(DEFAULT_FONT_ASIAN);
    }
}

