/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.converter.office;

import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.License;
import com.aspose.words.SaveOptions;
import com.aspose.words.Section;
import com.huawei.support.icscbb.convert.converter.office.OfficeConverter;
import com.huawei.support.icscbb.convert.dto.OfficeConvertDto;
import com.huawei.support.icscbb.convert.util.AsposeInitUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WordConverter
implements OfficeConverter {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(WordConverter.class);
    private static final List<Integer> HEADER_FOOTER_TYPE_LIST = Collections.unmodifiableList(Arrays.asList(4, 5, 1, 3, 0, 2));

    private static void removeHeadersFooters(Section section) {
        for (Integer headerFooterType : HEADER_FOOTER_TYPE_LIST) {
            HeaderFooter headerFooter = section.getHeadersFooters().getByHeaderFooterType(headerFooterType.intValue());
            if (headerFooter == null) continue;
            headerFooter.remove();
        }
    }

    @Override
    public void convertToHtml(OfficeConvertDto officeConvertDto) {
        String destPath = officeConvertDto.getDestPath();
        CodeCCUtils.INSTANCE.infoLog(LOG, "WordConverter convertToHtml convert to {0} start.", new Object[]{destPath});
        if (IcsFileUtils.isExist((String)officeConvertDto.getFontsDir())) {
            FontSettings.getDefaultInstance().setFontsFolder(officeConvertDto.getFontsDir(), false);
        }
        try (InputStream sourceInputStream = ZipFilePool.getInputStream((String)officeConvertDto.getLibPath(), (String)officeConvertDto.getFilePath());){
            Document document = new Document(sourceInputStream);
            for (Section section : document.getSections()) {
                WordConverter.removeHeadersFooters(section);
            }
            HtmlSaveOptions options = new HtmlSaveOptions();
            options.setUseHighQualityRendering(true);
            options.setExportImagesAsBase64(true);
            options.setHtmlVersion(1);
            document.save(destPath, (SaveOptions)options);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "WordConverter convertToHtml is error.", (Throwable)e);
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "WordConverter convertToHtml convert to {0} end.", new Object[]{destPath});
    }

    static {
        try (ByteArrayInputStream licenseStream = new ByteArrayInputStream(AsposeInitUtils.getLicenseContent("<Signature>zaMGjbWR8z0CQloJr73vf0EfnZXH7bDbtnCZy2UabXxc69pAkf5TD1Ml3WZIfgAWva/TPCACvxjsmavsqEfEayYq65AlQOwmKw5S4jcbD4GzFamphXuitJPn3oNl6Blv7uZl0xZDfxsF3pRllZlLJrhGdrx5dvBBNh11pexYcaw=</Signature>").getBytes(StandardCharsets.UTF_8));){
            new License().setLicense((InputStream)licenseStream);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "WordConverter aspose license is illegal.", (Throwable)e);
        }
    }
}

