/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.helper;

import com.aspose.words.LoadOptions;
import com.huawei.support.icscbb.convert.constant.ProgressConstants;
import com.huawei.support.icscbb.convert.dto.HtmlDocumentDto;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ConvertPathHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ConvertPathHelper.class);
    private static final String IMAGE_TEMP_DIR_PATH = File.separator + "image";
    private static final String CONVERT_TEMP_DIR_PATH_FOR_BIG_FILE = File.separator + "temp";

    private ConvertPathHelper() {
    }

    public static boolean isInitTempDir(String totalTempDir) {
        if (FileUtils.getFile((String[])new String[]{totalTempDir}).exists()) {
            return ConvertPathHelper.initTempSonDirs(totalTempDir);
        }
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Convert total temp directory is not exists.");
        return false;
    }

    private static boolean initTempSonDirs(String totalTempDir) {
        return ConvertPathHelper.initImageTempFolder(totalTempDir) && ConvertPathHelper.initLoadOptionsTempFolder(totalTempDir);
    }

    private static boolean initImageTempFolder(String totalTempDir) {
        String imageTempDirPath = ConvertPathHelper.getImageTempDir(totalTempDir);
        return ConvertPathHelper.initTempFolder(imageTempDirPath);
    }

    private static boolean initLoadOptionsTempFolder(String totalTempDir) {
        String convertTempDirPath = ConvertPathHelper.getConvertTempDir(totalTempDir);
        if (ConvertPathHelper.initTempFolder(convertTempDirPath)) {
            new LoadOptions().setTempFolder(convertTempDirPath);
            return true;
        }
        return false;
    }

    public static boolean initTempFolder(String tempDir) {
        File tempFile = FileUtils.getFile((String[])new String[]{tempDir});
        FileUtils.deleteQuietly((File)tempFile);
        return tempFile.mkdir();
    }

    public static String getImageTempDir(String tempDirectoryPath) {
        return tempDirectoryPath + IMAGE_TEMP_DIR_PATH;
    }

    public static String getConvertTempDir(String tempDirectoryPath) {
        return tempDirectoryPath + CONVERT_TEMP_DIR_PATH_FOR_BIG_FILE;
    }

    public static String getProgressFileName(String totalTempFolder) {
        return totalTempFolder + ProgressConstants.CONVERT_PROGRESS_FILE_NAME;
    }

    public static void normalizeNumber(List<HtmlDocumentDto> htmlList) {
        if (CollectionUtils.isEmpty(htmlList)) {
            return;
        }
        TreeMap<String, String> preMap = new TreeMap<String, String>();
        int bigNum = 1;
        for (HtmlDocumentDto convertDocumentDto : htmlList) {
            String newPosition;
            if (preMap.isEmpty()) {
                String newPosition2 = bigNum + "";
                preMap.put(convertDocumentDto.getNaviPosition(), newPosition2);
                convertDocumentDto.setNaviPosition(newPosition2);
                ++bigNum;
                continue;
            }
            boolean findPrefix = false;
            String maxMatchPrefix = "";
            for (Map.Entry mapEntry : preMap.entrySet()) {
                String position = (String)mapEntry.getKey();
                if (!convertDocumentDto.getNaviPosition().startsWith(position)) continue;
                maxMatchPrefix = position;
                findPrefix = true;
            }
            if (findPrefix) {
                newPosition = convertDocumentDto.getNaviPosition().replace(maxMatchPrefix, (CharSequence)preMap.get(maxMatchPrefix));
                preMap.put(convertDocumentDto.getNaviPosition(), newPosition);
                convertDocumentDto.setNaviPosition(newPosition);
                continue;
            }
            newPosition = bigNum + "";
            preMap.put(convertDocumentDto.getNaviPosition(), newPosition);
            convertDocumentDto.setNaviPosition(newPosition);
            ++bigNum;
        }
    }

    public static int getDocumentBreakType(String dirTreePosition) {
        if (StringUtils.isBlank((CharSequence)dirTreePosition)) {
            return 1;
        }
        int breakType = dirTreePosition.split("\\.").length;
        if (breakType > 9) {
            breakType = 9;
        }
        if (breakType < 1) {
            breakType = 1;
        }
        return breakType;
    }
}

