/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.helper;

import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.dto.HtmlCreateDto;
import com.huawei.support.icscbb.convert.dto.HtmlDocumentDto;
import com.huawei.support.icscbb.convert.dto.HtmlHandleBaseDto;
import com.huawei.support.icscbb.convert.dto.HtmlHandlePdfDto;
import com.huawei.support.icscbb.convert.helper.ConvertPathHelper;
import com.huawei.support.icscbb.convert.util.CssUtils;
import com.huawei.support.icscbb.convert.util.ProgressPropertyUtils;
import com.huawei.support.icscbb.convert.util.WordDocumentUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class HtmlConvertHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HtmlConvertHelper.class);
    private static final int DECIMAL_SCALE = 2;
    private static final int PERCENTAGE = 100;
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    private HtmlConvertHelper() {
    }

    /*
     * Exception decompiling
     */
    private static String getNewHtmlStr(HtmlCreateDto htmlCreateDto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static HtmlCreateDto getInitCreateHtmlDto(HtmlHandleBaseDto htmlHandleBaseDto, HtmlDocumentDto htmlDocumentDto) {
        HtmlCreateDto htmlCreateDto = new HtmlCreateDto();
        htmlCreateDto.setZipFilePath((String)StringUtils.defaultIfBlank((CharSequence)htmlDocumentDto.getTopicZipFilePath(), (CharSequence)htmlHandleBaseDto.getHtmlConvertDto().getZipFilePath()));
        htmlCreateDto.setTopicUrl(htmlDocumentDto.getDocRelativeName());
        htmlCreateDto.setImageFolder(ConvertPathHelper.getImageTempDir(htmlHandleBaseDto.getHtmlConvertDto().getTempDirectory()));
        String css = (String)StringUtils.defaultIfBlank((CharSequence)htmlHandleBaseDto.getHtmlConvertDto().getCss(), (CharSequence)CssUtils.getCustomizedCss());
        htmlCreateDto.setCssContent(css);
        return htmlCreateDto;
    }

    public static void handleHtmlListMain(HtmlHandleBaseDto htmlHandleBaseDto) throws Exception {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert start handle son html list.");
        if (htmlHandleBaseDto == null || htmlHandleBaseDto.getHtmlConvertDto() == null) {
            return;
        }
        HtmlConvertDto convertDto = htmlHandleBaseDto.getHtmlConvertDto();
        for (HtmlDocumentDto htmlDocumentDto : convertDto.getDocumentDtoList()) {
            HtmlCreateDto htmlDto = HtmlConvertHelper.getInitCreateHtmlDto(htmlHandleBaseDto, htmlDocumentDto);
            String newHtmlStr = HtmlConvertHelper.getNewHtmlStr(htmlDto);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Get new html string.");
            int headingLevel = ConvertPathHelper.getDocumentBreakType(htmlDocumentDto.getNaviPosition());
            if (htmlHandleBaseDto instanceof HtmlHandlePdfDto) {
                HtmlHandlePdfDto handleHtmlPdfDto = (HtmlHandlePdfDto)htmlHandleBaseDto;
                WordDocumentUtils.insertDocumentWithBookmark(handleHtmlPdfDto.getBuilder(), handleHtmlPdfDto.getOutlineLevelCollection(), htmlDocumentDto, headingLevel, newHtmlStr);
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Pdf insert son document.");
            } else {
                WordDocumentUtils.insertDocument(htmlHandleBaseDto.getBuilder(), htmlDocumentDto, headingLevel, newHtmlStr);
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Word insert son document.");
            }
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Handled topic html.");
            ProgressPropertyUtils.updateFinishedNum(htmlHandleBaseDto.getProgressFileName());
            HtmlConvertHelper.cpuSleep(htmlHandleBaseDto.getCpuSleepTime(), htmlHandleBaseDto.getCpuMaxThreshold());
        }
        WordDocumentUtils.setCompleteStyle(convertDto.getFileName(), htmlHandleBaseDto.getDocument(), htmlHandleBaseDto.getBuilder(), !StringUtils.endsWith((CharSequence)convertDto.getSaveFileName(), (CharSequence)".html"));
        if (htmlHandleBaseDto instanceof HtmlHandlePdfDto) {
            WordDocumentUtils.replaceSymbolFontForPdf(htmlHandleBaseDto.getDocument());
        }
    }

    private static int getCpuUsage() {
        BigDecimal cpuLoadRate = new BigDecimal(String.valueOf(OPERATING_SYSTEM_MX_BEAN.getSystemCpuLoad()));
        return cpuLoadRate.setScale(2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).intValue();
    }

    private static void cpuSleep(int cpuSleepTime, int cpuMaxThreshold) {
        if (HtmlConvertHelper.getCpuUsage() <= cpuMaxThreshold) {
            return;
        }
        try {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Convert Cpu exceed threshold.");
            TimeUnit.MILLISECONDS.sleep(cpuSleepTime);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Convert Cpu Sleep error.", (Throwable)e);
        }
    }
}

